/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.apache;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.apache.ApacheListen;
import org.hyperic.hq.plugin.apache.ApacheVHost;
import org.hyperic.hq.product.PluginException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheConf {
    private String config;
    private static final Pattern virtualHostPatter = Pattern.compile("<VirtualHost ([^>]*)>", 2);
    private static final Pattern serverNamePatter = Pattern.compile("ServerName (.*)", 2);
    private static final Pattern serverRootPatter = Pattern.compile("ServerRoot \"?([^\\s|\"]*)\"?", 2);
    private static final Pattern includePatter = Pattern.compile("Include (.*)", 2);
    private static final Pattern ipPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}", 2);
    private static final Log log = LogFactory.getLog(ApacheConf.class);

    public ApacheConf(File configFile) throws PluginException {
        try {
            this.config = ApacheConf.readFile(configFile);
            File serverRoot = ApacheConf.findServerRoot(this.config);
            this.config = ApacheConf.replaceIncludes(this.config, serverRoot);
        }
        catch (IOException ex) {
            throw new PluginException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Map<String, ApacheVHost> getVHosts() throws PluginException, IOException {
        HashMap<String, ApacheVHost> vHosts = new HashMap<String, ApacheVHost>();
        int idx = 0;
        while ((idx = this.config.indexOf("<VirtualHost", idx)) > 0) {
            int idxEnd = this.config.indexOf("</VirtualHost>", idx);
            vHosts.putAll(ApacheConf.parseVirtualHost(this.config.substring(idx, idxEnd)));
            idx = idxEnd;
        }
        return vHosts;
    }

    public static Map<String, ApacheVHost> parseVirtualHost(String vhTag) {
        HashMap<String, ApacheVHost> vHost = new HashMap<String, ApacheVHost>();
        Matcher mach = virtualHostPatter.matcher(vhTag);
        if (mach.find()) {
            String addrs = mach.group(1);
            String serverName = ApacheConf.getServerName(vhTag);
            List addrsList = Arrays.asList((Object[])addrs.split(" "));
            for (String listen : addrsList) {
                ApacheListen l = ApacheConf.parseListen(listen);
                ApacheVHost vh = new ApacheVHost(l.getName(), l.getIp(), l.getPort(), serverName);
                log.debug((Object)("[getVHosts] vHost=" + vh + " (" + l + ")"));
                vHost.put(vh.getServerName(), vh);
            }
        }
        return vHost;
    }

    public static ApacheListen parseListen(String l) {
        String ip = null;
        String name = null;
        String port = null;
        if (l.contains(":")) {
            String[] comp = l.split(":");
            String ipName = comp[0];
            port = comp[1];
            Matcher m = ipPattern.matcher(ipName);
            if (m.matches()) {
                ip = ipName;
                name = ApacheConf.getHostAddress(ipName);
            } else {
                ip = ApacheConf.getAddress(ipName);
                name = ipName;
            }
        } else {
            port = l;
        }
        ApacheListen listen = new ApacheListen(name, ip, port);
        return listen;
    }

    private static File findServerRoot(String config) throws PluginException {
        File sr = null;
        Matcher match = serverRootPatter.matcher(config);
        while (match.find() && sr == null) {
            log.debug((Object)("[findServerRoot] " + match.group()));
            sr = new File(match.group(1));
            if (sr.exists() && sr.isDirectory()) continue;
            sr = null;
        }
        if (sr == null) {
            throw new PluginException("Direcive 'ServerRoot' not found");
        }
        return sr;
    }

    private static String getServerName(String txt) {
        String serverName = "";
        Matcher m = serverNamePatter.matcher(txt);
        while (m.find()) {
            serverName = m.group(1).trim();
        }
        return serverName;
    }

    private static String replaceIncludes(String config, File serverRoot) throws IOException {
        Matcher mach = includePatter.matcher(config);
        StringBuffer newConf = new StringBuffer();
        while (mach.find()) {
            File cf;
            log.debug((Object)("[replaceIncludes] found:'" + mach.group() + "'"));
            String found = mach.group(1);
            String pattern = null;
            if (ApacheConf.isFnmatch(found)) {
                int idx = found.lastIndexOf("/");
                pattern = found.substring(idx + 1);
                found = found.substring(0, idx);
            }
            if (!(cf = new File(found)).isAbsolute()) {
                cf = new File(serverRoot, found);
            }
            if (cf.exists()) {
                CharSequence replace;
                if (cf.isFile()) {
                    log.debug((Object)("[replaceIncludes] Including file: '" + cf + "'"));
                    String includeConfig = ApacheConf.readFile(cf);
                    includeConfig = Matcher.quoteReplacement(includeConfig);
                    replace = ApacheConf.replaceIncludes(includeConfig, serverRoot);
                    mach.appendReplacement(newConf, (String)replace);
                }
                if (!cf.isDirectory()) continue;
                List<File> files = ApacheConf.listFiles(cf);
                log.debug((Object)("[replaceIncludes] Browsing directory: '" + cf + "' (" + files.size() + " files)"));
                replace = new StringBuilder();
                for (File file : files) {
                    if (pattern == null || ApacheConf.fnmatch(pattern, file.getName())) {
                        log.debug((Object)("[replaceIncludes] Including file: '" + file + "'"));
                        String includeConfig = ApacheConf.readFile(file);
                        includeConfig = Matcher.quoteReplacement(includeConfig);
                        ((StringBuilder)replace).append(ApacheConf.replaceIncludes(includeConfig, serverRoot));
                        continue;
                    }
                    log.debug((Object)("[replaceIncludes] Ignoring file:  '" + file + "' pattern='" + pattern + "'"));
                }
                mach.appendReplacement(newConf, ((StringBuilder)replace).toString());
                continue;
            }
            log.debug((Object)("[replaceIncludes] File Not Found!! '" + cf + "'"));
        }
        mach.appendTail(newConf);
        return newConf.toString();
    }

    private static List<File> listFiles(File dir) {
        File[] ls;
        ArrayList<File> files = new ArrayList<File>();
        for (File file : ls = dir.listFiles()) {
            if (file.isDirectory()) {
                files.addAll(ApacheConf.listFiles(file));
                continue;
            }
            files.add(file);
        }
        return files;
    }

    private static boolean isFnmatch(String pattern) {
        if (pattern.contains("*") || pattern.contains("*")) {
            return true;
        }
        if (pattern.contains("[") || pattern.contains("]")) {
            return true;
        }
        return pattern.contains("\\") && !pattern.endsWith("\\");
    }

    public static boolean fnmatch(String pattern, String filename) {
        Pattern p;
        if (filename.startsWith(".") && !pattern.startsWith(".")) {
            return false;
        }
        if (filename.contains("/.") && !pattern.contains("/.")) {
            return false;
        }
        pattern = pattern.replace("?", ".");
        pattern = pattern.replace("*", ".*");
        pattern = pattern.replaceAll("\\\\(\\w)", "$1");
        pattern = pattern.replace("[!", "[^");
        try {
            p = Pattern.compile(pattern + "$");
        }
        catch (PatternSyntaxException ex) {
            log.debug((Object)ex, (Throwable)ex);
            return false;
        }
        Matcher m = p.matcher(filename);
        return m.matches();
    }

    private static String readFile(File file) throws IOException {
        String line;
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.length() <= 0) continue;
            out.append(line).append('\n');
        }
        return out.toString();
    }

    private static String getHostAddress(String ip) {
        try {
            return InetAddress.getByAddress(ApacheConf.getIpAsArrayOfByte(ip)).getHostName();
        }
        catch (UnknownHostException ex) {
            return ex.toString();
        }
    }

    private static String getAddress(String name) {
        try {
            return ApacheConf.getIpAsString(InetAddress.getByName(name).getAddress());
        }
        catch (UnknownHostException ex) {
            return ex.toString();
        }
    }

    private static String getIpAsString(byte[] rawBytes) {
        int i = 4;
        StringBuilder ipAddress = new StringBuilder();
        for (byte raw : rawBytes) {
            ipAddress.append(raw & 0xFF);
            if (--i <= 0) continue;
            ipAddress.append(".");
        }
        return ipAddress.toString();
    }

    private static byte[] getIpAsArrayOfByte(String ipAddress) {
        StringTokenizer st = new StringTokenizer(ipAddress, ".");
        byte[] ip = new byte[4];
        int i = 0;
        while (st.hasMoreTokens()) {
            ip[i++] = (byte)Integer.parseInt(st.nextToken());
        }
        return ip;
    }
}

