/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.apache;

import org.hyperic.hq.product.LogFileTailPlugin;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.sigar.FileInfo;

public class ApacheErrorLogPlugin
extends LogFileTailPlugin {
    private static final String[] LOG_LEVELS = new String[]{"emerg,alert,crit,error", "warn", "info,notice", "debug"};

    public String[] getLogLevelAliases() {
        return LOG_LEVELS;
    }

    public TrackEvent processLine(FileInfo info, String line) {
        ApacheErrorLogEntry entry = new ApacheErrorLogEntry();
        if (!entry.parse(line)) {
            return null;
        }
        return this.newTrackEvent(System.currentTimeMillis(), entry.level.toLowerCase(), info.getName(), entry.message);
    }

    class ApacheErrorLogEntry {
        String message;
        String timeStamp;
        String level;

        ApacheErrorLogEntry() {
        }

        public boolean parse(String line) {
            if (line.charAt(0) != '[') {
                return false;
            }
            int ix = line.indexOf("]");
            if (ix == -1) {
                return false;
            }
            this.timeStamp = line.substring(1, ix);
            ++ix;
            while (line.charAt(ix) == ' ') {
                ++ix;
            }
            if ((line = line.substring(ix)).charAt(0) != '[') {
                return false;
            }
            ix = line.indexOf("]");
            if (ix == -1) {
                return false;
            }
            this.level = line.substring(1, ix);
            ++ix;
            while (line.charAt(ix) == ' ') {
                ++ix;
            }
            this.message = line.substring(ix);
            return true;
        }
    }
}

