/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.wsmq.cmd;

import com.ibm.mq.MQException;
import com.ibm.mq.pcf.PCFMessage;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.hyperic.hq.plugin.wsmq.cmd.InquireDefault;
import org.hyperic.hq.product.MetricUnreachableException;

public class InquireQManager
extends InquireDefault {
    private static final int[] ATTRS = new int[]{1149, 1230};
    private static final List ATTR_NAMES = Arrays.asList("Availability", "ConnectionCount");

    public PCFMessage getRequest(Properties properties) {
        PCFMessage msg = new PCFMessage(161);
        msg.addParameter(1229, ATTRS);
        return msg;
    }

    public int[] getAttributes() {
        return ATTRS;
    }

    public List getAttributesName() {
        return ATTR_NAMES;
    }

    public double processPCFExceptionForAvail(MQException e) throws MetricUnreachableException {
        throw new MetricUnreachableException(e.getMessage(), (Throwable)e);
    }

    public double processValue(String metricName, PCFMessage[] responses) {
        assert (responses.length == 1) : responses.length;
        int attr = this.getAttributes()[this.getAttributesName().indexOf(metricName)];
        return ((Integer)responses[0].getParameterValue(attr)).intValue();
    }

    public double getAvail(PCFMessage[] responses) {
        int res = (Integer)responses[0].getParameterValue(1149);
        this.getLog().debug((Object)("getAvail => res=" + res));
        switch (res) {
            case 2: {
                res = 1;
                break;
            }
            case 1: 
            case 3: {
                res = 0;
                break;
            }
            default: {
                res = 0;
            }
        }
        return res;
    }
}

