/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.apache;

import java.io.File;
import java.util.List;
import org.hyperic.hq.plugin.apache.ApacheBinaryInfo;
import org.hyperic.hq.plugin.apache.ApacheServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.RegistryServerDetector;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.util.config.ConfigResponse;

public class Apache20ServerDetector
extends ApacheServerDetector
implements RegistryServerDetector {
    public List getServerResources(ConfigResponse platformConfig, String path, RegistryKey current) throws PluginException {
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        String binary = null;
        for (int i = 0; i < WIN32_EXES.length; ++i) {
            File exe = new File(path, "/bin/" + WIN32_EXES[i] + ".exe");
            if (!exe.exists()) continue;
            binary = exe.getPath();
            break;
        }
        if (binary == null) {
            return null;
        }
        return this.getServerList(path, current.getSubKeyName(), ApacheBinaryInfo.getInfo(binary));
    }
}

