/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.apache;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.apache.ApacheBinaryInfo;
import org.hyperic.hq.plugin.apache.ApacheConf;
import org.hyperic.hq.plugin.apache.ApacheListen;
import org.hyperic.hq.plugin.apache.ApacheSNMP;
import org.hyperic.hq.plugin.apache.ApacheVHost;
import org.hyperic.hq.plugin.apache.JkStatusCollector;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.ConfigFileTrackPlugin;
import org.hyperic.hq.product.DaemonDetector;
import org.hyperic.hq.product.FileServerDetector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.LogFileTrackPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.snmp.SNMPException;
import org.hyperic.util.config.ConfigResponse;

public class ApacheServerDetector
extends DaemonDetector
implements FileServerDetector,
AutoServerDetector {
    static final String TYPE_HTTPD = "Apache httpd";
    static final String DEFAULT_SERVICE_NAME = "Apache2";
    static final String VHOST_NAME = "VHost";
    static final String PROP_SERVER_NAME = "server.name";
    static final String PROP_SERVER_PORT = "server.port";
    static final String[] PTQL_QUERIES = new String[]{"State.Name.eq=httpd,State.Name.Pne=$1", "State.Name.eq=apache2,State.Name.Pne=$1", "State.Name.eq=apache,State.Name.Pne=$1", "State.Name.eq=httpd2-worker,State.Name.Pne=$1", "State.Name.eq=httpd2-prefork,State.Name.Pne=$1"};
    private static final String SERVICE_ARGS = ",Args.1.Peq=-k,Args.2.Peq=runservice";
    static final String[] WIN32_EXES = new String[]{"Apache", "httpd"};
    static final String[] PTQL_QUERIES_WIN32 = new String[]{"State.Name.eq=" + WIN32_EXES[0] + ",Args.1.Peq=-k,Args.2.Peq=runservice", "State.Name.eq=" + WIN32_EXES[1] + ",Args.1.Peq=-k,Args.2.Peq=runservice"};
    private static Log log = LogFactory.getLog((String)"ApacheServerDetector");
    private static String[] defaultConfs = new String[]{"conf/httpd.conf", "conf/httpsd.conf"};
    private Properties props;
    private String defaultIp;
    private PortRange httpRange;
    private PortRange httpsRange;
    private boolean discoverModStatus;
    private boolean discoverModSnmp;

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this.props = manager.getProperties();
        this.defaultIp = this.props.getProperty("apache.listenAddress", "localhost");
        this.httpRange = new PortRange(this.props.getProperty("apache.http.ports"));
        this.httpsRange = new PortRange(this.props.getProperty("apache.https.ports"));
        this.discoverModSnmp = "true".equals(this.props.getProperty("apache.discover.mod_snmp"));
        this.discoverModStatus = !"false".equals(this.props.getProperty("apache.discover.mod_status")) && !this.discoverModSnmp;
    }

    private String getConfigValue(String value) {
        if (value == null) {
            return null;
        }
        if (value.charAt(0) != '/') {
            return value;
        }
        StringTokenizer tok = new StringTokenizer(value, ",");
        while (tok.hasMoreTokens()) {
            String file = tok.nextToken();
            if (!this.exists(file)) continue;
            return file;
        }
        return null;
    }

    protected String getConfigProperty(String name, String defval) {
        String key = "httpd." + name;
        String val = this.getManager().getProperty(key);
        if (val != null) {
            log.debug((Object)("ConfigProperty: " + key + "==" + val));
            return val;
        }
        Properties props = this.getProperties();
        OperatingSystem os = OperatingSystem.getInstance();
        String[] prefix = new String[]{os.getVendor(), os.getName()};
        for (int i = 0; i < prefix.length; ++i) {
            key = prefix[i] + "." + name;
            val = this.getConfigValue(props.getProperty(key));
            if (val == null) continue;
            log.debug((Object)("ConfigProperty: " + key + "==" + val));
            return val;
        }
        return defval;
    }

    protected String getConfigProperty(String name) {
        return this.getConfigProperty(name, null);
    }

    private void getServerInfo(ApacheBinaryInfo info, String[] args) {
        String nameProp = "-Dhq.name=";
        String root = null;
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-d")) {
                root = arg.substring(2, arg.length());
                if (root.length() != 0) continue;
                root = args[i + 1];
                continue;
            }
            if (arg.startsWith("-f")) {
                info.conf = arg.substring(2, arg.length());
                if (info.conf.length() != 0) continue;
                info.conf = args[i + 1];
                continue;
            }
            if (!arg.startsWith("-Dhq.name=")) continue;
            info.name = arg.substring("-Dhq.name=".length(), arg.length());
        }
        if (root != null) {
            info.root = root;
        }
        if (info.conf != null) {
            File conf = new File(info.conf);
            if (!conf.isAbsolute() && info.root != null) {
                conf = new File(info.root, info.conf);
            }
            if (!conf.exists()) {
                info.conf = null;
            }
        } else {
            for (String conf : defaultConfs) {
                File cf = new File(info.root, conf);
                if (!cf.exists() || !cf.isFile()) continue;
                info.conf = cf.getAbsolutePath();
            }
        }
        log.debug((Object)("[getServerInfo] info.conf=" + info.conf + ", info.root=" + info.root + ", info.name=" + info.name));
    }

    private String findAbsoluteExe(String httpd, String[] args) {
        ApacheBinaryInfo info = new ApacheBinaryInfo();
        this.getServerInfo(info, args);
        String[] paths = new String[]{info.root, info.conf};
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (path == null) continue;
            log.debug((Object)("Attempting to resolve '" + httpd + "' relative to '" + path + "'"));
            for (File dir = new File(path); dir != null; dir = dir.getParentFile()) {
                File exe = new File(dir, httpd);
                if (!exe.exists()) continue;
                log.debug((Object)("Relative '" + httpd + "' resolved to '" + exe + "'"));
                try {
                    return exe.getCanonicalPath();
                }
                catch (IOException e) {
                    return exe.getPath();
                }
            }
        }
        return null;
    }

    private void findServerProcess(List servers, String query, String version) {
        long[] pids = ApacheServerDetector.getPids((String)query);
        for (int i = 0; i < pids.length; ++i) {
            ApacheBinaryInfo info;
            String httpd = ApacheServerDetector.getProcExe((long)pids[i]);
            if (httpd == null) {
                httpd = this.getConfigProperty("exe");
            }
            if (httpd == null) continue;
            String[] args = ApacheServerDetector.getProcArgs((long)pids[i]);
            if (!new File(httpd).isAbsolute()) {
                String exe = this.findAbsoluteExe(httpd, args);
                if (exe == null) {
                    log.warn((Object)("Unable to get absolute path for pid=" + pids[i] + ", args=" + Arrays.asList(args)));
                    if (!new File(httpd).exists()) {
                        continue;
                    }
                } else {
                    httpd = exe;
                }
            }
            if ((info = ApacheBinaryInfo.getInfo(httpd, version)) == null) continue;
            info.pid = pids[i];
            this.getServerInfo(info, args);
            if (info.root == null) continue;
            servers.add(info);
        }
    }

    protected List getServerProcessList(String version, String[] queries) {
        ArrayList servers = new ArrayList();
        for (int i = 0; i < queries.length; ++i) {
            this.findServerProcess(servers, queries[i], version);
        }
        return servers;
    }

    private void addTrackConfig(ConfigResponse config) {
        String[] keys = new String[]{LogFileTrackPlugin.PROP_FILES_SERVER, ConfigFileTrackPlugin.PROP_FILES_SERVER};
        for (int i = 0; i < keys.length; ++i) {
            String val;
            if (config.getValue(keys[i]) != null || (val = this.getConfigProperty(keys[i])) == null) continue;
            config.setValue(keys[i], val);
        }
    }

    private void setLogTrack(ConfigResponse config, String file) {
        config.setValue(LogFileTrackPlugin.PROP_FILES_SERVER, file);
    }

    private void setConfigTrack(ConfigResponse config, String file) {
        config.setValue(ConfigFileTrackPlugin.PROP_FILES_SERVER, file);
    }

    private void setPidFile(ConfigResponse config, String file) {
        config.setValue("pidfile", file);
    }

    protected boolean configureServer(ServerResource server, ApacheBinaryInfo binary) throws PluginException {
        String installpath = server.getInstallPath();
        File snmpConfig = this.getSnmpdConf(installpath);
        boolean snmpConfigExists = snmpConfig.exists();
        ConfigResponse controlConfig = this.getControlConfig(installpath);
        if (binary != null) {
            ConfigResponse cprops = new ConfigResponse((Map)binary.toProperties());
            server.setCustomProperties(cprops);
        }
        this.getLog().debug((Object)("[configureServer] snmpConfigExists=" + snmpConfigExists + " this.discoverModSnmp=" + this.discoverModSnmp + " this.discoverModStatus=" + this.discoverModStatus));
        if (snmpConfigExists || this.discoverModSnmp) {
            if (!snmpConfigExists) {
                log.debug((Object)(snmpConfig + " does not exist, cannot auto-configure " + server.getName()));
            }
            ConfigResponse metricConfig = this.getSnmpConfig(snmpConfig);
            ConfigResponse productConfig = this.getProductConfig(metricConfig);
            this.populateListeningPorts(binary.pid, productConfig, true);
            if (binary.conf == null) {
                String cfgPath = installpath;
                if (snmpConfigExists) {
                    cfgPath = snmpConfig.getParentFile().getParent();
                }
                for (String conf : defaultConfs) {
                    File cf = new File(cfgPath, conf);
                    this.getLog().debug((Object)("[configureServer] cf=" + cf + " (" + (cf.exists() && cf.isFile()) + ")"));
                    if (!cf.exists() || !cf.isFile()) continue;
                    binary.conf = cf.getAbsolutePath();
                }
            }
            if (productConfig != null) {
                if (binary.conf != null) {
                    productConfig.setValue("ServerConf", binary.conf);
                }
                this.addTrackConfig(productConfig);
                this.setProductConfig(server, productConfig);
                this.setMeasurementConfig(server, metricConfig);
                if (controlConfig != null) {
                    this.setControlConfig(server, controlConfig);
                }
                server.setConnectProperties(new String[]{"snmpPort", "snmpVersion"});
            }
            server.setDescription("mod_snmp monitor");
            return true;
        }
        if (this.discoverModStatus) {
            log.debug((Object)(snmpConfig + " does not exist, discovering as type: " + TYPE_HTTPD));
            ConfigResponse productConfig = new ConfigResponse();
            this.populateListeningPorts(binary.pid, productConfig, true);
            if (this.configureURL(this.getManagerProperty("httpd.url"), productConfig)) {
                server.setMeasurementConfig();
            } else if (this.configureURL(binary, productConfig)) {
                ConfigResponse srControlConfig;
                server.setMeasurementConfig();
                if (binary.conf != null && (srControlConfig = this.getControlConfig(binary.root)) != null) {
                    controlConfig = srControlConfig;
                }
            }
            this.addTrackConfig(productConfig);
            if (controlConfig != null) {
                String pidfile = productConfig.getValue("pidfile");
                if (pidfile != null) {
                    this.setPidFile(controlConfig, pidfile);
                }
                this.setControlConfig(server, controlConfig);
            }
            server.setDescription("mod_status monitor");
            server.setType(TYPE_HTTPD);
            String path = binary.conf;
            if (path == null) {
                path = server.getInstallPath();
            } else {
                server.setInstallPath(path);
            }
            server.setIdentifier("Apache httpd " + path);
            server.setProductConfig(productConfig);
            return true;
        }
        log.debug((Object)("Ignoring " + server.getName() + " at " + server.getInstallPath()));
        return false;
    }

    public List getServerList(String installpath, String fullVersion, ApacheBinaryInfo binary) throws PluginException {
        if (new File(installpath, "bin/httpsd.pthread").exists()) {
            return null;
        }
        ServerResource sValue = this.createServerResource(installpath);
        String name = ApacheServerDetector.getPlatformName() + " Apache " + fullVersion;
        if (binary.name != null) {
            name = name + " " + binary.name;
        }
        sValue.setName(name);
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        if (this.configureServer(sValue, binary)) {
            servers.add(sValue);
        }
        return servers;
    }

    protected File getSnmpdConf(String path) {
        File file = new File(path, "conf" + File.separator + "snmpd.conf");
        return file;
    }

    protected ConfigResponse getSnmpConfig(File file) {
        ApacheSNMP.ConfigFile config = null;
        if (file.exists()) {
            try {
                config = ApacheSNMP.getConfig(file.toString());
                log.debug((Object)(file + " snmp agent=" + config));
                return new ConfigResponse((Map)ApacheSNMP.getConfigProperties(config));
            }
            catch (IOException e) {
                log.warn((Object)("Unable to parse SNMP port from: " + file), (Throwable)e);
            }
        }
        return new ConfigResponse();
    }

    protected String getListenAddress(String port, String defaultAddress) {
        String address = super.getListenAddress(port);
        if (address.equals("localhost")) {
            return defaultAddress;
        }
        return address;
    }

    protected ConfigResponse getProductConfig(ConfigResponse mConfig) {
        List servers;
        ApacheSNMP snmp = new ApacheSNMP();
        try {
            servers = snmp.getServers(mConfig);
        }
        catch (SNMPException e) {
            log.debug((Object)("getServers(" + mConfig + ") failed: " + (Object)((Object)e)), (Throwable)e);
            return null;
        }
        if (servers.size() == 0) {
            log.debug((Object)("getServers(" + mConfig + ") == 0"));
            return null;
        }
        Properties config = new Properties();
        ApacheSNMP.Server server = (ApacheSNMP.Server)servers.get(0);
        String address = this.getListenAddress(server.port, this.defaultIp);
        config.setProperty("protocol", this.getConnectionProtocol(server.port));
        config.setProperty("ssl", this.isSSL(server.port));
        config.setProperty("hostname", address);
        config.setProperty("port", server.port);
        config.setProperty(PROP_SERVER_NAME, server.name);
        config.setProperty(PROP_SERVER_PORT, server.port);
        log.debug((Object)("Configured server via snmp: " + server));
        return new ConfigResponse((Map)config);
    }

    protected String getWindowsServiceName() {
        return DEFAULT_SERVICE_NAME;
    }

    protected String getDefaultControlScript() {
        String file = this.getTypeProperty("DEFAULT_SCRIPT");
        if (file != null) {
            return file;
        }
        return "bin/apachectl";
    }

    protected String getDefaultPidFile() {
        String file = this.getTypeProperty("DEFAULT_PIDFILE");
        if (file != null) {
            return file;
        }
        return "logs/httpd.pid";
    }

    private boolean exists(String name) {
        if (name == null) {
            return false;
        }
        return new File(name).exists();
    }

    protected ConfigResponse getControlConfig(String path) {
        Properties props = new Properties();
        if (ApacheServerDetector.isWin32()) {
            String sname = this.getWindowsServiceName();
            if (sname != null) {
                props.setProperty("service_name", sname);
            }
            return new ConfigResponse((Map)props);
        }
        String file = path + "/" + this.getDefaultControlScript();
        if (!this.exists(file)) {
            file = this.getConfigProperty("program");
        }
        if (file == null) {
            return null;
        }
        props.setProperty("program", file);
        file = path + "/" + this.getDefaultPidFile();
        if (!this.exists(file)) {
            file = this.getConfigProperty("pidfile");
        }
        if (file != null) {
            props.setProperty("pidfile", file);
        }
        return new ConfigResponse((Map)props);
    }

    private String[] getPtqlQueries() {
        if (ApacheServerDetector.isWin32()) {
            return PTQL_QUERIES_WIN32;
        }
        return PTQL_QUERIES;
    }

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        this.setPlatformConfig(platformConfig);
        String version = this.getTypeInfo().getVersion();
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        List binaries = this.getServerProcessList(version, this.getPtqlQueries());
        for (int i = 0; i < binaries.size(); ++i) {
            ApacheBinaryInfo info = (ApacheBinaryInfo)binaries.get(i);
            List found = this.getServerList(info.root, info.version, info);
            if (found == null) continue;
            for (int j = 0; j < found.size(); ++j) {
                ServerResource server = (ServerResource)found.get(j);
                this.discoverServerConfig(server, info.pid);
                servers.add(server);
            }
        }
        return servers;
    }

    public List getServerResources(ConfigResponse platformConfig, String path) throws PluginException {
        String version = this.getTypeInfo().getVersion();
        ApacheBinaryInfo binary = ApacheBinaryInfo.getInfo(path, version);
        if (binary == null) {
            return null;
        }
        String fullVersion = binary.version;
        if (fullVersion == null) {
            log.debug((Object)("Apache version " + version + " not found in binary: " + path));
            return null;
        }
        String installpath = ApacheServerDetector.getParentDir((String)path, (int)2);
        return this.getServerList(installpath, fullVersion, binary);
    }

    protected List discoverServices(ConfigResponse serverConfig) throws PluginException {
        List workers;
        ArrayList services = new ArrayList();
        List vhosts = this.discoverVHostServices(serverConfig);
        if (vhosts != null) {
            services.addAll(vhosts);
        }
        if ((workers = this.discoverJkServices(serverConfig)) != null) {
            services.addAll(workers);
        }
        return services;
    }

    protected boolean configureURL(ApacheBinaryInfo binary, ConfigResponse config) {
        String port = null;
        String address = null;
        if (binary.conf != null) {
            File pidFile;
            String pid;
            String log;
            Map cfg = ApacheBinaryInfo.parseConfig(binary.conf);
            String listen = (String)cfg.get("Listen");
            if (listen != null) {
                int ix = listen.lastIndexOf(58);
                if (ix == -1) {
                    port = listen;
                    address = (String)cfg.get("ServerName");
                    if (address != null && (ix = address.indexOf(58)) != -1) {
                        address = address.substring(0, ix);
                    }
                } else {
                    address = listen.substring(0, ix);
                    port = listen.substring(ix + 1);
                }
            }
            this.setConfigTrack(config, binary.conf);
            String root = (String)cfg.get("ServerRoot");
            if (root != null) {
                binary.root = root;
            }
            if (binary.serverRootRelative(log = (String)cfg.get("ErrorLog")).exists()) {
                this.setLogTrack(config, log);
            }
            if ((pid = (String)cfg.get("PidFile")) != null && (pidFile = binary.serverRootRelative(pid)).exists()) {
                this.setPidFile(config, pidFile.getPath());
            }
        }
        if (port == null) {
            port = this.getConfigProperty("port", "80");
        }
        if (address == null) {
            address = this.getListenAddress(port, this.defaultIp);
        }
        config.setValue("protocol", this.getConnectionProtocol(port));
        config.setValue("ssl", this.isSSL(port));
        config.setValue("hostname", address);
        config.setValue("port", port);
        config.setValue("path", this.getConfigProperty("path", "/server-status"));
        return true;
    }

    protected boolean configureURL(String urlstr, ConfigResponse config) {
        URL url;
        if (urlstr == null) {
            return false;
        }
        try {
            url = new URL(urlstr);
        }
        catch (MalformedURLException e) {
            log.error((Object)("Malformed url=" + urlstr));
            return false;
        }
        config.setValue("hostname", url.getHost());
        config.setValue("port", String.valueOf(url.getPort()));
        config.setValue("path", url.getPath());
        config.setValue("protocol", "http");
        if (url.getProtocol().equals("https")) {
            config.setValue("ssl", "true");
        }
        return true;
    }

    protected List discoverJkServices(ConfigResponse serverConfig) throws PluginException {
        ConfigResponse config = new ConfigResponse();
        if (!this.configureURL(this.getManagerProperty("jkstatus.url"), config)) {
            return null;
        }
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        JkStatusCollector jkstatus = new JkStatusCollector();
        Map stats = jkstatus.getValues((GenericPlugin)this, config);
        Set workers = jkstatus.getWorkers();
        for (String name : workers) {
            ServiceResource worker = this.createServiceResource("mod_jk Worker");
            worker.setServiceName("mod_jk Worker " + name);
            ConfigResponse cprops = new ConfigResponse();
            for (int i = 0; i < JkStatusCollector.WORKER_PROPS.length; ++i) {
                String prop = JkStatusCollector.WORKER_PROPS[i];
                cprops.setValue(prop, (String)stats.get(name + "." + prop));
            }
            ConfigResponse productConfig = new ConfigResponse((Map)config.toProperties());
            productConfig.setValue("name", name);
            worker.setProductConfig(productConfig);
            worker.setCustomProperties(cprops);
            worker.setMeasurementConfig();
            services.add(worker);
        }
        return services;
    }

    protected List discoverVHostServices(ConfigResponse serverConfig) throws PluginException {
        List servers;
        Map<String, ApacheVHost> vHosts;
        this.getLog().debug((Object)("[discoverVHostServices] serverConfig=" + serverConfig));
        if (serverConfig.getValue("snmpIp") == null) {
            return null;
        }
        try {
            File ServerConf = new File(serverConfig.getValue("ServerConf"));
            ApacheConf aConf = new ApacheConf(ServerConf);
            vHosts = aConf.getVHosts();
        }
        catch (IOException ex) {
            throw new PluginException("Error getting VHosts", (Throwable)ex);
        }
        ApacheSNMP snmp = new ApacheSNMP();
        try {
            servers = snmp.getServers(serverConfig);
        }
        catch (SNMPException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        String serverHostname = serverConfig.getValue("hostname");
        String hostname = "localhost".equals(serverHostname) ? this.defaultIp : serverHostname;
        String serverProtocol = serverConfig.getValue("protocol");
        String protocol = "ping".equals(serverProtocol) || "socket".equals(serverProtocol) ? serverProtocol : null;
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        HashMap<String, Boolean> serviceNames = new HashMap<String, Boolean>();
        for (int i = 0; i < servers.size(); ++i) {
            ApacheSNMP.Server server = (ApacheSNMP.Server)servers.get(i);
            String serviceName = server.toString();
            if (serviceNames.get(serviceName) == Boolean.TRUE) {
                log.debug((Object)("Discovered duplicate service: " + serviceName));
                continue;
            }
            serviceNames.put(serviceName, Boolean.TRUE);
            log.debug((Object)("Discovered service: " + serviceName));
            ServiceResource service = new ServiceResource();
            service.setType((GenericPlugin)this, VHOST_NAME);
            service.setServiceName("VHost " + serviceName);
            ConfigResponse config = new ConfigResponse();
            String exceptedServerName = server.name + ":" + server.port;
            ApacheVHost vhost = vHosts.get(exceptedServerName);
            if (vhost != null) {
                config.setValue("hostname", vhost.getIp());
                config.setValue("port", vhost.getPort());
            } else if (config.getValue("hostname") == null) {
                ApacheListen parseListen = ApacheConf.parseListen(exceptedServerName);
                config.setValue("hostname", parseListen.getIp());
                config.setValue("port", parseListen.getPort());
            }
            config.setValue(PROP_SERVER_NAME, server.name);
            config.setValue(PROP_SERVER_PORT, server.port);
            String proto = protocol == null ? this.getConnectionProtocol(server.port) : protocol;
            config.setValue("protocol", proto);
            config.setValue("ssl", this.isSSL(server.port));
            service.setProductConfig(config);
            service.setMeasurementConfig();
            services.add(service);
        }
        if (servers.size() > 0) {
            ApacheSNMP.Server server = (ApacheSNMP.Server)servers.get(0);
            ConfigResponse cprops = new ConfigResponse();
            cprops.setValue("version", server.version);
            cprops.setValue("serverTokens", server.description);
            cprops.setValue("serverAdmin", server.admin);
            this.setCustomProperties(cprops);
        }
        return services;
    }

    private String isSSL(String port) {
        int nPort = Integer.parseInt(port);
        if (this.httpRange.hasValue(nPort)) {
            return "false";
        }
        if (this.httpsRange.hasValue(nPort)) {
            return "true";
        }
        return String.valueOf(this.isSSLPort(port));
    }

    private void populateListeningPorts(long pid, ConfigResponse productConfig, boolean b) {
        try {
            Class<?> du = Class.forName("org.hyperic.hq.product.DetectionUtil");
            Method plp = du.getMethod("populateListeningPorts", Long.TYPE, ConfigResponse.class, Boolean.TYPE);
            plp.invoke(null, pid, productConfig, b);
        }
        catch (ClassNotFoundException ex) {
            log.debug((Object)"[populateListeningPorts] Class 'DetectionUtil' not found", (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            log.debug((Object)"[populateListeningPorts] Method 'populateListeningPorts' not found", (Throwable)ex);
        }
        catch (Exception ex) {
            log.debug((Object)"[populateListeningPorts] Problem with Method 'populateListeningPorts'", (Throwable)ex);
        }
    }

    private static class PortRange {
        int start;
        int end;

        public PortRange(String range) {
            this.parse(range);
        }

        public void parse(String range) {
            if (range == null) {
                this.end = 0;
                this.start = 0;
                return;
            }
            int ix = range.indexOf("..");
            if (ix == -1) {
                throw new IllegalArgumentException("Invalid range: " + range);
            }
            this.start = Integer.parseInt(range.substring(0, ix));
            this.end = Integer.parseInt(range.substring(ix + 2, range.length()));
        }

        public boolean hasValue(int value) {
            return value >= this.start && value <= this.end;
        }

        public String toString() {
            return this.start + ".." + this.end;
        }
    }
}

