/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.config;

import java.io.File;
import java.io.Serializable;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.InvalidOptionValueException;

public class DirConfigOption
extends ConfigOption
implements Serializable {
    public DirConfigOption(String optName, String optDesc, String defValue) {
        super(optName, optDesc, defValue);
    }

    public void checkOptionIsValid(String value) throws InvalidOptionValueException {
        if (value == null) {
            throw this.invalidOption("cannot be null");
        }
        File dir = new File(value);
        if (!dir.exists()) {
            throw this.invalidOption("does not exist: " + value);
        }
        if (!dir.isDirectory()) {
            throw this.invalidOption("is not a directory: " + value);
        }
    }
}

