/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.StreamPumper;

public class PumpStreamHandler
implements ExecuteStreamHandler {
    private Thread inputThread;
    private Thread errorThread;
    private OutputStream out;
    private OutputStream err;
    boolean running = false;
    private static Log log = LogFactory.getLog(PumpStreamHandler.class);

    public PumpStreamHandler(OutputStream out, OutputStream err) {
        this.out = out;
        this.err = err;
    }

    public PumpStreamHandler(OutputStream outAndErr) {
        this(outAndErr, outAndErr);
    }

    public PumpStreamHandler() {
        this(System.out, System.err);
    }

    public void setProcessOutputStream(InputStream is) {
        this.createProcessOutputPump(is, this.out);
    }

    public void setProcessErrorStream(InputStream is) {
        this.createProcessErrorPump(is, this.err);
    }

    public void setProcessInputStream(OutputStream os) {
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() {
        this.inputThread.start();
        this.errorThread.start();
        this.running = true;
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        try {
            this.inputThread.join(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.errorThread.join(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.err.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.running = false;
    }

    protected OutputStream getErr() {
        return this.err;
    }

    protected OutputStream getOut() {
        return this.out;
    }

    protected void createProcessOutputPump(InputStream is, OutputStream os) {
        this.inputThread = this.createPump(is, os);
    }

    protected void createProcessErrorPump(InputStream is, OutputStream os) {
        this.errorThread = this.createPump(is, os);
    }

    protected Thread createPump(InputStream is, OutputStream os) {
        Thread result = new Thread(new StreamPumper(is, os));
        result.setDaemon(true);
        return result;
    }
}

