/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.hyperic.util.file.WriterHandler;

class CreateOnlyWriter
extends WriterHandler {
    private File destFile;
    private InputStream inStream;
    private boolean created;
    private long length;

    CreateOnlyWriter(File destFile, InputStream inStream, long length) {
        this.destFile = destFile;
        this.inStream = inStream;
        this.created = false;
        this.length = length;
    }

    CreateOnlyWriter(File destFile, byte[] data) {
        this(destFile, new ByteArrayInputStream(data), data.length);
    }

    public void rollback() throws IOException {
        super.rollback();
        if (this.created) {
            this.destFile.delete();
        }
    }

    public void cleanup() {
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        super.write();
        if (!this.destFile.createNewFile()) {
            throw new IOException("Unable to create " + this.destFile + ": file already exists");
        }
        this.created = true;
        FileOutputStream fOs = new FileOutputStream(this.destFile);
        try {
            CreateOnlyWriter.copyStream(this.inStream, fOs, this.length);
        }
        finally {
            try {
                fOs.close();
            }
            catch (IOException iOException) {}
        }
    }
}

