/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.paramParser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.hyperic.util.TextIndenter;

public class ParseResult {
    private HashMap props = new HashMap();
    private ParseResult parent = null;
    private ArrayList children = new ArrayList();
    private String blockName;

    public ParseResult(String blockName) {
        this.blockName = blockName;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public ParseResult getRoot() {
        ParseResult res = this;
        while (res.parent != null) {
            res = res.parent;
        }
        return res;
    }

    public ParseResult getParent() {
        return this.parent;
    }

    public void addChild(ParseResult child) {
        this.children.add(child);
        child.parent = this;
    }

    public void removeChild(ParseResult child) {
        this.children.remove(child);
        child.parent = null;
    }

    public List getChildren() {
        return this.children;
    }

    public Object getValue(String key) {
        return this.props.get(key);
    }

    public void setValue(String key, Object value) {
        this.props.put(key, value);
    }

    public Set getKeys() {
        return this.props.keySet();
    }

    void toString(TextIndenter tInd) {
        tInd.append("Block: " + this.getBlockName() + "\n");
        tInd.pushIndent();
        for (String key : this.getKeys()) {
            tInd.append(key + "='" + this.getValue(key) + "'\n");
        }
        tInd.pushIndent();
        for (ParseResult child : this.getChildren()) {
            child.toString(tInd);
        }
        tInd.popIndent();
        tInd.popIndent();
    }

    public String toString() {
        TextIndenter res = new TextIndenter(2);
        this.toString(res);
        return res.toString();
    }
}

