/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.security;

import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.hyperic.util.security.DefaultSSLProviderImpl;
import org.hyperic.util.security.KeystoreConfig;
import org.hyperic.util.security.KeystoreManager;
import org.hyperic.util.security.SSLProvider;
import org.hyperic.util.timer.StopWatch;

public class DatabaseSSLProviderImpl
implements SSLProvider {
    private SSLContext sslContext;
    private SSLSocketFactory sslSocketFactory;
    private static final Log log = LogFactory.getLog(DefaultSSLProviderImpl.class);
    private static final ReadWriteLock KEYSTORE_LOCK = new ReentrantReadWriteLock();
    private static final Lock KEYSTORE_READER_LOCK = KEYSTORE_LOCK.readLock();
    private static final Lock KEYSTORE_WRITER_LOCK = KEYSTORE_LOCK.writeLock();

    private KeyManagerFactory getKeyManagerFactory(KeyStore keystore, String password) throws KeyStoreException {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keystore, password.toCharArray());
            return keyManagerFactory;
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException("The algorithm is not supported. Error message:" + e.getMessage());
        }
        catch (UnrecoverableKeyException e) {
            throw new KeyStoreException("Password for the keystore is invalid. Error message:" + e.getMessage());
        }
    }

    private TrustManagerFactory getTrustManagerFactory(KeyStore keystore) throws KeyStoreException, IOException {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keystore);
            return trustManagerFactory;
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("The algorithm is not supported. Error message:" + e.getMessage()));
            throw new KeyStoreException(e);
        }
    }

    public DatabaseSSLProviderImpl(KeystoreConfig keystoreConfig, boolean acceptUnverifiedCertificates) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Keystore info: alias=" + keystoreConfig.getAlias() + ", path:" + keystoreConfig.getFilePath() + ", acceptUnverifiedCertificates=" + acceptUnverifiedCertificates));
        }
        boolean hasLock = false;
        boolean debug = log.isDebugEnabled();
        StopWatch watch = new StopWatch();
        try {
            KeystoreManager keystoreMgr = KeystoreManager.getKeystoreManager();
            KEYSTORE_READER_LOCK.lockInterruptibly();
            hasLock = true;
            KeyStore trustStore = keystoreMgr.getKeyStore(keystoreConfig);
            KeyManagerFactory keyManagerFactory = this.getKeyManagerFactory(trustStore, keystoreConfig.getFilePassword());
            TrustManagerFactory trustManagerFactory = this.getTrustManagerFactory(trustStore);
            X509TrustManager defaultTrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
            X509TrustManager customTrustManager = this.getCustomTrustManager(defaultTrustManager, keystoreConfig, acceptUnverifiedCertificates, trustStore);
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(keyManagerFactory.getKeyManagers(), new TrustManager[]{customTrustManager}, new SecureRandom());
            this.sslSocketFactory = new SSLSocketFactory(this.sslContext, this.getHostnameVerifier());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (hasLock) {
                KEYSTORE_READER_LOCK.unlock();
            }
            if (debug) {
                log.debug((Object)("readCert: " + watch));
            }
        }
    }

    private X509HostnameVerifier getHostnameVerifier() {
        return new X509HostnameVerifier(){
            private AllowAllHostnameVerifier internalVerifier = new AllowAllHostnameVerifier();

            public boolean verify(String host, SSLSession session) {
                return this.internalVerifier.verify(host, session);
            }

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                this.internalVerifier.verify(host, cns, subjectAlts);
            }

            public void verify(String host, X509Certificate cert) throws SSLException {
                this.internalVerifier.verify(host, cert);
            }

            public void verify(String host, SSLSocket ssl) throws IOException {
                try {
                    this.internalVerifier.verify(host, ssl);
                }
                catch (SSLPeerUnverifiedException e) {
                    throw new SSLPeerUnverifiedException("The authenticity of host '" + host + "' can't be established.");
                }
            }
        };
    }

    private X509TrustManager getCustomTrustManager(final X509TrustManager defaultTrustManager, final KeystoreConfig keystoreConfig, final boolean acceptUnverifiedCertificates, final KeyStore trustStore) {
        return new X509TrustManager(){
            private final Log log = LogFactory.getLog(X509TrustManager.class);

            public X509Certificate[] getAcceptedIssuers() {
                return defaultTrustManager.getAcceptedIssuers();
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                try {
                    defaultTrustManager.checkServerTrusted(chain, authType);
                }
                catch (CertificateException e) {
                    CertificateExpiredException expiredCertException = this.getCertExpiredException(e);
                    if (expiredCertException != null) {
                        this.log.error((Object)"Fail the connection because received certificate is expired. Please update the certificate.", (Throwable)expiredCertException);
                        throw new CertificateException(e);
                    }
                    if (acceptUnverifiedCertificates) {
                        this.log.info((Object)"Import the certification. (Received certificate is not trusted by keystore)");
                        this.importCertificate(chain);
                    }
                    this.log.warn((Object)("Fail the connection because received certificate is not trusted by keystore: alias=" + keystoreConfig.getAlias() + ", path=" + keystoreConfig.getFilePath()));
                    this.log.debug((Object)("Fail the connection because received certificate is not trusted by keystore: alias=" + keystoreConfig.getAlias() + ", path=" + keystoreConfig.getFilePath() + ", acceptUnverifiedCertificates=" + acceptUnverifiedCertificates), (Throwable)e);
                    throw new CertificateException(e);
                }
            }

            private CertificateExpiredException getCertExpiredException(Exception e) {
                while (e != null) {
                    if (e instanceof CertificateExpiredException) {
                        return (CertificateExpiredException)e;
                    }
                    e = (Exception)e.getCause();
                }
                return null;
            }

            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                defaultTrustManager.checkClientTrusted(chain, authType);
            }

            /*
             * Exception decompiling
             */
            private void importCertificate(X509Certificate[] chain) throws CertificateException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private void close(FileOutputStream keyStoreFileOutputStream) {
                if (keyStoreFileOutputStream != null) {
                    try {
                        keyStoreFileOutputStream.close();
                    }
                    catch (IOException e) {
                        this.log.error((Object)e, (Throwable)e);
                    }
                }
            }
        };
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    static /* synthetic */ Lock access$000() {
        return KEYSTORE_WRITER_LOCK;
    }
}

