/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.security.DbKeystoreManager;
import org.hyperic.util.security.KeystoreEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbKeyStoreSpi
extends KeyStoreSpi {
    private final Log log = LogFactory.getLog(DbKeyStoreSpi.class);
    public static final String PRIVATE_KEY_ENTRY = "PrivateKeyEntry";
    public static final String TRUSTED_CERT_ENTRY = "trustedCertEntry";
    public static final String SECRET_KEY_ENTRY = "SecretKeyEntry";
    private final DbKeystoreManager dbKeystoreManager;
    private final Map<String, Object[]> engineAliases = new HashMap<String, Object[]>();

    public DbKeyStoreSpi(DbKeystoreManager dbKeystoreManager) {
        this.dbKeystoreManager = dbKeystoreManager;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Object[] objs = this.engineAliases.get(alias);
        if (objs == null) {
            this.log.warn((Object)("alias=" + alias + " has no associated certificate"));
            return null;
        }
        Certificate cert = (Certificate)objs[1];
        return cert.getPublicKey();
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Object[] objs = this.engineAliases.get(alias);
        return (Certificate[])objs[2];
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Object[] objs = this.engineAliases.get(alias);
        return (Certificate)objs[1];
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        throw new UnsupportedOperationException("engineGetCreationDate() is not supported");
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        throw new UnsupportedOperationException("engineSetKeyEntry() is not supported");
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new UnsupportedOperationException("engineSetKeyEntry() is not supported");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        this.dbKeystoreManager.create(alias, TRUSTED_CERT_ENTRY, cert, null);
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        throw new UnsupportedOperationException("engineDeleteEntry() is not supported");
    }

    @Override
    public Enumeration<String> engineAliases() {
        return new Vector<String>(this.engineAliases.keySet()).elements();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.engineAliases.containsKey(alias);
    }

    @Override
    public int engineSize() {
        return this.engineAliases.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        Object[] objs = this.engineAliases.get(alias);
        if (objs == null) {
            return false;
        }
        String type = (String)objs[0];
        return type.equals(PRIVATE_KEY_ENTRY) || type.equals(SECRET_KEY_ENTRY);
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        Object[] objs = this.engineAliases.get(alias);
        if (objs == null) {
            return false;
        }
        String type = (String)objs[0];
        return type.equals(TRUSTED_CERT_ENTRY);
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        throw new UnsupportedOperationException("engineGetCertificateAlias() is not supported");
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new UnsupportedOperationException("engineStore() is not supported");
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        Collection<? extends KeystoreEntry> entries = this.dbKeystoreManager.getKeystore();
        boolean debug = this.log.isDebugEnabled();
        for (KeystoreEntry keystoreEntry : entries) {
            String alias = keystoreEntry.getAlias();
            String type = keystoreEntry.getType();
            Certificate cert = keystoreEntry.getCertificate();
            Certificate[] chain = keystoreEntry.getCertificateChain();
            Object[] objs = this.engineAliases.get(alias);
            if (objs == null) {
                objs = new Object[]{type, cert, chain};
                this.engineAliases.put(alias, objs);
            }
            if (!debug) continue;
            this.log.debug((Object)("adding alias=" + alias + ",type=" + type));
        }
    }
}

