/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.security;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteWatchdog;
import org.hyperic.util.exec.PumpStreamHandler;
import org.hyperic.util.file.FileUtil;
import org.hyperic.util.security.DbKeyStore;
import org.hyperic.util.security.KeystoreConfig;
import org.springframework.util.StringUtils;

public class KeystoreManager {
    private final Log log;
    private final AtomicBoolean isDB = new AtomicBoolean(false);
    private static KeystoreManager keystoreManager = new KeystoreManager();

    private KeystoreManager() {
        this.log = LogFactory.getLog(KeystoreManager.class);
    }

    public static KeystoreManager getKeystoreManager() {
        return keystoreManager;
    }

    private String getDName(KeystoreConfig keystoreConfig) {
        return "CN=" + keystoreConfig.getKeyCN() + " (HQ Self-Signed Cert), OU=HQ, O=hyperic.net, L=Unknown, ST=Unknown, C=US";
    }

    public KeyStore getKeyStore(KeystoreConfig keystoreConfig) throws KeyStoreException, IOException {
        FileInputStream keyStoreFileInputStream = null;
        String filePath = keystoreConfig.getFilePath();
        String filePassword = keystoreConfig.getFilePassword();
        String errorMsg = "";
        if (keystoreConfig.getAlias() == null) {
            errorMsg = errorMsg + " alias is null. ";
        }
        if (keystoreConfig.getFilePath() == null) {
            errorMsg = errorMsg + " filePath is null. ";
        }
        if (keystoreConfig.getFilePassword() == null) {
            errorMsg = errorMsg + " password is null. ";
        }
        if (!"".equals(errorMsg)) {
            throw new KeyStoreException(errorMsg);
        }
        try {
            KeyStore keystore = DbKeyStore.getInstance(KeyStore.getDefaultType(), this.isDB);
            File file = new File(filePath);
            char[] password = null;
            if (!file.exists()) {
                if (StringUtils.hasText((String)filePath) && !keystoreConfig.isHqDefault()) {
                    throw new IOException("User specified keystore [" + filePath + "] does not exist.");
                }
                password = filePassword.toCharArray();
                this.createInternalKeystore(keystoreConfig);
                FileUtil.setReadWriteOnlyByOwner(file);
            }
            keyStoreFileInputStream = new FileInputStream(file);
            keystore.load(keyStoreFileInputStream, password);
            KeyStore keyStore = keystore;
            return keyStore;
        }
        catch (NoSuchAlgorithmException e) {
            errorMsg = "The algorithm used to check the integrity of the keystore cannot be found.";
            throw new KeyStoreException(errorMsg, e);
        }
        catch (CertificateException e) {
            errorMsg = "Keystore cannot be loaded. One possibility is that the password is incorrect.";
            throw new KeyStoreException(errorMsg, e);
        }
        finally {
            if (keyStoreFileInputStream != null) {
                keyStoreFileInputStream.close();
                keyStoreFileInputStream = null;
            }
        }
    }

    private void createInternalKeystore(KeystoreConfig keystoreConfig) throws KeyStoreException {
        int rc;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        String javaHome = System.getProperty("java.home");
        String keytool = javaHome + File.separator + "bin" + File.separator + "keytool";
        String[] args = new String[]{keytool, "-genkey", "-dname", this.getDName(keystoreConfig), "-alias", keystoreConfig.getAlias(), "-keystore", keystoreConfig.getFilePath(), "-storepass", keystoreConfig.getFilePassword(), "-keypass", keystoreConfig.getFilePassword(), "-keyalg", "RSA", "-validity", "3650"};
        int timeout = 300000;
        ExecuteWatchdog wdog = new ExecuteWatchdog(timeout);
        Execute exec = new Execute(new PumpStreamHandler(output), wdog);
        exec.setCommandline(args);
        this.log.debug((Object)("Generating keystore: " + keystoreConfig.getFilePath()));
        try {
            rc = exec.execute();
        }
        catch (Exception e) {
            rc = -1;
            this.log.error((Object)e);
        }
        if (rc != 0) {
            String msg = output.toString().trim();
            if (msg.length() == 0) {
                msg = "timeout after " + timeout + "ms";
            }
            if (!msg.toLowerCase().contains("key pair not generated, alias <" + keystoreConfig.getAlias().toLowerCase() + "> already exists")) {
                throw new KeyStoreException("Failed to create keystore:" + keystoreConfig.getAlias() + ", " + msg);
            }
        }
    }

    public X509TrustManager getCustomTrustManager(X509TrustManager defaultTrustManager, KeystoreConfig keystoreConfig, boolean acceptUnverifiedCertificates, KeyStore trustStore) {
        return new CustomTrustManager(defaultTrustManager, keystoreConfig, acceptUnverifiedCertificates, trustStore, this.isDB.get());
    }

    private class CustomTrustManager
    implements X509TrustManager {
        private final Log log = LogFactory.getLog(X509TrustManager.class);
        private final X509TrustManager defaultTrustManager;
        private final KeystoreConfig keystoreConfig;
        private final boolean acceptUnverifiedCertificates;
        private final KeyStore trustStore;
        private final boolean isDB;

        private CustomTrustManager(X509TrustManager defaultTrustManager, KeystoreConfig keystoreConfig, boolean acceptUnverifiedCertificates, KeyStore trustStore, boolean isDB) {
            this.defaultTrustManager = defaultTrustManager;
            this.keystoreConfig = keystoreConfig;
            this.acceptUnverifiedCertificates = acceptUnverifiedCertificates;
            this.trustStore = trustStore;
            this.isDB = isDB;
        }

        public X509Certificate[] getAcceptedIssuers() {
            return this.defaultTrustManager.getAcceptedIssuers();
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.defaultTrustManager.checkServerTrusted(chain, authType);
            }
            catch (CertificateException e) {
                CertificateExpiredException expiredCertException = this.getCertExpiredException(e);
                if (expiredCertException != null) {
                    this.log.error((Object)"Fail the connection because received certificate is expired. Please update the certificate.", (Throwable)expiredCertException);
                    throw new CertificateException(e);
                }
                if (this.acceptUnverifiedCertificates) {
                    this.log.info((Object)"Import the certification. (Received certificate is not trusted by keystore)");
                    this.importCertificate(chain);
                }
                this.log.warn((Object)("Fail the connection because received certificate is not trusted by keystore: alias=" + this.keystoreConfig.getAlias()));
                this.log.debug((Object)("Fail the connection because received certificate is not trusted by keystore: alias=" + this.keystoreConfig.getAlias() + ", acceptUnverifiedCertificates=" + this.acceptUnverifiedCertificates), (Throwable)e);
                throw new CertificateException(e);
            }
        }

        private CertificateExpiredException getCertExpiredException(Exception e) {
            while (e != null) {
                if (e instanceof CertificateExpiredException) {
                    return (CertificateExpiredException)e;
                }
                e = (Exception)e.getCause();
            }
            return null;
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.defaultTrustManager.checkClientTrusted(chain, authType);
        }

        /*
         * Exception decompiling
         */
        private void importCertificate(X509Certificate[] chain) throws CertificateException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void close(FileOutputStream fos) {
            if (fos == null) {
                return;
            }
            try {
                fos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

