/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.shell;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.hyperic.util.PrintfFormat;
import org.hyperic.util.shell.MultiwordShellCommand;
import org.hyperic.util.shell.ShellCommandBase;
import org.hyperic.util.shell.ShellCommandExecException;
import org.hyperic.util.shell.ShellCommandHandler;
import org.hyperic.util.shell.ShellCommandUsageException;

public class ShellCommand_help
extends ShellCommandBase {
    public void processCommand(String[] args) throws ShellCommandUsageException, ShellCommandExecException {
        int i;
        ShellCommandHandler handler;
        PrintStream out = this.getOutStream();
        if (args.length == 0) {
            PrintfFormat fmt = new PrintfFormat("\t%-14s - %s");
            Object[] fArgs = new Object[2];
            ArrayList cmdNamesList = new ArrayList();
            Iterator i2 = this.getShell().getCommandNameIterator();
            while (i2.hasNext()) {
                cmdNamesList.add(i2.next());
            }
            Object[] cmdNames = cmdNamesList.toArray(new String[0]);
            Arrays.sort(cmdNames);
            out.println("Available commands:");
            for (int j = 0; j < cmdNames.length; ++j) {
                ShellCommandHandler handler2 = this.getShell().getHandler((String)cmdNames[j]);
                fArgs[0] = cmdNames[j];
                fArgs[1] = handler2.getUsageShort();
                out.println(fmt.sprintf(fArgs));
            }
            return;
        }
        ShellCommandHandler lastHandler = handler = this.getShell().getHandler(args[0]);
        int useArgs = 1;
        for (i = 1; i < args.length && !args[i].startsWith("-"); ++i) {
            if (null == handler) {
                handler = lastHandler;
                useArgs = i + 1;
                break;
            }
            if (!(handler instanceof MultiwordShellCommand)) continue;
            MultiwordShellCommand mwsc = (MultiwordShellCommand)handler;
            lastHandler = handler;
            handler = mwsc.getSubHandler(args[i]);
            useArgs = i + 1;
        }
        if (handler == null) {
            out.print("Command '");
            for (i = 0; i < args.length && !args[i].startsWith("-"); ++i) {
                out.print(args[i]);
                if (i >= args.length - 1) continue;
                out.print(' ');
            }
            out.println("' not found.");
        } else {
            String[] otherArgs = new String[args.length - useArgs];
            System.arraycopy(args, useArgs, otherArgs, 0, otherArgs.length);
            out.println(handler.getSyntax());
            out.println(handler.getUsageHelp(otherArgs));
        }
    }

    public String getSyntaxArgs() {
        return "<command name> [command arguments]";
    }

    public String getUsageShort() {
        return "Gives help on shell commands";
    }

    public String getUsageHelp(String[] args) {
        return "    Displays help about the given command name.  If the \n    command has arguments they may be entered for more specific\n    help";
    }
}

