/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hyperic.util.TextProgressBar;
import org.hyperic.util.ssh.SSHExecException;
import org.hyperic.util.ssh.SSHRemoteException;
import org.hyperic.util.ssh.SSHRemoteExec;

public class SSHCopy
extends SSHRemoteExec {
    public SSHCopy(String user, String password, String host) {
        super(user, password, host);
    }

    public void delete(String file) throws SSHRemoteException, SSHExecException {
        this.execute("rm -f " + file);
    }

    public void mkDir(String path) throws SSHRemoteException, SSHExecException {
        this.execute("mkdir -p " + path);
    }

    public void copy(File file, String remotePath) throws SSHRemoteException {
        this.copy(file, remotePath, false);
    }

    public void copy(File file, String remotePath, boolean showProgress) throws SSHRemoteException {
        Session session = null;
        Channel channel = null;
        try {
            session = this.openSession();
            channel = session.openChannel("exec");
            String command = "scp -p -t " + remotePath;
            ((ChannelExec)channel).setCommand(command);
            InputStream in = channel.getInputStream();
            OutputStream out = channel.getOutputStream();
            channel.connect();
            this.waitForAck(in);
            this.doSingleCopy(file, in, out, showProgress);
        }
        catch (JSchException e) {
            throw new SSHRemoteException("Error connecting to host: " + (Object)((Object)e), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SSHRemoteException("I/O error: " + e, e);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }

    public void doSingleCopy(File file, InputStream in, OutputStream out, boolean showProgress) throws SSHRemoteException {
        try {
            int len;
            String command = "C0644 " + file.length() + " " + file.getName() + "\n";
            out.write(command.getBytes());
            out.flush();
            this.waitForAck(in);
            FileInputStream fis = new FileInputStream(file);
            TextProgressBar progress = new TextProgressBar(System.out, file.getName(), file.length());
            int sent = 0;
            byte[] buf = new byte[this.BUFFER_SIZE];
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
                out.flush();
                sent += len;
                if (!showProgress) continue;
                progress.print(sent);
            }
            if (showProgress) {
                progress.print(sent);
            }
            this.sendAck(out);
            this.waitForAck(in);
        }
        catch (IOException e) {
            throw new SSHRemoteException("I/O error: " + e, e);
        }
    }
}

