/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.units;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Locale;
import org.hyperic.util.units.DurationFormatter;
import org.hyperic.util.units.FormattedNumber;
import org.hyperic.util.units.Formatter;
import org.hyperic.util.units.ParseSpecifics;
import org.hyperic.util.units.UnitNumber;

public class ApproxDurationFormatter
extends DurationFormatter
implements Formatter {
    protected FormattedNumber format(BigDecimal baseTime, int granularity, int milliDigits, Locale locale) {
        String res;
        DurationFormatter.TimeBreakDown tbd = this.breakDownTime(baseTime);
        if (granularity == 1) {
            res = tbd.nYears + (tbd.nYears == 1L ? " year " : " years ");
        } else if (granularity == 2) {
            long nDays = tbd.nYears * 365L + tbd.nDays;
            res = nDays + (nDays == 1L ? " day " : " days ");
        } else if (granularity == 3) {
            long hours = tbd.nYears * 365L * 24L + tbd.nDays * 24L + tbd.nHours;
            res = hours + (hours == 1L ? " hour " : " hours ");
        } else if (granularity == 4) {
            long minutes = tbd.nYears * 365L * 24L * 60L + tbd.nDays * 24L * 60L + tbd.nHours * 60L + tbd.nMins;
            res = minutes + (minutes == 1L ? " minute " : " minutes ");
        } else if (granularity == 5 || granularity == 6) {
            res = tbd.nSecs + (tbd.nSecs == 1L ? " second " : " seconds ");
        } else {
            throw new IllegalStateException("Unexpected granularity");
        }
        return new FormattedNumber(res.trim(), "");
    }

    public UnitNumber parse(String val, Locale locale, ParseSpecifics specifics) throws ParseException {
        throw new ParseException("ApproxDurationFormatter does not support parsing of values", 0);
    }
}

