/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.units;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.hyperic.util.ArrayUtil;
import org.hyperic.util.units.FormatSpecifics;
import org.hyperic.util.units.FormattedNumber;
import org.hyperic.util.units.Formatter;
import org.hyperic.util.units.ParseSpecifics;
import org.hyperic.util.units.UnitNumber;
import org.hyperic.util.units.UnitsUtil;

public abstract class BinaryFormatter
implements Formatter {
    private NumberFormat getSpecificFormatter(FormatSpecifics specifics, Locale locale) {
        NumberFormat res = NumberFormat.getInstance(locale);
        if (specifics.getPrecision() == 1) {
            res.setMaximumFractionDigits(100);
            res.setMinimumFractionDigits(0);
        } else {
            res.setMaximumFractionDigits(1);
            res.setMinimumFractionDigits(1);
        }
        return res;
    }

    public FormattedNumber format(UnitNumber val, Locale locale, FormatSpecifics specifics) {
        BigDecimal baseVal = val.getBaseValue();
        int targScale = this.findGoodLookingScale(baseVal);
        double newVal = this.getTargetValue(baseVal, targScale);
        NumberFormat fmt = specifics == null ? UnitsUtil.getNumberFormat(new double[]{newVal}, locale) : this.getSpecificFormatter(specifics, locale);
        return this.createFormattedValue(newVal, targScale, fmt);
    }

    public FormattedNumber[] formatSame(double[] vals, int unitType, int scale, Locale locale, FormatSpecifics specifics) {
        int i;
        FormattedNumber[] res = new FormattedNumber[vals.length];
        if (vals.length == 0) {
            return res;
        }
        double average = ArrayUtil.average(vals);
        UnitNumber tmpNum = new UnitNumber(average, unitType, scale);
        int targScale = this.findGoodLookingScale(tmpNum.getBaseValue());
        double[] newVals = new double[vals.length];
        for (i = 0; i < vals.length; ++i) {
            tmpNum = new UnitNumber(vals[i], unitType, scale);
            newVals[i] = this.getTargetValue(tmpNum.getBaseValue(), targScale);
        }
        NumberFormat fmt = specifics == null ? UnitsUtil.getNumberFormat(newVals, locale) : this.getSpecificFormatter(specifics, locale);
        for (i = 0; i < vals.length; ++i) {
            res[i] = this.createFormattedValue(newVals[i], targScale, fmt);
        }
        return res;
    }

    protected abstract String getTagName();

    protected FormattedNumber createFormattedValue(double value, int scale, NumberFormat fmt) {
        String tag;
        switch (scale) {
            case 0: {
                tag = "";
                break;
            }
            case 1: {
                tag = "K";
                break;
            }
            case 2: {
                tag = "M";
                break;
            }
            case 3: {
                tag = "G";
                break;
            }
            case 4: {
                tag = "T";
                break;
            }
            case 5: {
                tag = "P";
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled scale");
            }
        }
        return new FormattedNumber(fmt.format(value), tag + this.getTagName());
    }

    private double getTargetValue(BigDecimal baseVal, int targetScale) {
        BigDecimal modifier = UnitsUtil.FACT_NONE;
        double lateModifier = 1.0;
        switch (targetScale) {
            case 1: {
                lateModifier = 1024.0;
                break;
            }
            case 2: {
                lateModifier = 1048576.0;
                break;
            }
            case 3: {
                modifier = UnitsUtil.FACT_MEGA_BIN;
                lateModifier = 1024.0;
                break;
            }
            case 4: {
                modifier = UnitsUtil.FACT_GIGA_BIN;
                lateModifier = 1024.0;
                break;
            }
            case 5: {
                modifier = UnitsUtil.FACT_TERA_BIN;
                lateModifier = 1024.0;
            }
        }
        baseVal = baseVal.divide(modifier, 6);
        return baseVal.doubleValue() / lateModifier;
    }

    private int findGoodLookingScale(BigDecimal val) {
        if (val.compareTo(UnitsUtil.FACT_PETA_BIN) >= 1) {
            return 5;
        }
        if (val.compareTo(UnitsUtil.FACT_TERA_BIN) >= 1) {
            return 4;
        }
        if (val.compareTo(UnitsUtil.FACT_GIGA_BIN) >= 1) {
            return 3;
        }
        if (val.compareTo(UnitsUtil.FACT_MEGA_BIN) >= 1) {
            return 2;
        }
        if (val.compareTo(UnitsUtil.FACT_KILO_BIN) >= 1) {
            return 1;
        }
        return 0;
    }

    public BigDecimal getBaseValue(double value, int scale) {
        BigDecimal res = new BigDecimal(value);
        return res.multiply(this.getScaleCoeff(scale));
    }

    public BigDecimal getScaledValue(BigDecimal value, int targScale) {
        return value.divide(this.getScaleCoeff(targScale), 6);
    }

    private BigDecimal getScaleCoeff(int scale) {
        switch (scale) {
            case 0: {
                return UnitsUtil.FACT_NONE;
            }
            case 16: {
                return UnitsUtil.FACT_BIT;
            }
            case 1: {
                return UnitsUtil.FACT_KILO_BIN;
            }
            case 2: {
                return UnitsUtil.FACT_MEGA_BIN;
            }
            case 3: {
                return UnitsUtil.FACT_GIGA_BIN;
            }
            case 4: {
                return UnitsUtil.FACT_TERA_BIN;
            }
            case 5: {
                return UnitsUtil.FACT_PETA_BIN;
            }
        }
        throw new IllegalArgumentException("Value did not have binary based scale");
    }

    protected abstract UnitNumber parseTag(double var1, String var3, int var4, ParseSpecifics var5) throws ParseException;

    public UnitNumber parse(String val, Locale locale, ParseSpecifics specifics) throws ParseException {
        NumberFormat fmt = NumberFormat.getInstance(locale);
        int nonIdx = UnitsUtil.findNonNumberIdx(val, fmt);
        if (nonIdx == -1) {
            throw new ParseException("Number had no units with it", val.length());
        }
        if (nonIdx == 0) {
            throw new ParseException("Invalid number specified", 0);
        }
        double numberPart = fmt.parse(val.substring(0, nonIdx)).doubleValue();
        return this.parseTag(numberPart, val.substring(nonIdx, val.length()).trim(), nonIdx, specifics);
    }
}

