/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.units;

import java.text.ParseException;
import org.hyperic.util.units.BinaryFormatter;
import org.hyperic.util.units.ParseSpecifics;
import org.hyperic.util.units.UnitNumber;

public class BytesFormatter
extends BinaryFormatter {
    protected String getTagName() {
        return "B";
    }

    protected UnitNumber parseTag(double number, String tag, int tagIdx, ParseSpecifics specifics) throws ParseException {
        int scale;
        if (tag.equalsIgnoreCase("b") || tag.equalsIgnoreCase("bytes")) {
            scale = 0;
        } else if (tag.equalsIgnoreCase("k") || tag.equalsIgnoreCase("kb")) {
            scale = 1;
        } else if (tag.equalsIgnoreCase("m") || tag.equalsIgnoreCase("mb")) {
            scale = 2;
        } else if (tag.equalsIgnoreCase("g") || tag.equalsIgnoreCase("gb")) {
            scale = 3;
        } else if (tag.equalsIgnoreCase("t") || tag.equalsIgnoreCase("tb")) {
            scale = 4;
        } else if (tag.equalsIgnoreCase("p") || tag.equalsIgnoreCase("pb")) {
            scale = 5;
        } else {
            throw new ParseException("Unknown byte type '" + tag + "'", tagIdx);
        }
        return new UnitNumber(number, 2, scale);
    }
}

