/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.autoinventory.AutoinventoryException;
import org.hyperic.hq.autoinventory.RuntimeScanner;
import org.hyperic.hq.autoinventory.ScanConfiguration;
import org.hyperic.hq.autoinventory.ScanListener;
import org.hyperic.hq.autoinventory.ScanState;
import org.hyperic.hq.autoinventory.Scanner;
import org.hyperic.hq.common.SystemException;
import org.hyperic.hq.product.AutoinventoryPluginManager;
import org.hyperic.util.AutoApproveConfig;
import org.hyperic.util.timer.StopWatch;

public class ScanManager
implements ScanListener {
    private final Log log = LogFactory.getLog(ScanManager.class);
    private LinkedList scannerList = new LinkedList();
    private volatile Scanner activeScanner = null;
    private ScanListener listener = null;
    private AutoinventoryPluginManager apm = null;
    private volatile Thread mainThread = null;
    private volatile boolean shouldExit = false;
    private volatile boolean scanInProgress = false;
    private RuntimeScanner rtScanner = null;
    private AutoApproveConfig autoApproveConfig;
    private long lastRtScan;
    private long lastDefaultScan;

    public ScanManager(ScanListener listener, AutoinventoryPluginManager apm, RuntimeScanner rtScanner, AutoApproveConfig autoApproveConfig) {
        this.listener = listener;
        this.apm = apm;
        this.rtScanner = rtScanner;
        this.autoApproveConfig = autoApproveConfig;
    }

    public synchronized void startup() {
        this.shouldExit = false;
        if (this.rtScanner != null) {
            this.lastRtScan = System.currentTimeMillis();
        }
        this.mainThread = new Thread(){

            public void run() {
                try {
                    ScanManager.this.mainRunLoop();
                }
                catch (Exception e) {
                    ScanManager.this.log.error((Object)("ERROR in ScanManager thread, exiting: " + e), (Throwable)e);
                }
            }
        };
        this.mainThread.setPriority(1);
        this.mainThread.setDaemon(true);
        this.mainThread.setName("autoinventory-scanner");
        this.mainThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainRunLoop() {
        while (!this.shouldExit) {
            Object watch;
            LinkedList linkedList = this.scannerList;
            synchronized (linkedList) {
                this.activeScanner = this.scannerList.size() > 0 ? (Scanner)this.scannerList.removeFirst() : null;
            }
            if (this.activeScanner == null && this.isTimeForDefaultScan()) {
                watch = new StopWatch();
                this.log.info((Object)"starting default scan");
                this.rtScanner.scheduleDefaultScan();
                this.log.info((Object)("default scan complete " + watch));
                this.lastDefaultScan = System.currentTimeMillis();
                continue;
            }
            if (this.activeScanner != null) {
                try {
                    this.scanInProgress = true;
                    this.activeScanner.start();
                }
                catch (Exception e) {
                    this.log.error((Object)("Exception starting scanner: " + e), (Throwable)e);
                }
                catch (NoClassDefFoundError e) {
                    this.log.error((Object)("Error starting scanner: " + e), (Throwable)e);
                }
                finally {
                    LinkedList e = this.scannerList;
                    synchronized (e) {
                        this.activeScanner = null;
                    }
                    this.scanInProgress = false;
                    this.apm.endScan();
                }
            }
            if (Thread.interrupted()) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (!this.isTimeForRtScan()) continue;
            try {
                watch = new StopWatch();
                this.log.info((Object)"starting runtime scan");
                this.rtScanner.doRuntimeScan();
                this.log.info((Object)("runtime scan complete " + watch));
            }
            catch (Exception e) {
                this.log.error((Object)("Error running runtime autodiscovery scan: " + e), (Throwable)e);
            }
            finally {
                this.lastRtScan = System.currentTimeMillis();
            }
        }
    }

    private boolean isTimeForRtScan() {
        if (this.rtScanner == null) {
            return false;
        }
        long interval = this.rtScanner.getScanInterval();
        return this.rtScanner != null && System.currentTimeMillis() - this.lastRtScan > interval;
    }

    private boolean isTimeForDefaultScan() {
        if (this.rtScanner == null) {
            return false;
        }
        long interval = this.rtScanner.getDefaultScanInterval();
        return System.currentTimeMillis() - this.lastDefaultScan > interval;
    }

    public synchronized void shutdown(long timeout) {
        this.shouldExit = true;
        if (this.mainThread == null) {
            return;
        }
        this.mainThread.interrupt();
        long startSleep = System.currentTimeMillis();
        while (this.mainThread.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (System.currentTimeMillis() - startSleep <= timeout) continue;
            this.mainThread.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queueScan(ScanConfiguration scanConfig) {
        Scanner scanner = new Scanner(scanConfig, this, this.apm, this.autoApproveConfig);
        LinkedList linkedList = this.scannerList;
        synchronized (linkedList) {
            if (this.scannerList.contains(scanner)) {
                return true;
            }
            this.scannerList.addLast(scanner);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptHangingScan() {
        LinkedList linkedList = this.scannerList;
        synchronized (linkedList) {
            ScanState state;
            if (this.activeScanner != null && (state = this.activeScanner.getScanState()) != null && state.getIsDone()) {
                this.mainThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopScan() throws AutoinventoryException {
        boolean wasScanRunning = false;
        LinkedList linkedList = this.scannerList;
        synchronized (linkedList) {
            if (this.activeScanner != null) {
                this.activeScanner.stop();
                if (this.mainThread != null) {
                    this.mainThread.interrupt();
                }
                wasScanRunning = true;
            }
        }
        long startWait = System.currentTimeMillis();
        while (this.scanInProgress) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (System.currentTimeMillis() - startWait <= 60000L) continue;
            throw new AutoinventoryException("Scan did not stop within 1 minute: " + this.activeScanner);
        }
        return wasScanRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanState getStatus() {
        LinkedList linkedList = this.scannerList;
        synchronized (linkedList) {
            if (this.activeScanner != null) {
                return this.activeScanner.getScanState();
            }
        }
        return null;
    }

    public boolean isScanRunning() {
        return this.activeScanner != null;
    }

    public boolean isScanQueued() {
        return this.scannerList.size() != 0;
    }

    public void scanComplete(ScanState state) throws AutoinventoryException, SystemException {
        this.listener.scanComplete(state);
    }
}

