/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.autoinventory.AutoinventoryException;
import org.hyperic.hq.autoinventory.ScanConfiguration;
import org.hyperic.hq.autoinventory.ScanListener;
import org.hyperic.hq.autoinventory.ScanMethod;
import org.hyperic.hq.autoinventory.ScanMethodState;
import org.hyperic.hq.autoinventory.ScanState;
import org.hyperic.hq.autoinventory.ServerSignature;
import org.hyperic.hq.product.AutoinventoryPluginManager;
import org.hyperic.hq.product.HypericOperatingSystem;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.PlatformResource;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginNotFoundException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.util.AutoApproveConfig;
import org.hyperic.util.config.ConfigResponse;

public class Scanner {
    private static final Log _log = LogFactory.getLog((String)Scanner.class.getName());
    private ScanConfiguration _scanConfig = null;
    private ScanListener _scanListener = null;
    private AutoApproveConfig _autoApproveConfig;
    private volatile ScanState _state = new ScanState();
    private volatile boolean _isInterrupted = false;
    private AutoinventoryPluginManager _pluginManager = null;

    public Scanner(ScanConfiguration scanConfig, ScanListener listener, AutoinventoryPluginManager apm, AutoApproveConfig autoApproveConfig) {
        this._scanConfig = scanConfig;
        this._scanListener = listener;
        this._pluginManager = apm;
        if (this._scanConfig.getIsDefaultScan()) {
            this._state.setIsDefaultScan(true);
        }
        this._autoApproveConfig = autoApproveConfig;
    }

    public boolean getIsInterrupted() {
        return this._isInterrupted;
    }

    public static PlatformResource detectPlatform(AutoinventoryPluginManager apm, ConfigResponse config) throws AutoinventoryException {
        PlatformDetector detector;
        boolean isDevice;
        String platformType = HypericOperatingSystem.getInstance().getName();
        String type = null;
        if (config != null) {
            type = config.getValue("platform.type");
        }
        if (type == null) {
            type = platformType;
        }
        boolean bl = isDevice = !type.equals(platformType);
        if (isDevice && _log.isDebugEnabled() && config != null) {
            String fqdn = config.getValue("platform.fqdn");
            String addr = config.getValue("platform.ip");
            _log.debug((Object)("Running discovery for another platform: " + type + "=" + fqdn + "/" + addr));
        }
        try {
            detector = (PlatformDetector)apm.getPlugin(type);
        }
        catch (PluginNotFoundException e) {
            if (isDevice) {
                detector = new PlatformDetector();
            }
            throw new AutoinventoryException("PlatformDetector not found: " + type);
        }
        try {
            return detector.getPlatformResource(config);
        }
        catch (PluginException e) {
            throw new AutoinventoryException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public ScanState getScanState() {
        return this._state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ConfigResponse platformConfig = this._scanConfig.getConfigResponse();
        this._isInterrupted = false;
        try {
            this._state.initStartTime();
            this._state.setScanMethods(this._scanConfig.getScanMethodNames());
            if (this._isInterrupted) {
                this.setStateInterrupted();
                return;
            }
            PlatformResource pValue = Scanner.detectPlatform(this._pluginManager, platformConfig);
            if (this._scanConfig.getIsDefaultScan() && platformConfig == null) {
                platformConfig = new ConfigResponse();
                platformConfig.setValue("platform.fqdn", pValue.getFqdn());
                platformConfig.setValue("platform.name", pValue.getFqdn());
                platformConfig.setValue("platform.type", pValue.getPlatformTypeName());
            }
            this._state.setPlatform(pValue);
            if (this._isInterrupted) {
                this.setStateInterrupted();
                return;
            }
            ServerSignature[] serverSigs = this._scanConfig.getServerSignatures();
            if (serverSigs == null || serverSigs.length == 0) {
                this._state.setAreServersIncluded(false);
                _log.warn((Object)"No server signatures were found.");
                return;
            }
            ServerDetector[] serverDetectors = this.loadDetectors(pValue.getPlatformTypeName(), serverSigs);
            if (serverDetectors == null || serverDetectors.length == 0) {
                _log.warn((Object)"No server detectors were loaded.");
            }
            ScanMethodState[] smStates = this._state.getScanMethodStates();
            for (int i = 0; i < smStates.length; ++i) {
                if (this._isInterrupted) {
                    this.setStateInterrupted();
                    return;
                }
                ScanMethod scanMethod = this._state.findScanMethod(smStates[i].getMethodClass());
                scanMethod.init(this, this._scanConfig.getScanMethodConfig(scanMethod), this._autoApproveConfig);
                try {
                    scanMethod.scan(platformConfig, serverDetectors);
                    continue;
                }
                catch (Exception e) {
                    _log.error((Object)("Error during inventory scan: " + e), (Throwable)e);
                    this._state.addScanException(scanMethod, e);
                }
            }
        }
        catch (Exception global) {
            _log.error((Object)("Global error during inventory scan: " + global), (Throwable)global);
            this._state.setGlobalException(global);
        }
        finally {
            if (this._isInterrupted) {
                this.setStateInterrupted();
                return;
            }
            this._state.setIsDone();
            this._state.initEndTime();
            this.notifyScanComplete();
        }
    }

    private void setStateInterrupted() {
        this._state.setIsInterrupted();
        this._state.setIsDone();
    }

    public void stop() {
        this._isInterrupted = true;
    }

    private ServerDetector[] loadDetectors(String type, ServerSignature[] serverSigs) throws AutoinventoryException {
        ArrayList<ServerDetector> detectorList = new ArrayList<ServerDetector>();
        String pluginName = null;
        try {
            for (int i = 0; i < serverSigs.length; ++i) {
                ServerDetector detector;
                pluginName = serverSigs[i].getServerTypeName();
                try {
                    detector = (ServerDetector)this._pluginManager.getPlatformPlugin(type, pluginName);
                    detector.setAutoApproveConfig(this._autoApproveConfig);
                }
                catch (PluginNotFoundException ne) {
                    _log.warn((Object)ne.getMessage());
                    continue;
                }
                detectorList.add(detector);
            }
        }
        catch (Exception e) {
            String msg = "Error loading server detector class for plugin: '" + pluginName + "'";
            throw new AutoinventoryException(msg, e);
        }
        Collections.sort(detectorList, new Comparator<ServerDetector>(){

            @Override
            public int compare(ServerDetector detector1, ServerDetector detector2) {
                int order1 = detector1.getScanOrder();
                int order2 = detector2.getScanOrder();
                return order1 - order2;
            }
        });
        return detectorList.toArray(new ServerDetector[detectorList.size()]);
    }

    private void notifyScanComplete() {
        try {
            this._scanListener.scanComplete(this._state);
        }
        catch (Exception e) {
            _log.error((Object)"Error in ScanListener.scanComplete", (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Scanner) {
            Scanner s = (Scanner)o;
            return s._scanConfig.equals(this._scanConfig) && s._pluginManager == this._pluginManager && s._scanListener == this._scanListener;
        }
        return false;
    }
}

