/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginInfo;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.hq.product.ServiceTypeInfo;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.pluginxml.PluginData;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.util.PluginLoader;
import org.hyperic.util.PluginLoaderException;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;

public abstract class GenericPlugin {
    private static final String PROP_NETSTAT = "netservices.netstat";
    public static final String PROP_NAME = "NAME";
    static final String[] TYPE_LABELS = new String[]{null, "platform.", "server.", "service."};
    PluginData data = null;
    private static final boolean isWin32 = PlatformDetector.IS_WIN32;
    private String name = null;
    private String version = null;
    private TypeInfo type = null;
    private PluginManager manager = null;
    private ProductPlugin productPlugin = null;
    protected ConfigResponse config;
    private static String hostname = null;
    public static final String FILE_DELIM = ",";
    public static final String FILE_DELIM_ESC = "%2C";

    public void setData(PluginData data) {
        this.data = data;
    }

    public PluginData getPluginData() {
        return this.data;
    }

    static String[] createTypeLabels(String prop) {
        int len = TYPE_LABELS.length;
        String[] labels = new String[len];
        for (int i = 0; i < len; ++i) {
            labels[i] = TYPE_LABELS[i] + prop;
        }
        return labels;
    }

    protected List toFileList(String value) {
        ArrayList<String> values = new ArrayList<String>();
        if (value == null) {
            return values;
        }
        StringTokenizer tok = new StringTokenizer(value, FILE_DELIM);
        while (tok.hasMoreTokens()) {
            String val = tok.nextToken().trim();
            values.add(StringUtil.replace((String)val, (String)FILE_DELIM_ESC, (String)FILE_DELIM));
        }
        return values;
    }

    protected String[] getAbsoluteFiles(String value, String dir) {
        if (dir == null) {
            dir = File.separator;
        }
        List files = this.toFileList(value);
        int size = files.size();
        String[] absoluteFiles = new String[size];
        for (int i = 0; i < size; ++i) {
            File file = new File((String)files.get(i));
            if (!file.isAbsolute()) {
                file = new File(dir, file.toString());
            }
            absoluteFiles[i] = file.toString();
        }
        return absoluteFiles;
    }

    public boolean isNetStatEnabled() {
        return !"false".equals(this.getManagerProperty(PROP_NETSTAT));
    }

    public static boolean isWin32() {
        return isWin32;
    }

    static void setPlatformName(String name) {
        hostname = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPlatformName() {
        if (hostname == null) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exc) {
                Sigar sigar = new Sigar();
                try {
                    hostname = sigar.getNetInfo().getHostName();
                }
                catch (SigarException e) {
                    hostname = "localhost.unknown";
                }
                finally {
                    sigar.close();
                }
            }
        }
        return hostname;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPluginVersion() {
        return this.version;
    }

    public void setPluginVersion(String version) {
        this.version = version;
    }

    public TypeInfo getTypeInfo() {
        return this.type;
    }

    public void setTypeInfo(TypeInfo type) {
        this.type = type;
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        return new ConfigSchema();
    }

    public ConfigSchema getCustomPropertiesSchema(String name) {
        ConfigSchema schema = null;
        if (this.data != null) {
            schema = this.data.getCustomPropertiesSchema(name);
        }
        if (schema == null) {
            schema = new ConfigSchema();
        }
        return schema;
    }

    public ConfigSchema getCustomPropertiesSchema(TypeInfo info) {
        return this.getCustomPropertiesSchema(info.getName());
    }

    public ConfigSchema getCustomPropertiesSchema() {
        return this.getCustomPropertiesSchema(this.getTypeInfo());
    }

    public String getManagerProperty(String key) {
        return this.manager.getProperty(key);
    }

    public String getPluginProperty(String name) {
        if (this.data == null) {
            return null;
        }
        return this.data.getProperty(name);
    }

    public Properties getProperties() {
        return this.data.getProperties();
    }

    public Properties getTypeProperties() {
        Properties props = new Properties();
        Map global = PluginData.getGlobalProperties();
        String prefix = this.getTypeInfo().getName() + ".";
        for (Map.Entry entry : global.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            props.put(key.substring(prefix.length()), entry.getValue());
        }
        return props;
    }

    public String getTypeProperty(String type, String name) {
        return this.getPluginProperty(type + "." + name);
    }

    public String getTypeProperty(TypeInfo type, String name) {
        String value = this.getTypeProperty(type.getName(), name);
        if (value != null) {
            return value;
        }
        if (type.getType() == 3) {
            ServiceTypeInfo service = (ServiceTypeInfo)type;
            return this.getTypeProperty(service.getServerName(), name);
        }
        return this.getPluginProperty(name);
    }

    public String getTypeProperty(String name) {
        return this.getTypeProperty(this.getTypeInfo().getName(), name);
    }

    public String getTypeNameProperty(String type) {
        return this.getTypeProperty(type, PROP_NAME);
    }

    public String getTypeNameProperty() {
        return this.getTypeNameProperty(this.getTypeInfo().getName());
    }

    public void init(PluginManager manager) throws PluginException {
        this.manager = manager;
    }

    public void shutdown() throws PluginException {
    }

    public ConfigResponse getConfig() {
        return this.config;
    }

    public String getConfig(String key) {
        ConfigResponse config = this.getConfig();
        if (config == null) {
            return null;
        }
        return config.getValue(key);
    }

    public void configure(ConfigResponse config) throws PluginException {
        this.config = config;
    }

    public String getDefaultInstallPath() {
        return "/usr/local/apps" + File.separator + this.getTypeInfo().getFormattedName();
    }

    public static String getScriptExtension() {
        return GenericPlugin.getScriptExtension(GenericPlugin.isWin32());
    }

    public String getScriptExtension(TypeInfo info) {
        return GenericPlugin.getScriptExtension(info.isWin32Platform());
    }

    public static String getScriptExtension(boolean isWin32) {
        return "." + (isWin32 ? "bat" : "sh");
    }

    protected String getLogName() {
        return this.getClass().getName();
    }

    protected Log getLog() {
        return LogFactory.getLog((String)this.getLogName());
    }

    ProductPlugin getProductPlugin(String name) {
        ProductPluginManager ppm = (ProductPluginManager)this.manager.getParent();
        PluginInfo info = this.manager.getPluginInfo(name);
        if (info == null) {
            info = ppm.getMeasurementPluginManager().getPluginInfo(name);
        }
        if (info == null) {
            String msg = "Can't find PluginInfo for: " + name;
            throw new IllegalArgumentException(msg);
        }
        return ppm.getProductPlugin(info.product);
    }

    public ProductPlugin getProductPlugin() {
        if (this instanceof ProductPlugin) {
            return (ProductPlugin)this;
        }
        if (this.productPlugin == null) {
            this.productPlugin = this.getProductPlugin(this.getName());
        }
        if (this.productPlugin == null && this.getTypeInfo() != null) {
            this.productPlugin = this.getProductPlugin(this.getTypeInfo().getName());
        }
        return this.productPlugin;
    }

    protected void adjustClassPath(String installpath) {
        ClassLoader cl = this.data.getClassLoader();
        if (!(cl instanceof PluginLoader)) {
            return;
        }
        PluginLoader loader = (PluginLoader)cl;
        List classpath = this.data.getClassPath();
        if (classpath == null) {
            return;
        }
        boolean isDebug = this.getLog().isDebugEnabled();
        URL[] orig = null;
        if (isDebug) {
            orig = loader.getURLs();
        }
        for (int i = 0; i < classpath.size(); ++i) {
            String path = (String)classpath.get(i);
            File file = new File(path);
            if (file.isAbsolute() || file.exists()) continue;
            file = new File(installpath, path);
            if (path.indexOf(42) == -1 && !file.exists()) continue;
            try {
                loader.addURL(file.toString());
                continue;
            }
            catch (PluginLoaderException e) {
                // empty catch block
            }
        }
        if (isDebug) {
            URL[] curr = loader.getURLs();
            if (curr.length > orig.length) {
                for (int i = orig.length; i < curr.length; ++i) {
                    this.getLog().debug((Object)("classpath += " + curr[i].getFile()));
                }
            } else {
                this.getLog().debug((Object)("classpath unchanged using: " + installpath));
            }
        }
    }

    public InputStream openResource(String name) throws IOException {
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream is = PluginData.openPluginResource(loader, name);
        if (is == null) {
            throw new FileNotFoundException("Cannot find: " + name);
        }
        return is;
    }

    public String getPluginClassName(String pluginType, String resourceType) {
        return this.data.getPlugin(pluginType, resourceType);
    }
}

