/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.common.shared.ProductProperties;
import org.hyperic.hq.product.AutoinventoryPluginManager;
import org.hyperic.hq.product.ClientPluginDeployer;
import org.hyperic.hq.product.ConfigTrackPluginManager;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.ControlPluginManager;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.HypericOperatingSystem;
import org.hyperic.hq.product.LiveDataPluginManager;
import org.hyperic.hq.product.LogTrackPluginManager;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.MeasurementPluginManager;
import org.hyperic.hq.product.PlatformTypeInfo;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginExistsException;
import org.hyperic.hq.product.PluginInfo;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.PluginNotFoundException;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.RtPlugin;
import org.hyperic.hq.product.RtPluginManager;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerTypeInfo;
import org.hyperic.hq.product.ServiceTypeInfo;
import org.hyperic.hq.product.TypeBuilder;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.pluginxml.PluginData;
import org.hyperic.util.PluginLoader;
import org.hyperic.util.PluginLoaderException;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.security.MD5;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductPluginManager
extends PluginManager {
    public static final String PROP_PDK_DIR = "agent.pdkDir";
    private static final String PROP_PDK_PLUGINS_DIR = "agent.pdkPluginDir";
    private static final String PROP_PDK_WORK_DIR = "agent.pdkWorkDir";
    static final boolean DEBUG_LIFECYCLE = false;
    private static final String PLUGIN_STUB_NAME = "org.hyperic.hq.product.ProductPluginXML";
    private static final String PLUGIN_STUB = "org/hyperic/hq/product/ProductPluginXML.stub";
    private static final String SYSTEM_PLUGIN = "system";
    private static final String[] BASE_PLUGINS = new String[]{"netservices", "sqlquery"};
    private static final String[] PLUGIN_SUPPORT_DIRS = new String[]{"scripting"};
    private boolean registerTypes = false;
    private boolean client;
    private HashMap<String, PluginManager> managers = new HashMap();
    private Map<String, Map<String, TypeInfo>> types = new HashMap<String, Map<String, TypeInfo>>();
    private HashMap includePlugins = null;
    private HashMap excludePlugins = null;
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private byte[] pluginStub = null;
    private int pluginStubLength = 0;
    private static final File HQ_DIR = new File(System.getProperty("user.home"), ".hq");
    public static final File PLUGIN_PROPERTIES_FILE = new File(HQ_DIR, "plugin.properties");
    public static final String PROPERTY_PREFIX = "hq.plugins.";
    private static final Map<String, String> JAVA_VERSIONS = new HashMap<String, String>();
    private MeasurementPluginManager mpm;
    private ControlPluginManager cpm;
    private AutoinventoryPluginManager apm;
    private RtPluginManager rpm;
    private LogTrackPluginManager ltpm;
    private ConfigTrackPluginManager ctpm;
    private LiveDataPluginManager ldpm;

    public ProductPluginManager() {
        this(System.getProperties());
    }

    public void setRegisterTypes(boolean registerTypes) {
        this.registerTypes = registerTypes;
    }

    public boolean getRegisterTypes() {
        return this.registerTypes;
    }

    public static String getPropertyKey(String plugin, String key) {
        return PROPERTY_PREFIX + plugin + "." + key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getFileProperties(File file) {
        Properties props = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            props.load(is);
        }
        catch (IOException e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ie) {}
            }
        }
        return props;
    }

    public ProductPluginManager(File file) {
        this(ProductPluginManager.getFileProperties(file));
    }

    public ProductPluginManager(Properties props) {
        super(props);
    }

    @Override
    public String getName() {
        return "product";
    }

    public static String getNameFromFile(String file) {
        String name = new File(file).getName();
        int ix = name.indexOf("-plugin.");
        if (ix != -1) {
            return name.substring(0, ix);
        }
        return null;
    }

    public TypeInfo getTypeInfo(String platform, String name) {
        Map<String, TypeInfo> platforms = this.types.get(platform);
        if (platforms == null) {
            return null;
        }
        return platforms.get(name);
    }

    public Map<String, TypeInfo> getTypeInfo(String typeName) {
        Map<String, TypeInfo> typeInfos = Collections.emptyMap();
        if (null != typeName && typeName.length() > 0) {
            typeInfos = new HashMap<String, TypeInfo>(10);
            Map<String, Map<String, TypeInfo>> types = this.getTypes();
            for (Map.Entry<String, Map<String, TypeInfo>> platform : types.entrySet()) {
                TypeInfo typeInfo = platform.getValue().get(typeName);
                if (null == typeInfo) continue;
                typeInfos.put(platform.getKey(), typeInfo);
            }
        }
        return typeInfos;
    }

    public Map<String, Map<String, TypeInfo>> getTypes() {
        return Collections.unmodifiableMap(this.types);
    }

    protected void setTypeInfo(String platform, String name, TypeInfo info) {
        Map<String, TypeInfo> platforms = this.types.get(platform);
        if (platforms == null) {
            platforms = new HashMap<String, TypeInfo>();
            this.types.put(platform, platforms);
        }
        platforms.put(name, info);
    }

    private void registerTypeInfo(TypeInfo[] types) {
        if (types == null) {
            return;
        }
        for (int i = 0; i < types.length; ++i) {
            TypeInfo type = types[i];
            String[] platforms = type.getPlatformTypes();
            for (int j = 0; j < platforms.length; ++j) {
                this.setTypeInfo(platforms[j], type.getName(), type);
            }
        }
    }

    private String[] getPluginNames(String plugins) {
        if (plugins == null) {
            return null;
        }
        List names = StringUtil.explode((String)plugins, (String)",");
        return names.toArray(new String[0]);
    }

    private void initPluginFilters() {
        int i;
        String[] plugins;
        HashMap<String, Integer> basePlugins = new HashMap<String, Integer>();
        basePlugins.put(SYSTEM_PLUGIN, new Integer(1));
        String base = this.getProperty("plugins.base");
        String[] defaultPlugins = base == null ? BASE_PLUGINS : this.getPluginNames(base);
        for (int i2 = 0; i2 < defaultPlugins.length; ++i2) {
            basePlugins.put(defaultPlugins[i2], new Integer(2));
        }
        String include = this.getProperty("plugins.include");
        String exclude = this.getProperty("plugins.exclude");
        if (include != null && exclude != null) {
            this.log.warn((Object)"plugins.{include,exclude} are both defined, use one or the other.");
        }
        if (include != null) {
            this.includePlugins = new HashMap();
            plugins = this.getPluginNames(include);
            for (i = 0; i < plugins.length; ++i) {
                this.includePlugins.put(plugins[i], Boolean.TRUE);
            }
            this.includePlugins.putAll(basePlugins);
        }
        if (exclude != null) {
            this.excludePlugins = new HashMap();
            plugins = this.getPluginNames(exclude);
            for (i = 0; i < plugins.length; ++i) {
                String name = plugins[i];
                if (basePlugins.get(name) == null) {
                    this.excludePlugins.put(name, Boolean.TRUE);
                    continue;
                }
                this.log.warn((Object)("Cannot exclude " + name + " plugin, ignoring."));
            }
        }
    }

    private void setSystemProperties() {
        String pdk = this.getProperty(PROP_PDK_DIR);
        String workDir = this.getProperty(PROP_PDK_WORK_DIR, pdk + "/" + "work");
        String pluginsDir = this.getProperty(PROP_PDK_PLUGINS_DIR, pdk + "/plugins");
        if (pdk != null) {
            ProductPluginManager.setPdkDir(pdk);
            ProductPluginManager.setPdkWorkDir(workDir);
            ProductPluginManager.setPdkPluginsDir(pluginsDir);
            this.log.info((Object)("agent.pdkDir=" + ProductPluginManager.getPdkDir()));
        } else {
            String tmp = System.getProperty("java.io.tmpdir");
            File work = new File(tmp + "/pdk" + workDir);
            ProductPluginManager.setPdkWorkDir(work.getPath());
            if (!work.exists()) {
                work.mkdirs();
            }
        }
        this.log.info((Object)("agent.pdkPluginDir=" + ProductPluginManager.getPdkPluginsDir()));
        this.log.info((Object)("agent.pdkWorkDir=" + ProductPluginManager.getPdkWorkDir()));
    }

    public static String getPdkDir() {
        return System.getProperty(PROP_PDK_DIR);
    }

    public static void setPdkDir(String dir) {
        System.setProperty(PROP_PDK_DIR, dir);
    }

    public static String getPdkPluginsDir() {
        return System.getProperty(PROP_PDK_PLUGINS_DIR);
    }

    public static void setPdkPluginsDir(String dir) {
        System.setProperty(PROP_PDK_PLUGINS_DIR, dir);
    }

    public static String getPdkWorkDir() {
        return System.getProperty(PROP_PDK_WORK_DIR);
    }

    public static void setPdkWorkDir(String dir) {
        System.setProperty(PROP_PDK_WORK_DIR, dir);
    }

    public void init() throws PluginException {
        this.loadProductPluginStub();
        super.init(null);
        Properties props = this.getProperties();
        props.putAll((Map<?, ?>)ProductProperties.getProperties());
        this.setSystemProperties();
        String name = props.getProperty("platform.name");
        if (name != null) {
            GenericPlugin.setPlatformName(name);
        }
        this.initPluginFilters();
        String pdk = ProductPluginManager.getPdkDir();
        if (pdk != null) {
            this.client = new File(pdk, "lib").exists();
        }
        if (this.client) {
            this.log.debug((Object)("Initializing in client mode (pdk=" + pdk + ")"));
        } else {
            this.log.debug((Object)"Initializing in server mode");
        }
        this.initPluginManagers(props);
    }

    protected void initPluginManagers(Properties props) throws PluginException {
        this.mpm = new MeasurementPluginManager(props);
        this.cpm = new ControlPluginManager(props);
        this.apm = new AutoinventoryPluginManager(props);
        this.rpm = new RtPluginManager(props);
        this.ltpm = new LogTrackPluginManager(props);
        this.ctpm = new ConfigTrackPluginManager(props);
        this.ldpm = new LiveDataPluginManager(props);
        PluginManager[] mgrs = new PluginManager[]{this.mpm, this.cpm, this.apm, this.rpm, this.ltpm, this.ctpm, this.ldpm, this};
        for (int i = 0; i < mgrs.length; ++i) {
            PluginManager mgr = mgrs[i];
            mgr.init(this);
            this.managers.put(mgr.getName(), mgr);
            if (this.client) continue;
            this.log.debug((Object)(mgr.getName() + " plugins enabled=" + this.isPluginTypeEnabled(mgr.getName())));
        }
        String plugins = ProductPluginManager.getPdkPluginsDir();
        for (int i = 0; i < PLUGIN_SUPPORT_DIRS.length; ++i) {
            File dir = new File(plugins, PLUGIN_SUPPORT_DIRS[i]);
            if (!dir.exists()) continue;
            this.registerPlugins(dir.getPath(), null);
        }
    }

    public Map<String, String> getPluginVersions(String pluginDir) {
        HashMap<String, String> rtn = new HashMap<String, String>();
        for (int i = 0; i < PLUGIN_SUPPORT_DIRS.length; ++i) {
            File[] pluginFiles;
            File dir = new File(pluginDir, PLUGIN_SUPPORT_DIRS[i]);
            if (!dir.exists()) continue;
            for (File file : pluginFiles = this.listPlugins(dir)) {
                rtn.put(file.toString(), MD5.getMD5Checksum((File)file));
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws PluginException {
        HashMap<String, PluginManager> hashMap = this.managers;
        synchronized (hashMap) {
            this.managers.remove(this.getName());
            for (Map.Entry<String, PluginManager> entry : this.managers.entrySet()) {
                PluginManager manager = entry.getValue();
                try {
                    manager.shutdown();
                }
                catch (PluginException e) {
                    this.log.error((Object)(manager.getName() + ".shutdown() failed"), (Throwable)((Object)e));
                }
            }
            this.types.clear();
            this.managers.clear();
        }
        super.shutdown();
    }

    public MeasurementPluginManager getMeasurementPluginManager() {
        return this.mpm;
    }

    public ControlPluginManager getControlPluginManager() {
        return this.cpm;
    }

    public AutoinventoryPluginManager getAutoinventoryPluginManager() {
        return this.apm;
    }

    public RtPluginManager getRtPluginManager() {
        return this.rpm;
    }

    public LogTrackPluginManager getLogTrackPluginManager() {
        return this.ltpm;
    }

    public ConfigTrackPluginManager getConfigTrackPluginManager() {
        return this.ctpm;
    }

    public LiveDataPluginManager getLiveDataPluginManager() {
        return this.ldpm;
    }

    public MeasurementPlugin getMeasurementPlugin(String name) {
        try {
            return (MeasurementPlugin)this.mpm.getPlugin(name);
        }
        catch (PluginNotFoundException e) {
            this.log.debug((Object)("No MeasurementPlugin found for: " + name));
            return null;
        }
    }

    public ControlPlugin getControlPlugin(String name) {
        try {
            return (ControlPlugin)this.cpm.getPlugin(name);
        }
        catch (PluginNotFoundException e) {
            this.log.debug((Object)("No ControlPlugin found for: " + name));
            return null;
        }
    }

    public ServerDetector getAutoinventoryPlugin(String name) {
        try {
            return (ServerDetector)this.apm.getPlugin(name);
        }
        catch (PluginNotFoundException e) {
            this.log.debug((Object)("No AutoinventoryPlugin found for: " + name));
            return null;
        }
    }

    public RtPlugin getRtPlugin(String name) {
        try {
            return (RtPlugin)this.rpm.getPlugin(name);
        }
        catch (PluginNotFoundException e) {
            this.log.debug((Object)("No RtPlugin found for: " + name));
            return null;
        }
    }

    public ProductPlugin getProductPlugin(String name) {
        try {
            return (ProductPlugin)this.getPlugin(name);
        }
        catch (PluginNotFoundException e) {
            this.log.debug((Object)("No ProductPlugin found for: " + name));
            return null;
        }
    }

    void registerTypePlugin(PluginManager pm, PluginInfo info, GenericPlugin plugin, TypeInfo type) throws PluginExistsException {
        boolean register = this.registerTypes;
        boolean hasServer = false;
        ServerTypeInfo server = null;
        String[] platforms = null;
        String thisPlatform = HypericOperatingSystem.getInstance().getName();
        String name = plugin.getName();
        Object skipMsg = null;
        switch (type.getType()) {
            case 2: {
                server = (ServerTypeInfo)type;
                hasServer = true;
                break;
            }
            case 3: {
                ServiceTypeInfo service = (ServiceTypeInfo)type;
                server = service.getServerTypeInfo();
                hasServer = true;
                break;
            }
            case 1: {
                if (((PlatformTypeInfo)type).isDevice()) {
                    register = true;
                }
                if (register || thisPlatform.equals(name)) break;
                return;
            }
        }
        if (hasServer) {
            if (server.isPlatformDevice()) {
                register = true;
            }
            String[] validPlatforms = server.getValidPlatformTypes();
            if (register) {
                platforms = validPlatforms;
            } else if (Arrays.asList(validPlatforms).contains(thisPlatform)) {
                platforms = new String[]{thisPlatform};
            } else {
                return;
            }
        }
        try {
            PluginInfo gInfo = new PluginInfo(name, info);
            pm.setPluginInfo(name, gInfo);
            pm.registerPlugin(plugin, null);
        }
        catch (PluginExistsException e) {
            if (!hasServer) {
                throw e;
            }
        }
        catch (PluginException e) {
            this.log.error((Object)("registerPlugin=" + plugin.getName()), (Throwable)((Object)e));
        }
        if (!hasServer) {
            return;
        }
        for (int i = 0; i < platforms.length; ++i) {
            String pName = TypeBuilder.composePlatformTypeName(name, platforms[i]);
            try {
                pm.createPlugin(pName, plugin, null);
                continue;
            }
            catch (PluginException e) {
                this.log.error((Object)("createPlugin=" + plugin.getName()), (Throwable)((Object)e));
            }
        }
    }

    private boolean isPluginTypeEnabled(String type) {
        String typeProp = ProductPluginManager.getPropertyKey(type, "disable");
        return !"true".equals(this.getProperty(typeProp));
    }

    public boolean isLoadablePluginName(String name) {
        if (!name.endsWith("-plugin.jar") && !name.endsWith("-plugin.xml")) {
            return false;
        }
        name = name.substring(0, name.length() - 11);
        if (this.includePlugins != null && this.includePlugins.get(name) == null) {
            return false;
        }
        return !this.isExcluded(name);
    }

    private boolean isExcluded(String name) {
        if (name.endsWith("-plugin.jar") || name.endsWith("-plugin.xml")) {
            name = name.substring(0, name.length() - 11);
        }
        return this.excludePlugins != null && this.excludePlugins.get(name) != null;
    }

    public PluginInfo registerPluginJar(String jarName) throws PluginException, PluginExistsException {
        return this.registerPluginJar(jarName, null);
    }

    private void loadProductPluginStub() throws PluginException {
        this.pluginStub = new byte[1024];
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream is = null;
        try {
            is = loader.getResourceAsStream(PLUGIN_STUB);
            if (is == null) {
                throw new PluginException("Unable to find: org/hyperic/hq/product/ProductPluginXML.stub");
            }
            this.pluginStubLength = is.read(this.pluginStub);
        }
        catch (IOException e) {
            throw new PluginException("Unable to read: org/hyperic/hq/product/ProductPluginXML.stub: " + e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private File[] listPlugins(File dir) {
        File[] plugins = dir.listFiles();
        return plugins;
    }

    private String unsupportedClassVersionMessage(String msg) {
        String ex = "Unsupported major.minor version ";
        int ix = msg.indexOf("Unsupported major.minor version ");
        if (ix > -1) {
            String major;
            String jre;
            if ((jre = JAVA_VERSIONS.get(major = msg.substring(ix += "Unsupported major.minor version ".length(), ix + 2))) == null) {
                return msg;
            }
            return "requires JRE " + jre + " or higher";
        }
        return msg;
    }

    public Collection<PluginInfo> getAllPluginInfoDirectFromFileSystem(String path) {
        ArrayList<PluginInfo> rtn = new ArrayList<PluginInfo>();
        List dirs = StringUtil.explode((String)path, (String)File.pathSeparator);
        for (String d : dirs) {
            File[] plugins;
            File dir = new File(d);
            if (!dir.exists() || !dir.isDirectory()) continue;
            for (File plugin : plugins = dir.listFiles()) {
                String name = plugin.getName();
                if (!name.endsWith("-plugin.jar") && !name.endsWith("-plugin.xml")) continue;
                rtn.add(new PluginInfo(plugin, "NONE"));
            }
        }
        return rtn;
    }

    public Collection<PluginInfo> registerPlugins(String path, Collection<PluginInfo> excludes) {
        ArrayList<PluginInfo> rtn = new ArrayList<PluginInfo>();
        List dirs = StringUtil.explode((String)path, (String)File.pathSeparator);
        for (int i = 0; i < dirs.size(); ++i) {
            File dir = new File((String)dirs.get(i));
            if (!dir.exists()) {
                this.log.warn((Object)("register plugins: " + dir + " does not exist"));
                continue;
            }
            if (!dir.isDirectory()) {
                this.log.warn((Object)("register plugins: " + dir + " not a directory"));
                continue;
            }
            File[] plugins = this.listPlugins(dir);
            Collection<PluginInfo> pluginInfo = this.register(Arrays.asList(plugins), excludes);
            rtn.addAll(pluginInfo);
        }
        return rtn;
    }

    private Collection<PluginInfo> register(Collection<File> plugins, Collection<PluginInfo> excludes) {
        ArrayList<PluginInfo> rtn = new ArrayList<PluginInfo>();
        for (File plugin : plugins) {
            PluginInfo info;
            String name = plugin.getName();
            if (!this.isLoadablePluginName(name)) {
                if (!this.isExcluded(name) || excludes == null || !plugin.exists() || plugin.isDirectory()) continue;
                info = new PluginInfo(plugin, "EXCLUDED");
                excludes.add(info);
                continue;
            }
            this.log.info((Object)("Loading plugin: " + name + " (" + plugin.getParent() + ")"));
            try {
                info = null;
                info = this.registerPluginJar(plugin.getAbsolutePath());
                if (info == null) continue;
                rtn.add(info);
            }
            catch (UnsupportedClassVersionError e) {
                this.log.info((Object)("Cannot load " + name + ": " + this.unsupportedClassVersionMessage(e.getMessage())));
            }
            catch (PluginExistsException e) {
                this.log.debug((Object)("Plugin " + name + " already exists."));
            }
            catch (PluginException e) {
                this.log.error((Object)("A problem occured while registering plugin [" + name + "]"), (Throwable)((Object)e));
            }
        }
        return rtn;
    }

    private void addClassPath(PluginLoader loader, String path) throws PluginException {
        try {
            loader.addURL(path);
        }
        catch (PluginLoaderException e) {
            throw new PluginException(e.getMessage());
        }
    }

    private void addClassPath(PluginLoader loader, String name, String[] classpath) throws PluginException {
        if (classpath.length == 0) {
            return;
        }
        String pdkDir = ProductPluginManager.getPdkDir();
        String pdkPluginsDir = ProductPluginManager.getPdkPluginsDir();
        for (int i = 0; i < classpath.length; ++i) {
            String path = classpath[i];
            if (path.startsWith("pdk/plugins/") && pdkPluginsDir != null) {
                path = pdkPluginsDir + "/" + path.substring(12);
            } else if (path.startsWith("pdk/") && pdkDir != null) {
                path = pdkDir + "/" + path.substring(3);
            }
            this.addClassPath(loader, path);
        }
    }

    private void logPluginManifest(String jarName) {
        if (this.log.isDebugEnabled()) {
            try {
                URL url = new URL("jar", "", "file:" + jarName + "!/");
                JarURLConnection jarConn = (JarURLConnection)url.openConnection();
                Attributes attributeMap = jarConn.getManifest().getMainAttributes();
                if (!attributeMap.isEmpty()) {
                    StringBuilder manifestLog = new StringBuilder("\n--- Manifest entries for: " + url.toString() + " ---\n");
                    for (Map.Entry entry : attributeMap.entrySet()) {
                        manifestLog.append(entry.getKey() + " - " + entry.getValue() + "\n");
                    }
                    this.log.debug((Object)manifestLog.toString());
                }
            }
            catch (Exception e) {
                this.log.debug((Object)("Manifest retrieval had an exception (continuing): " + e.getMessage()));
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PluginInfo registerPluginJar(String jarName, ClassLoader resourceLoader) throws PluginException, PluginExistsException {
        PluginInfo pluginInfo;
        block18: {
            TypeInfo[] types;
            PluginInfo info;
            ProductPlugin plugin;
            block16: {
                PluginInfo pluginInfo2;
                block17: {
                    String implName;
                    plugin = null;
                    Class pluginClass = null;
                    String defaultPluginName = ProductPluginManager.getNameFromFile(jarName);
                    PluginLoader loader = PluginLoader.create((String)jarName, (ClassLoader)this.getClass().getClassLoader());
                    this.logPluginManifest(jarName);
                    PluginLoader.setClassLoader((ClassLoader)loader);
                    ClassLoader dataLoader = resourceLoader != null ? resourceLoader : loader;
                    PluginData data = PluginData.getInstance(this, dataLoader, jarName);
                    String[] classpath = ProductPlugin.getDataClassPath(data);
                    this.addClassPath(loader, jarName, classpath);
                    if (jarName.endsWith(".jar")) {
                        String pdk = ProductPluginManager.getPdkWorkDir();
                        ClientPluginDeployer deployer = new ClientPluginDeployer(pdk, defaultPluginName);
                        List jars = deployer.unpackJar(jarName);
                        loader.addURLs(jars);
                    }
                    if ((pluginClass = (implName = data.getPlugin("product", "product")) == null ? loader.loadPlugin(PLUGIN_STUB_NAME, this.pluginStub, this.pluginStubLength) : ProductPlugin.getPluginClass(PluginLoader.getClassLoader(), data, implName, jarName)) == null) {
                        throw new PluginException("Class [" + implName + "] not found " + "via classloader=[" + PluginLoader.getClassLoader());
                    }
                    plugin = (ProductPlugin)pluginClass.newInstance();
                    plugin.data = data;
                    String pluginName = plugin.getName();
                    if (pluginName == null) {
                        pluginName = data.getName();
                    }
                    if (pluginName == null && (pluginName = defaultPluginName) == null) {
                        throw new PluginException("Malformed name for: " + jarName);
                    }
                    if (data.getName() == null) {
                        data.setName(pluginName);
                    }
                    if (plugin.getName() == null) {
                        plugin.setName(pluginName);
                    }
                    if (plugin.getPluginVersion() == null) {
                        plugin.setPluginVersion(data.getVersion());
                    }
                    if (this.client && implName != null) {
                        String[] pluginClasspath = plugin.getClassPath(this);
                        this.addClassPath(loader, plugin.getName(), pluginClasspath);
                    }
                    info = new PluginInfo(plugin, jarName);
                    if (resourceLoader == null) {
                        resourceLoader = plugin.getClass().getClassLoader();
                    }
                    info.resourceLoader = resourceLoader;
                    this.setPluginInfo(pluginName, info);
                    this.registerPlugin(plugin, null);
                    types = plugin.getTypes();
                    if (types != null) break block16;
                    this.log.error((Object)(pluginName + ".getTypes returned null"));
                    pluginInfo2 = null;
                    if (plugin == null) break block17;
                    PluginLoader.resetClassLoader((Object)plugin);
                }
                return pluginInfo2;
            }
            try {
                this.addPluginTypes(types, plugin);
                pluginInfo = info;
                if (plugin == null) break block18;
            }
            catch (PluginException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        throw new PluginException(e2.getMessage(), e2);
                    }
                }
                catch (Throwable throwable) {
                    if (plugin != null) {
                        PluginLoader.resetClassLoader(plugin);
                    }
                    throw throwable;
                }
            }
            PluginLoader.resetClassLoader((Object)plugin);
        }
        return pluginInfo;
    }

    public void addPluginTypes(TypeInfo[] types, ProductPlugin plugin) throws PluginExistsException {
        PluginInfo info = this.getPluginInfo(plugin.getName());
        if (this.registerTypes) {
            this.registerTypeInfo(types);
        }
        for (int i = 0; i < ProductPlugin.TYPES.length; ++i) {
            String type = ProductPlugin.TYPES[i];
            if (type.equals("product") || !this.isPluginTypeEnabled(type)) continue;
            PluginManager pm = this.managers.get(type);
            for (int j = 0; j < types.length; ++j) {
                String typeName = types[j].getName();
                GenericPlugin gPlugin = plugin.getPlugin(type, types[j]);
                if (gPlugin == null) continue;
                gPlugin.data = plugin.data;
                gPlugin.setName(typeName);
                gPlugin.setTypeInfo(types[j]);
                this.registerTypePlugin(pm, info, gPlugin, types[j]);
            }
        }
    }

    public void removePluginTypes(List<TypeInfo> typeInfos) {
        for (int i = 0; i < ProductPlugin.TYPES.length; ++i) {
            String type = ProductPlugin.TYPES[i];
            if (type.equals("product") || !this.isPluginTypeEnabled(type)) continue;
            PluginManager pm = this.managers.get(type);
            Map<String, GenericPlugin> plugins = pm.getPlugins();
            HashSet<String> pluginsToDelete = new HashSet<String>();
            for (GenericPlugin gPlugin : plugins.values()) {
                if (!typeInfos.contains(gPlugin.getTypeInfo())) continue;
                pluginsToDelete.add(gPlugin.getName());
            }
            for (String pluginToDelete : pluginsToDelete) {
                try {
                    pm.removePlugin(pluginToDelete);
                }
                catch (PluginNotFoundException e) {
                    this.log.warn((Object)"Error attempting to remove a plugin that does not exist");
                }
                catch (PluginException e) {
                    this.log.warn((Object)("Error removing a plugin while updating type metadata.  This could cause a PluginExistsException later when an attempt is made to re-register the plugin.  Cause: " + e.getMessage()));
                }
            }
        }
    }

    private void removeManagerPlugins(PluginManager mgr, String jarName) throws PluginException {
        Map<String, GenericPlugin> mPlugins = mgr.getPlugins();
        String[] keys = mPlugins.keySet().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            String name = keys[i];
            PluginInfo info = mgr.getPluginInfo(name);
            if (info == null) {
                String msg = "no plugin info found for " + mgr.getName() + " plugin " + name;
                throw new PluginException(msg);
            }
            if (!info.jar.equals(jarName)) continue;
            try {
                mgr.removePlugin(name);
                continue;
            }
            catch (PluginNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void removePluginJar(String jarName) throws PluginException {
        String fileName = new File(jarName).getName();
        for (Map.Entry<String, PluginManager> entry : this.managers.entrySet()) {
            PluginManager manager = entry.getValue();
            this.removeManagerPlugins(manager, fileName);
        }
    }

    public void updatePluginJar(String jarName) throws PluginException {
        this.removePluginJar(jarName);
        try {
            this.registerPluginJar(jarName);
        }
        catch (PluginExistsException e) {
            throw new PluginException((Throwable)((Object)e));
        }
    }

    public PluginManager getPluginManager(String type) throws PluginException {
        PluginManager mgr = this.managers.get(type);
        if (mgr == null) {
            throw new PluginException();
        }
        return mgr;
    }

    public void setProperty(String key, String value) {
        for (Map.Entry<String, PluginManager> entry : this.managers.entrySet()) {
            PluginManager manager = entry.getValue();
            manager.getProperties().setProperty(key, value);
        }
    }

    public boolean isClient() {
        return this.client;
    }

    @Override
    public ConfigSchema getConfigSchema(String pluginName, String platformName, String typeName, TypeInfo info, ConfigResponse config) throws PluginNotFoundException {
        return this.getConfigSchema(pluginName, info, config);
    }

    static {
        JAVA_VERSIONS.put("48", "1.4");
        JAVA_VERSIONS.put("49", "1.5");
        JAVA_VERSIONS.put("50", "1.6");
        JAVA_VERSIONS.put("51", "1.7");
    }
}

