/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.pluginxml;

import java.util.ArrayList;
import java.util.List;
import org.hyperic.hq.product.pluginxml.BaseTag;
import org.hyperic.hq.product.pluginxml.ConfigOptionTag;
import org.hyperic.hq.product.pluginxml.LateBindingConfigSchema;
import org.hyperic.hq.product.pluginxml.PluginData;
import org.hyperic.hq.product.pluginxml.ResourceTag;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.SchemaBuilder;
import org.hyperic.util.xmlparser.XmlAttrException;
import org.hyperic.util.xmlparser.XmlEndAttrHandler;
import org.hyperic.util.xmlparser.XmlTagException;
import org.hyperic.util.xmlparser.XmlTagHandler;
import org.hyperic.util.xmlparser.XmlTagInfo;

class ConfigTag
extends BaseTag
implements XmlEndAttrHandler {
    private static final String[] OPTIONAL_ATTRS = new String[]{"type", "name", "platform", "include"};
    SchemaBuilder schema;
    private List unresolved;

    ConfigTag(BaseTag parent) {
        super(parent);
    }

    public String getName() {
        return "config";
    }

    public String[] getOptionalAttributes() {
        return OPTIONAL_ATTRS;
    }

    protected ConfigOptionTag getConfigOptionTag() {
        return new ConfigOptionTag(this);
    }

    public XmlTagInfo[] getSubTags() {
        return new XmlTagInfo[]{new XmlTagInfo((XmlTagHandler)this.getConfigOptionTag(), 3)};
    }

    public void startTag() {
        super.startTag();
        this.schema = new SchemaBuilder();
        this.unresolved = new ArrayList();
    }

    private ConfigSchema getConfigSchema(String include) {
        SchemaBuilder includeSchema = (SchemaBuilder)this.getScratch(include);
        if (includeSchema != null) {
            return includeSchema.getSchema();
        }
        return PluginData.getSharedConfigSchema(include);
    }

    static ConfigOption includeConfigOption(ConfigOption option, String defVal) {
        if (defVal != null) {
            try {
                ConfigOption copy = option.copy();
                copy.setDefault(defVal);
                return copy;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return option;
    }

    private ConfigOption includeConfigOption(ConfigOption option) {
        if (!this.isResourceParent()) {
            return option;
        }
        ResourceTag resource = (ResourceTag)this.parent;
        String defVal = resource.getAttribute(option.getName());
        return ConfigTag.includeConfigOption(option, defVal);
    }

    public void endAttributes() throws XmlAttrException {
        ConfigSchema schema = this.schema.getSchema();
        String[] includes = this.getAttributeList("include");
        if (this.isResourceParent()) {
            ResourceTag resource = (ResourceTag)this.parent;
            resource.configName = includes.length == 1 ? includes[0] : null;
        }
        for (int i = 0; i < includes.length; ++i) {
            ConfigSchema includeSchema = this.getConfigSchema(includes[i]);
            if (includeSchema == null) {
                this.unresolved.add(includes[i]);
                continue;
            }
            List options = includeSchema.getOptions();
            for (int j = 0; j < options.size(); ++j) {
                ConfigOption option = (ConfigOption)options.get(j);
                schema.addOption(this.includeConfigOption(option));
            }
        }
    }

    protected void addConfigSchema(String typeName, int idx, ConfigSchema schema) {
        this.data.addConfigSchema(typeName, idx, schema);
    }

    public void endTag() throws XmlTagException {
        int idx;
        String name = this.getAttribute("name");
        String type = this.getAttribute("type");
        boolean isGlobal = this.isGlobalType();
        if (!this.isResourceParent() && name == null) {
            String msg = this.getName() + " name attribute required here";
            throw new XmlTagException(msg);
        }
        if (name != null) {
            if (isGlobal) {
                type = null;
            }
            if (type != null) {
                String msg = "config type " + type + " not allowed with named config";
                throw new XmlTagException(msg);
            }
            if (this.getAttribute("platform") != null) {
                String msg = "config platform attribute not allowed with named config";
                throw new XmlTagException(msg);
            }
            this.putScratch(name, this.schema);
            ConfigSchema configSchema = this.schema.getSchema();
            StringBuffer sb = new StringBuffer();
            String[] options = configSchema.getOptionNames();
            for (int i = 0; i < options.length; ++i) {
                String key = options[i];
                sb.append(key).append('=').append('%').append(key).append('%');
                if (i >= options.length - 1) continue;
                sb.append(',');
            }
            String template = sb.toString();
            String[][] props = new String[][]{{name + ".config", template}, {name + ".template", name + ":" + template}};
            if (isGlobal) {
                for (int i = 0; i < props.length; ++i) {
                    this.data.setGlobalProperty(props[i][0], props[i][1]);
                }
                PluginData.addSharedConfigSchema(name, configSchema);
            } else {
                for (int i = 0; i < props.length; ++i) {
                    this.data.addFilter(props[i][0], props[i][1]);
                }
            }
            return;
        }
        if (type == null || type.equals("product")) {
            idx = 0;
        } else if (type.equals("measurement")) {
            idx = 1;
        } else if (type.equals("control")) {
            idx = 2;
        } else if (type.equals("responsetime")) {
            idx = 3;
        } else {
            throw new XmlTagException("Unsupported config type: " + type);
        }
        ResourceTag resource = (ResourceTag)this.parent;
        ConfigSchema schema = this.schema.getSchema();
        if (this.unresolved.size() != 0) {
            List options = schema.getOptions();
            schema = new LateBindingConfigSchema(this.unresolved, resource.props);
            schema.addOptions(options);
        }
        String typeName = resource.getPlatformName(this);
        this.addConfigSchema(typeName, idx, schema);
        this.schema = null;
        super.endTag();
    }
}

