/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.snmp;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.snmp.MIBLookupException;
import org.hyperic.snmp.MIBTree;
import org.hyperic.snmp.SNMPException;
import org.hyperic.snmp.SNMPSession;
import org.hyperic.snmp.SNMPSessionCache;
import org.hyperic.snmp.SNMPSession_v1;
import org.hyperic.snmp.SNMPSession_v2c;
import org.hyperic.snmp.SNMPSession_v3;
import org.hyperic.util.collection.IntHashMap;
import org.hyperic.util.config.ConfigResponse;
import org.snmp4j.smi.OID;

public class SNMPClient {
    private static final int VERSION_1 = 1;
    private static final int VERSION_2C = 2;
    private static final int VERSION_3 = 3;
    static final int AUTH_MD5 = 0;
    static final int AUTH_SHA = 1;
    public static final String DEFAULT_IP = "127.0.0.1";
    public static final int DEFAULT_PORT = 161;
    public static final String DEFAULT_TRANSPORT = "udp";
    public static final String DEFAULT_USERNAME = "username";
    public static final String DEFAULT_PASSWORD = "";
    public static final String DEFAULT_AUTHTYPE = "none";
    public static final String DEFAULT_PRIV_TYPE = "none";
    public static final String DEFAULT_PORT_STRING = String.valueOf(161);
    public static final String DEFAULT_COMMUNITY = System.getProperty("snmp.defaultCommunity", "public");
    public static final String DEFAULT_RETRIES = "1";
    public static final String DEFAULT_TIMEOUT = "1500";
    public static final String[] VALID_VERSIONS = new String[]{"v1", "v2c", "v3"};
    public static final String PROP_IP = "snmpIp";
    public static final String PROP_PORT = "snmpPort";
    public static final String PROP_TRANSPORT = "snmpTransport";
    public static final String PROP_VERSION = "snmpVersion";
    public static final String PROP_COMMUNITY = "snmpCommunity";
    public static final String PROP_USER = "snmpUser";
    public static final String PROP_PASSWORD = "snmpPassword";
    public static final String PROP_AUTHTYPE = "snmpAuthType";
    public static final String PROP_PRIV_TYPE = "snmpPrivacyType";
    public static final String PROP_PRIV_PASSPHRASE = "snmpPrivacyPassPhrase";
    public static final String PROP_SECURITY_CONTEXT = "snmpSecurityContext";
    public static final String PROP_RETRIES = "snmpRetries";
    public static final String PROP_TIMEOUT = "snmpTimeout";
    private static Log log = LogFactory.getLog(SNMPClient.class);
    private static int CACHE_EXPIRE_DEFAULT = 300000;
    private static IntHashMap sessionCache = null;
    private static MIBTree mibTree;
    private int sessionCacheExpire = CACHE_EXPIRE_DEFAULT;

    private static int parseVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("version is null");
        }
        if (version.equalsIgnoreCase("v1")) {
            return 1;
        }
        if (version.equalsIgnoreCase("v2c")) {
            return 2;
        }
        if (version.equalsIgnoreCase("v3")) {
            return 3;
        }
        throw new IllegalArgumentException("unknown version: " + version);
    }

    public void addMIBs(String jar, String[] accept) {
        try {
            mibTree.parse(new File(jar), accept);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void addMIBs(String[] mibs) {
        for (int i = 0; i < mibs.length; ++i) {
            File file = new File(mibs[i]);
            if (file.exists()) {
                try {
                    mibTree.parse(file);
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            log.debug((Object)("MIB '" + file + "' does not exist"));
        }
    }

    static synchronized OID getMibOID(String mibName) throws MIBLookupException {
        int[] oid = mibTree.getOID(mibName);
        if (oid == null) {
            String msg = "Failed to lookup MIB for name=" + mibName;
            String unfound = mibTree.getLastLookupFailure();
            if (!mibName.equals(unfound)) {
                msg = msg + " (last lookup failure=" + unfound + ")";
            }
            throw new MIBLookupException(msg);
        }
        return new OID(oid);
    }

    public static String getOID(String mibName) {
        try {
            return SNMPClient.getMibOID(mibName).toString();
        }
        catch (MIBLookupException e) {
            return null;
        }
    }

    static SNMPSession startSession(int version) throws SNMPException {
        switch (version) {
            case 1: {
                return new SNMPSession_v1();
            }
            case 2: {
                return new SNMPSession_v2c();
            }
            case 3: {
                return new SNMPSession_v3();
            }
        }
        throw new SNMPException("Invalid SNMP Version: " + version);
    }

    public boolean init(Properties props) throws SNMPException {
        String prop = "snmp.sessionCacheExpire";
        String expire = props.getProperty("snmp.sessionCacheExpire");
        if (expire != null) {
            this.sessionCacheExpire = Integer.parseInt(expire) * 1000;
        }
        if (mibTree == null) {
            mibTree = MIBTree.getInstance();
            sessionCache = new IntHashMap();
        }
        return true;
    }

    public SNMPSession getSession(ConfigResponse config) throws SNMPException {
        return this.getSession(config.toProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SNMPSession getSession(Properties props) throws SNMPException {
        String address = props.getProperty(PROP_IP, DEFAULT_IP);
        String port = props.getProperty(PROP_PORT, DEFAULT_PORT_STRING);
        String version = props.getProperty(PROP_VERSION, VALID_VERSIONS[1]);
        String community = props.getProperty(PROP_COMMUNITY, DEFAULT_COMMUNITY);
        String transport = props.getProperty(PROP_TRANSPORT, DEFAULT_TRANSPORT);
        String user = props.getProperty(PROP_USER, DEFAULT_USERNAME);
        String authtype = props.getProperty(PROP_AUTHTYPE, "none");
        String authpass = props.getProperty(PROP_PASSWORD, DEFAULT_PASSWORD);
        String privtype = props.getProperty(PROP_PRIV_TYPE, "none");
        String privpass = props.getProperty(PROP_PRIV_PASSPHRASE, DEFAULT_PASSWORD);
        String retries = props.getProperty(PROP_RETRIES, DEFAULT_RETRIES);
        String timeout = props.getProperty(PROP_TIMEOUT, DEFAULT_TIMEOUT);
        SNMPSession session = null;
        int id = address.hashCode() ^ port.hashCode() ^ version.hashCode() ^ community.hashCode() ^ transport.hashCode() ^ user.hashCode() ^ authtype.hashCode() ^ authpass.hashCode() ^ privtype.hashCode() ^ privpass.hashCode() ^ retries.hashCode() ^ timeout.hashCode();
        IntHashMap intHashMap = sessionCache;
        synchronized (intHashMap) {
            session = (SNMPSession)sessionCache.get(id);
        }
        if (session != null) {
            return session;
        }
        int snmpVersion = SNMPClient.parseVersion(version);
        try {
            session = SNMPClient.startSession(snmpVersion);
            switch (snmpVersion) {
                case 1: 
                case 2: {
                    ((SNMPSession_v1)session).init(address, port, community, transport, retries, timeout);
                    break;
                }
                case 3: {
                    ((SNMPSession_v3)session).init(address, port, transport, user, authtype, authpass, privtype, privpass, retries, timeout);
                    break;
                }
                default: {
                    throw new SNMPException("Unsupported SNMP version: " + snmpVersion);
                }
            }
        }
        catch (SNMPException e) {
            String msg = "Failed to initialize SNMP session: " + e.getMessage();
            throw new SNMPException(msg, (Throwable)((Object)e));
        }
        session = SNMPSessionCache.newInstance(session, this.sessionCacheExpire);
        IntHashMap intHashMap2 = sessionCache;
        synchronized (intHashMap2) {
            sessionCache.put(id, (Object)session);
        }
        return session;
    }
}

