/*
 * Decompiled with CFR 0.152.
 */
package org.novadeck.jxla.data;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Line
implements Cloneable {
    private GregorianCalendar _date = new GregorianCalendar();
    private String _host;
    private String _remoteIP;
    private String _uri;
    private String _referer;
    private String _userAgent;
    private Long _status;
    private long _size;
    private double _time_taken;
    private String _user;
    private String _keywords = null;
    private double _timeMultiplier;
    private static Line INSTANCE = new Line();

    private Line() {
    }

    public void release() {
        this._host = null;
        this._remoteIP = null;
        this._uri = null;
        this._referer = null;
        this._userAgent = null;
        this._status = null;
        this._size = -1L;
        this._time_taken = -1.0;
        this._user = null;
        this._keywords = null;
    }

    public static Line getLine(String host, int day, int month, int year, int hour, int minute, int second, String remoteIp, String uri, String referer, String userAgent, String status, long size, String user, double time_taken, String offset, long date_msec) {
        INSTANCE.release();
        Line.INSTANCE._host = host;
        if (date_msec == -1L) {
            if (offset != null) {
                Line.INSTANCE._date.setTimeZone(TimeZone.getTimeZone("GMT" + offset));
            } else {
                Line.INSTANCE._date.setTimeZone(TimeZone.getTimeZone("GMT"));
            }
            Line.INSTANCE._date.set(5, day);
            Line.INSTANCE._date.set(2, month);
            Line.INSTANCE._date.set(1, year);
            Line.INSTANCE._date.set(11, hour);
            Line.INSTANCE._date.set(12, minute);
            Line.INSTANCE._date.set(13, second);
            Line.INSTANCE._date.set(14, 0);
        } else {
            Line.INSTANCE._date.setTimeInMillis(date_msec);
        }
        Line.INSTANCE._remoteIP = remoteIp;
        int i = uri.indexOf(63);
        Line.INSTANCE._uri = uri;
        if (referer != null && referer.startsWith("http://") && referer.toLowerCase().startsWith("http://" + host)) {
            referer = null;
        }
        Line.INSTANCE._referer = referer;
        Line.INSTANCE._userAgent = userAgent;
        Line.INSTANCE._status = status != null ? new Long(Integer.parseInt(status)) : new Long(0L);
        Line.INSTANCE._size = size;
        Line.INSTANCE._time_taken = time_taken * Line.INSTANCE._timeMultiplier;
        Line.INSTANCE._user = user;
        return INSTANCE;
    }

    public Date getDate() {
        return this._date.getTime();
    }

    public String getLogDate() {
        return this._date.getTime().toGMTString();
    }

    public String getHost() {
        return this._host;
    }

    public String getURI() {
        return this._uri;
    }

    public String getReferer() {
        return this._referer;
    }

    public String getKeywords() {
        return this._keywords;
    }

    public String getRemoteIP() {
        return this._remoteIP;
    }

    public Long getStatus() {
        return this._status;
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public long getSize() {
        return this._size;
    }

    public double getTimeTaken() {
        return this._time_taken;
    }

    public String getUser() {
        return this._user;
    }

    public boolean isLineEmpty() {
        return this._host == null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("host ==" + this._host + "\n");
        sb.append("uri ==" + this._uri + "\n");
        sb.append("remoteIP ==" + this._remoteIP + "\n");
        sb.append("referer ==" + this._referer + "\n");
        sb.append("status ==" + this._status + "\n");
        sb.append("date ==" + this._date + "\n");
        sb.append("agent ==" + this._userAgent + "\n");
        sb.append("time_taken ==" + this._time_taken + "\n");
        return sb.toString();
    }

    public Object clone() {
        Line myline = new Line();
        myline._date = (GregorianCalendar)this._date.clone();
        myline._host = this._host;
        myline._remoteIP = this._remoteIP;
        myline._uri = this._uri;
        myline._referer = this._referer;
        myline._userAgent = this._userAgent;
        myline._status = this._status;
        myline._size = this._size;
        myline._time_taken = this._time_taken;
        myline._user = this._user;
        myline._keywords = this._keywords;
        return myline;
    }

    public static void setTimeMultiplier(double t) {
        Line.INSTANCE._timeMultiplier = t;
    }

    public static double getTimeMultiplier() {
        return Line.INSTANCE._timeMultiplier;
    }
}

