/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.oracle;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.FileServerDetector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.jdbc.DBUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleServerDetector
extends ServerDetector
implements FileServerDetector,
AutoServerDetector {
    private transient Log log = LogFactory.getLog((String)"OracleServerDetector");
    private static final String PTQL_QUERY = "State.Name.eq=oracle";
    private static final String TNS_PTQL_QUERY = "State.Name.eq=tnslsnr";
    private static final String PROP_PROC_PTQL = "process.ptql";
    private static final String PROP_TNSNAMES = "tnsnames";
    private static final String ORATAB = "/etc/oratab";
    private static final Pattern _serviceNameEx = Pattern.compile("\\(\\s*service_name\\s*=", 2);
    static final String VERSION_8i = "8i";
    static final String VERSION_9i = "9i";
    static final String VERSION_10g = "10g";
    static final String VERSION_11g = "11g";
    static final String USER_INSTANCE = "User Instance";
    static final String USER_QUERY = "SELECT UNIQUE username FROM V$SESSION WHERE username IS NOT NULL";
    static final String DBA_USER_QUERY = "SELECT * FROM DBA_USERS WHERE USERNAME = ";
    static final String TABLESPACE = "Tablespace";
    static final String TABLESPACE_QUERY = "SELECT * FROM DBA_TABLESPACES";
    static final String SEGMENT = "Segment";
    static final String SEGMENT_QUERY = "select SEGMENT_NAME, TABLESPACE_NAME FROM USER_SEGMENTS WHERE SEGMENT_NAME not like 'BIN$%' and SEGMENT_NAME not like 'SYS_%'";
    static final String VERSION_QUERY = "SELECT * FROM V$VERSION";

    private List getServerProcessList() {
        ArrayList<String> servers = new ArrayList<String>();
        long[] pids = OracleServerDetector.getPids((String)PTQL_QUERY);
        for (int i = 0; i < pids.length; ++i) {
            File binary;
            String exe = OracleServerDetector.getProcExe((long)pids[i]);
            if (exe == null || !(binary = new File(exe.toLowerCase())).isAbsolute() || servers.contains(binary.getAbsolutePath())) continue;
            servers.add(binary.getAbsolutePath());
        }
        return servers;
    }

    private boolean hasExe(File bin, String name) {
        if (OracleServerDetector.isWin32()) {
            return new File(bin, name + ".exe").exists() || new File(bin, name + ".bat").exists();
        }
        return new File(bin, name).exists();
    }

    private boolean hasFile(File dir, final String file) {
        String[] names = dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().indexOf(file) != -1;
            }
        });
        return names != null && names.length != 0;
    }

    private boolean configureProperties(ConfigResponse config) {
        boolean hasCreds = false;
        String[] keys = this.getConfigSchema(this.getTypeInfo(), config).getOptionNames();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            String val = this.getManager().getProperty(key);
            if (val == null) continue;
            config.setValue(key, val);
            if (!key.startsWith("jdbc")) continue;
            hasCreds = true;
        }
        return hasCreds;
    }

    private ServerResource getOracleServer(String oracleExePath) throws PluginException {
        this.log.debug((Object)("Found oracle exe path=" + oracleExePath));
        ServerResource oracleServer = null;
        String version = this.getTypeInfo().getVersion();
        boolean found = false;
        File oracleExe = new File(oracleExePath);
        File binDirectory = oracleExe.getParentFile();
        if (!binDirectory.getName().equals("bin")) {
            throw new PluginException("Unable to locate correct oracle home: " + binDirectory.getParent());
        }
        String oracleHome = binDirectory.getParent();
        if (oracleExe.exists() && binDirectory.isDirectory()) {
            found = this.hasExe(binDirectory, "adrci") ? version.equals(VERSION_11g) : (this.hasExe(binDirectory, "trcsess") || this.hasFile(binDirectory, "orasql10.") ? version.equals(VERSION_10g) : (this.hasExe(binDirectory, "dgmgrl") ? version.equals(VERSION_9i) : version.equals(VERSION_8i)));
        }
        if (found) {
            ConfigResponse productConfig = new ConfigResponse();
            oracleServer = this.createServerResource(oracleHome);
            oracleServer.setIdentifier(oracleHome);
            ConfigResponse cprop = new ConfigResponse();
            cprop.setValue("version", version);
            oracleServer.setCustomProperties(cprop);
            this.setListeningPorts(productConfig);
            this.setProductConfig(oracleServer, productConfig);
            if (!version.equals(VERSION_9i) && !version.equals(VERSION_8i)) {
                oracleServer.setControlConfig();
            }
            if (this.configureProperties(productConfig)) {
                oracleServer.setMeasurementConfig();
            }
        }
        String fs = File.separator;
        String tnsDir = this.getTnsNamesDir(oracleHome, "network" + fs + "admin" + fs + "tnsnames.ora");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("using tns dir as " + tnsDir));
        }
        System.setProperty("oracle.net.tns_admin", tnsDir);
        return oracleServer;
    }

    private void setListeningPorts(ConfigResponse productConfig) {
        HashSet<Long> allPids = new HashSet<Long>();
        for (long pid : OracleServerDetector.getPids((String)PTQL_QUERY)) {
            allPids.add(pid);
        }
        for (long pid : OracleServerDetector.getPids((String)TNS_PTQL_QUERY)) {
            allPids.add(pid);
        }
        this.populateListeningPorts(allPids, productConfig);
    }

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        List paths = this.getServerProcessList();
        for (int i = 0; i < paths.size(); ++i) {
            String pathToOracleExe = (String)paths.get(i);
            this.log.debug((Object)("Found oracle process path in process scan = " + pathToOracleExe));
            ServerResource oracleServer = this.getOracleServer(pathToOracleExe);
            if (oracleServer == null) continue;
            servers.add(oracleServer);
        }
        if (servers.size() == 0 && !OracleServerDetector.isWin32()) {
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(ORATAB));
                while ((line = in.readLine()) != null) {
                    if (line.length() == 0 || line.startsWith("#")) continue;
                    int x1 = line.indexOf(58);
                    int x2 = line.indexOf(58, x1 + 1);
                    if (x1 == -1 || x2 == -1) continue;
                    String oraSid = line.substring(0, x1);
                    this.log.debug((Object)("Found oracle sid = " + oraSid));
                    String oraHome = line.substring(x1 + 1, x2);
                    this.log.debug((Object)("Found ORACLE_HOME in /etc/oratab =" + oraHome));
                    String oracleExePath = oraHome + File.separator + "bin" + File.separator + "oracle";
                    ServerResource oracleServer = this.getOracleServer(oracleExePath);
                    if (oracleServer == null) continue;
                    ConfigResponse productConfig = oracleServer.getProductConfig();
                    productConfig.setValue("jdbcUrl", "jdbc:oracle:thin:@localhost:1521:" + oraSid);
                    this.setListeningPorts(productConfig);
                    oracleServer.setProductConfig(productConfig);
                    servers.add(oracleServer);
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                this.log.error((Object)("Error parsing oratab: " + e));
            }
        }
        return servers;
    }

    public List getServerResources(ConfigResponse platformConfig, String path) throws PluginException {
        ArrayList<ServerResource> serverResources = new ArrayList<ServerResource>();
        ServerResource oracleServer = this.getOracleServer(path);
        if (oracleServer != null) {
            serverResources.add(this.getOracleServer(path));
        }
        return serverResources;
    }

    protected List discoverServices(ConfigResponse config) throws PluginException {
        String pass;
        String tnsDir = this.getTnsNamesDir(config.getValue("installpath"), config.getValue(PROP_TNSNAMES));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("using tns dir as " + tnsDir));
        }
        System.setProperty("oracle.net.tns_admin", tnsDir);
        String url = config.getValue("jdbcUrl");
        if (url == null) {
            this.log.warn((Object)"No value for config property jdbcUrl, no services will be discovered.");
            return null;
        }
        String user = config.getValue("jdbcUser");
        if (user == null) {
            this.log.info((Object)"No value for config property jdbcUser");
        }
        if ((pass = config.getValue("jdbcPassword")) == null) {
            this.log.info((Object)"No value for config property jdbcPassword");
        }
        ArrayList services = new ArrayList();
        Connection conn = null;
        Statement stmt = null;
        try {
            String instance = url.substring(url.lastIndexOf(58) + 1);
            conn = DriverManager.getConnection(url, user, pass);
            stmt = conn.createStatement();
            services.addAll(this.getUserServices(stmt, instance));
            services.addAll(this.getTablespaceServices(stmt, instance));
            services.addAll(this.getProcessServices(config));
            this.setCustomProps(stmt);
        }
        catch (SQLException e) {
            block9: {
                ArrayList arrayList;
                try {
                    if (e.getMessage().indexOf("table or view does not exist") == -1) break block9;
                    this.log.error((Object)"System table does not exist, make sure that  the Oracle user specified has the correct  privileges.  See the HQ server configuration  page for more information");
                    arrayList = services;
                }
                catch (Throwable throwable) {
                    DBUtil.closeJDBCObjects((Object)this.log, conn, stmt, null);
                    throw throwable;
                }
                DBUtil.closeJDBCObjects((Object)this.log, (Connection)conn, (Statement)stmt, null);
                return arrayList;
            }
            throw new PluginException("Error querying for Oracle services: " + e.getMessage(), (Throwable)e);
        }
        DBUtil.closeJDBCObjects((Object)this.log, (Connection)conn, (Statement)stmt, null);
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCustomProps(Statement stmt) throws SQLException {
        ResultSet rs = null;
        try {
            ConfigResponse props = new ConfigResponse();
            rs = stmt.executeQuery(VERSION_QUERY);
            if (rs != null && rs.next()) {
                String version = rs.getString(1);
                props.setValue("version", version);
            }
            this.setCustomProperties(props);
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet((Object)this.log, rs);
            throw throwable;
        }
        DBUtil.closeResultSet((Object)this.log, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getUserServices(Statement stmt, String instance) throws SQLException {
        ArrayList<ServiceResource> rtn = new ArrayList<ServiceResource>();
        ResultSet rs = null;
        try {
            this.setDescription("Oracle " + instance + " database instance");
            ArrayList<String> users = new ArrayList<String>();
            rs = stmt.executeQuery(USER_QUERY);
            while (rs != null && rs.next()) {
                String username = rs.getString(1);
                users.add(username);
            }
            rs.close();
            for (int i = 0; i < users.size(); ++i) {
                String username = (String)users.get(i);
                ServiceResource service = new ServiceResource();
                service.setType((GenericPlugin)this, USER_INSTANCE);
                service.setServiceName(username);
                service.setDescription("User of the " + instance + " database instance");
                ConfigResponse productConfig = new ConfigResponse();
                ConfigResponse metricConfig = new ConfigResponse();
                productConfig.setValue("user", username);
                service.setProductConfig(productConfig);
                service.setMeasurementConfig(metricConfig);
                rs = stmt.executeQuery("SELECT * FROM DBA_USERS WHERE USERNAME = '" + username + "'");
                if (rs != null && rs.next()) {
                    ConfigResponse svcProps = new ConfigResponse();
                    svcProps.setValue("status", rs.getString("ACCOUNT_STATUS"));
                    svcProps.setValue("default_tablespace", rs.getString("DEFAULT_TABLESPACE"));
                    svcProps.setValue("temp_tablespace", rs.getString("TEMPORARY_TABLESPACE"));
                    service.setCustomProperties(svcProps);
                }
                rtn.add(service);
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet((Object)this.log, rs);
            throw throwable;
        }
        DBUtil.closeResultSet((Object)this.log, (ResultSet)rs);
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getSegmentServices(Statement stmt, String instance) throws SQLException {
        ArrayList<ServiceResource> rtn = new ArrayList<ServiceResource>();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(SEGMENT_QUERY);
            int segment_col = rs.findColumn("SEGMENT_NAME");
            int ts_col = rs.findColumn("TABLESPACE_NAME");
            while (rs != null && rs.next()) {
                String segment = rs.getString(segment_col);
                String tablespace = rs.getString(ts_col);
                ServiceResource service = new ServiceResource();
                service.setType((GenericPlugin)this, SEGMENT);
                service.setServiceName(segment);
                service.setDescription("Segment in the " + instance + " database instance");
                ConfigResponse productConfig = new ConfigResponse();
                ConfigResponse metricConfig = new ConfigResponse();
                productConfig.setValue("segment", segment);
                productConfig.setValue("tablespace", tablespace);
                service.setProductConfig(productConfig);
                service.setMeasurementConfig(metricConfig);
                service.setControlConfig();
                rtn.add(service);
            }
        }
        finally {
            DBUtil.closeResultSet((Object)this.log, (ResultSet)rs);
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getTablespaceServices(Statement stmt, String instance) throws SQLException {
        ArrayList<ServiceResource> rtn = new ArrayList<ServiceResource>();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(TABLESPACE_QUERY);
            int ts_col = rs.findColumn("TABLESPACE_NAME");
            while (rs != null && rs.next()) {
                String tablespace = rs.getString(ts_col);
                ServiceResource service = new ServiceResource();
                service.setType((GenericPlugin)this, TABLESPACE);
                service.setServiceName(tablespace);
                service.setDescription("Tablespace on the " + instance + " database instance");
                ConfigResponse productConfig = new ConfigResponse();
                ConfigResponse metricConfig = new ConfigResponse();
                productConfig.setValue("tablespace", tablespace);
                service.setProductConfig(productConfig);
                service.setMeasurementConfig(metricConfig);
                ConfigResponse svcProps = new ConfigResponse();
                if (!this.getTypeInfo().getVersion().equals(VERSION_8i)) {
                    svcProps.setValue("block_size", rs.getString("BLOCK_SIZE"));
                    svcProps.setValue("allocation_type", rs.getString("ALLOCATION_TYPE"));
                    svcProps.setValue("space_management", rs.getString("SEGMENT_SPACE_MANAGEMENT"));
                }
                svcProps.setValue("contents", rs.getString("CONTENTS"));
                svcProps.setValue("logging", rs.getString("LOGGING"));
                service.setCustomProperties(svcProps);
                rtn.add(service);
            }
        }
        finally {
            DBUtil.closeResultSet((Object)this.log, (ResultSet)rs);
        }
        return rtn;
    }

    private List getProcessServices(ConfigResponse config) {
        ArrayList<ServiceResource> rtn = new ArrayList<ServiceResource>();
        String ptql = config.getValue(PROP_PROC_PTQL);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("using ptql, " + ptql + ", to retrieve processes"));
        }
        List processes = this.getProcesses(ptql);
        for (String process : processes) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("adding Process Metrics " + process + " service"));
            }
            ServiceResource service = new ServiceResource();
            service.setType((GenericPlugin)this, "Process Metrics");
            service.setServiceName(process + " process");
            ConfigResponse productConfig = new ConfigResponse();
            ptql = "State.Name.eq=oracle,Args.0.sw=" + process;
            productConfig.setValue("process.query", ptql);
            service.setProductConfig(productConfig);
            service.setMeasurementConfig();
            rtn.add(service);
        }
        return rtn;
    }

    private List getProcesses(String ptql) {
        long[] pids = OracleServerDetector.getPids((String)ptql);
        ArrayList<String> rtn = new ArrayList<String>();
        for (int i = 0; i < pids.length; ++i) {
            String[] args = OracleServerDetector.getProcArgs((long)pids[i]);
            if (args.length == 0 || args[0] == null) continue;
            rtn.add(args[0]);
        }
        return rtn;
    }

    private String getTnsNamesDir(String installpath, String tnsnames) {
        if (installpath == null || tnsnames == null) {
            return "";
        }
        String fs = File.separator;
        String[] toks = tnsnames.split(Pattern.quote(fs));
        StringBuilder rtn = new StringBuilder();
        for (int i = 0; i < toks.length - 1; ++i) {
            rtn.append(toks[i]).append(fs);
        }
        return installpath + fs + rtn.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getTnsServices(ConfigResponse config) {
        BufferedReader reader = null;
        String tnsnames = config.getValue(PROP_TNSNAMES);
        String installpath = config.getValue("installpath");
        ArrayList<ServiceResource> rtn = new ArrayList<ServiceResource>();
        try {
            String line;
            String fs = File.separator;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("READING tnsnames.ora FILE: " + installpath + fs + tnsnames));
            }
            reader = new BufferedReader(new FileReader(installpath + fs + tnsnames));
            while (null != (line = reader.readLine())) {
                String[] toks;
                if (!_serviceNameEx.matcher(line).find() || (toks = line.split("="))[1] == null) continue;
                String tnslistener = toks[1].replaceAll("\\s*\\)", "").trim();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Configuring TNS Listener " + tnslistener));
                }
                ServiceResource service = new ServiceResource();
                service.setType((GenericPlugin)this, "TNS Ping");
                service.setServiceName(tnslistener + " TNS Ping");
                ConfigResponse productConfig = new ConfigResponse();
                productConfig.setValue("tnslistener", tnslistener);
                service.setProductConfig(productConfig);
                service.setMeasurementConfig();
                rtn.add(service);
            }
            this.close(reader);
        }
        catch (IOException e) {
            this.log.error((Object)("Error reading " + tnsnames));
        }
        finally {
            this.close(reader);
        }
        return rtn;
    }

    private void close(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void populateListeningPorts(Set<Long> pids, ConfigResponse productConfig) {
        try {
            Class<?> du = Class.forName("org.hyperic.hq.product.DetectionUtil");
            Method plp = du.getMethod("populateListeningPorts", Long.TYPE, ConfigResponse.class);
            plp.invoke(null, pids, productConfig);
        }
        catch (ClassNotFoundException ex) {
            this.log.debug((Object)"[populateListeningPorts] Class 'DetectionUtil' not found", (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            this.log.debug((Object)"[populateListeningPorts] Method 'populateListeningPorts' not found", (Throwable)ex);
        }
        catch (Exception ex) {
            this.log.debug((Object)"[populateListeningPorts] Problem with Method 'populateListeningPorts'", (Throwable)ex);
        }
    }
}

