/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class FileData
implements Externalizable {
    public static final int WRITETYPE_CREATEONLY = 1;
    public static final int WRITETYPE_CREATEOROVERWRITE = 2;
    public static final int WRITETYPE_REWRITE = 3;
    private String destFile;
    private long size;
    private int writeType;
    private String md5sum;

    public FileData() {
    }

    public FileData(String destFile, long size, int writeType) {
        if (destFile == null) {
            throw new NullPointerException("destination file is null");
        }
        this.destFile = destFile;
        this.size = size;
        this.writeType = writeType;
        if (this.writeType < 1 || this.writeType > 3) {
            throw new IllegalArgumentException("Unknown write-type, " + writeType);
        }
    }

    public void setMD5CheckSum(String md5sum) {
        if (md5sum == null) {
            throw new NullPointerException("md5sum check sum is null");
        }
        this.md5sum = md5sum;
    }

    public String getMD5CheckSum() {
        return this.md5sum;
    }

    public String getDestFile() {
        return this.destFile;
    }

    public long getSize() {
        return this.size;
    }

    public int getWriteType() {
        return this.writeType;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.destFile = in.readUTF();
        this.size = in.readLong();
        this.writeType = in.readInt();
        this.md5sum = in.readUTF();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.destFile);
        out.writeLong(this.size);
        out.writeInt(this.writeType);
        out.writeUTF(this.md5sum);
    }
}

