/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.commands;

import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.PropertyPair;

public abstract class SetProperties_args
extends AgentRemoteValue {
    private static final String PARAM_PNAME = "propName";
    private static final String PARAM_PVAL = "propValue";
    private static final String PARAM_NPROPS = "nProps";

    private void setup() {
        this.setNumProperties(0);
    }

    public SetProperties_args() {
        this.setup();
    }

    public SetProperties_args(AgentRemoteValue args) throws AgentRemoteException {
        this.setup();
        int nProps = args.getValueAsInt(PARAM_NPROPS);
        for (int i = 0; i < nProps; ++i) {
            String key = args.getValue(PARAM_PNAME + i);
            String val = args.getValue(PARAM_PVAL + i);
            this.addProperty(key, val);
        }
    }

    public int getNumProperties() {
        String val = this.getValue(PARAM_NPROPS);
        return Integer.parseInt(val);
    }

    private void setNumProperties(int newMeas) {
        super.setValue(PARAM_NPROPS, Integer.toString(newMeas));
    }

    public void addProperty(String key, String value) {
        int curProps = this.getNumProperties();
        super.setValue(PARAM_PNAME + curProps, key);
        super.setValue(PARAM_PVAL + curProps, value);
        this.setNumProperties(curProps + 1);
    }

    public void setValue(String key, String val) {
        throw new AgentAssertionException("This should never be called");
    }

    public PropertyPair getProperty(int propNum) {
        String kval = PARAM_PNAME + propNum;
        String nval = PARAM_PVAL + propNum;
        return new PropertyPair(this.getValue(kval), this.getValue(nval));
    }
}

