/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.agent.client;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.hyperic.hq.agent.client.AgentConnection;
import org.hyperic.util.security.DefaultSSLProviderImpl;
import org.hyperic.util.security.KeystoreConfig;

public class SecureAgentConnection
extends AgentConnection {
    private static final Log log = LogFactory.getLog(SecureAgentConnection.class);
    private static final String PROP_READ_TIMEOUT = "agent.readTimeOut";
    private static final String PROP_POST_HANDSHAKE_TIMEOUT = "agent.postHandshakeTimeOut";
    private static final int READ_TIMEOUT = 60000;
    private static final int POST_HANDSHAKE_TIMEOUT = 300000;
    private String agentAddress;
    private int agentPort;
    private String authToken;
    private boolean acceptUnverifiedCertificate = false;
    private KeystoreConfig keystoreConfig;

    private SecureAgentConnection(KeystoreConfig keystoreConfig, String agentAddress, int agentPort, String authToken) {
        super(agentAddress, agentPort);
        this.agentAddress = agentAddress;
        this.agentPort = agentPort;
        this.authToken = authToken;
        this.keystoreConfig = keystoreConfig;
    }

    public SecureAgentConnection(String agentAddress, int agentPort, String authToken, KeystoreConfig keystoreConfig, boolean acceptUnverifiedCertificate) {
        this(keystoreConfig, agentAddress, agentPort, authToken);
        this.acceptUnverifiedCertificate = acceptUnverifiedCertificate;
    }

    protected Socket getSocket() throws IOException {
        SSLSocket socket;
        log.debug((Object)"Creating secure socket");
        try {
            int postHandshakeTimeout;
            int readTimeout;
            try {
                readTimeout = Integer.parseInt(System.getProperty(PROP_READ_TIMEOUT));
            }
            catch (NumberFormatException e) {
                readTimeout = 60000;
            }
            try {
                postHandshakeTimeout = Integer.parseInt(System.getProperty(PROP_POST_HANDSHAKE_TIMEOUT));
            }
            catch (NumberFormatException e) {
                postHandshakeTimeout = 300000;
            }
            DefaultSSLProviderImpl sslProvider = new DefaultSSLProviderImpl(this.keystoreConfig, this.acceptUnverifiedCertificate);
            SSLSocketFactory factory = sslProvider.getSSLSocketFactory();
            socket = (SSLSocket)factory.createSocket();
            InetAddress withoutHost = InetAddress.getByName(this.agentAddress);
            InetAddress withHost = InetAddress.getByAddress("", withoutHost.getAddress());
            InetSocketAddress address = new InetSocketAddress(withHost, this.agentPort);
            socket.connect(address, readTimeout);
            socket.setSoTimeout(readTimeout);
            log.debug((Object)("Secure socket is connected to " + address + " - starting handshake."));
            socket.startHandshake();
            log.debug((Object)"SSL handshake complete");
            socket.setSoTimeout(postHandshakeTimeout);
        }
        catch (IOException exc) {
            IOException toThrow = new IOException("Unable to connect to " + this.agentAddress + ":" + this.agentPort + ": " + exc.getMessage());
            toThrow.initCause(exc);
            throw toThrow;
        }
        try {
            DataOutputStream dOs = new DataOutputStream(socket.getOutputStream());
            dOs.writeUTF(this.authToken);
        }
        catch (IOException exc) {
            IOException toThrow = new IOException("Unable to write auth params to server");
            toThrow.initCause(exc);
            throw toThrow;
        }
        return socket;
    }

    public String toString() {
        return this.agentAddress + ":" + this.agentPort;
    }
}

