/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.transport.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.hyperic.hq.transport.util.AsynchronousInvocationHandler;
import org.hyperic.util.thread.LoggingThreadGroup;
import org.hyperic.util.thread.ThreadGroupFactory;

public class AsynchronousInvoker {
    private final ThreadPoolExecutor _executor;

    public AsynchronousInvoker(int poolSize) {
        if (poolSize <= 0) {
            throw new IllegalArgumentException("illegal pool size: " + poolSize);
        }
        LoggingThreadGroup threadGroup = new LoggingThreadGroup("Async Invoker Group");
        ThreadGroupFactory tFactory = new ThreadGroupFactory((ThreadGroup)threadGroup, "AsyncInvoker-");
        tFactory.createDaemonThreads(true);
        this._executor = new ThreadPoolExecutor(poolSize, poolSize, Long.MAX_VALUE, TimeUnit.NANOSECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)tFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    @PostConstruct
    public void start() {
        this._executor.prestartAllCoreThreads();
    }

    @PreDestroy
    public void stop() {
        this._executor.shutdown();
    }

    public void invoke(AsynchronousInvocationHandler handler) {
        if (handler.isInvocationGuaranteed()) {
            this._executor.execute(handler);
        } else {
            this._executor.execute(handler);
        }
    }
}

