/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.network;

import java.io.Serializable;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.detection.ServerInvokerMetadata;
import org.jboss.remoting.ident.Identity;

public class NetworkInstance
implements Serializable {
    static final long serialVersionUID = -1745108606611832280L;
    private final Identity identity;
    private final ServerInvokerMetadata[] serverInvokers;
    private final InvokerLocator[] locators;
    private final int hashCode;

    public NetworkInstance(Identity identity, InvokerLocator[] locators) {
        this.identity = identity;
        this.locators = locators;
        this.hashCode = this.identity.hashCode();
        this.serverInvokers = null;
    }

    public NetworkInstance(Identity identity, ServerInvokerMetadata[] serverInvokers) {
        this.identity = identity;
        this.locators = null;
        this.hashCode = this.identity.hashCode();
        this.serverInvokers = serverInvokers;
    }

    public final Identity getIdentity() {
        return this.identity;
    }

    public final InvokerLocator[] getLocators() {
        if (this.locators != null) {
            return this.locators;
        }
        InvokerLocator[] locators = new InvokerLocator[this.serverInvokers.length];
        for (int x = 0; x < this.serverInvokers.length; ++x) {
            locators[x] = this.serverInvokers[x].getInvokerLocator();
        }
        return locators;
    }

    public final ServerInvokerMetadata[] getServerInvokers() {
        return this.serverInvokers;
    }

    public String toString() {
        return "NetworkInstance [identity:" + this.identity + ",locator count:" + (this.serverInvokers == null ? 0 : this.serverInvokers.length) + "]";
    }

    public boolean equals(Object obj) {
        return this.hashCode == obj.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }
}

