/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.springsource.hyperic.plugin.gemfire;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MxUtil;
import org.hyperic.util.config.ConfigResponse;

public class AlertsPlugin
extends LogTrackPlugin
implements NotificationListener {
    Log log = this.getLog();
    Pattern msgPatt = Pattern.compile("\\[(\\w*) *(\\d{4}/\\d{2}/\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3} \\w*) *(\\w*) *([^\\]]*)] *(.*)");
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS z");

    public void configure(ConfigResponse config) throws PluginException {
        this.log.debug((Object)("[configure] config=" + config));
        super.configure(config);
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)config.toProperties());
            ObjectName obj = new ObjectName("GemFire:type=MemberInfoWithStatsMBean");
            mServer.addNotificationListener(obj, this, null, null);
            this.log.debug((Object)"[configure] listener OK");
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[handleNotification] notification.getType() => " + notification.getType()));
        }
        if ("gemfire.distributedsystem.alert".equals(notification.getType())) {
            Matcher m;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[handleNotification] notification.getMessage() => " + notification.getMessage().trim()));
            }
            if ((m = this.msgPatt.matcher(notification.getMessage().trim())).find()) {
                try {
                    String level = m.group(1);
                    Date date = this.dateFormat.parse(m.group(2));
                    String menberID = m.group(4);
                    String msg = m.group(5);
                    this.reportEvent(date.getTime(), 3, menberID, msg);
                }
                catch (Exception ex) {
                    this.log.debug((Object)("[handleNotification] BAD FORMAT!!!! " + ex.getMessage()), (Throwable)ex);
                }
            } else {
                this.log.debug((Object)"[handleNotification] BAD FORMAT!!!!");
            }
        }
    }
}

