/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.springsource.hyperic.plugin.gemfire.collectors;

import com.vmware.springsource.hyperic.plugin.gemfire.GemFireUtils;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.CollectorResult;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MxUtil;

public class RegionCollector
extends Collector {
    static Log log = LogFactory.getLog(RegionCollector.class);

    protected void init() throws PluginException {
        Properties props = this.getProperties();
        log.debug((Object)("[init] props=" + props));
        super.init();
    }

    public void collect() {
        Properties props = this.getProperties();
        log.debug((Object)("[collect] props=" + props));
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)props);
            String memberID = GemFireUtils.memberNameToMemberID(props.getProperty("member.name"), mServer);
            Map<String, Object> memberDetails = GemFireUtils.getMemberDetails(memberID, mServer);
            Map regions = (Map)memberDetails.get("gemfire.member.regions.map");
            for (Map region : regions.values()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[collect] region=" + region));
                }
                String name = (String)region.get("gemfire.region.name.string");
                this.setValue(name + "." + "Availability", 1.0);
                this.setValue(name + ".entry_count", ((Integer)region.get("gemfire.region.entrycount.int")).intValue());
            }
        }
        catch (Exception ex) {
            log.debug((Object)ex, (Throwable)ex);
        }
    }

    public MetricValue getValue(Metric metric, CollectorResult result) {
        MetricValue res = result.getMetricValue(metric.getAttributeName());
        if (metric.getAttributeName().endsWith("Availability")) {
            if (res.getValue() != 1.0) {
                res = new MetricValue(0.0, System.currentTimeMillis());
            }
            log.debug((Object)("[getValue] Member=" + metric.getObjectProperty("member.name") + " metric=" + metric.getAttributeName() + " res=" + res.getValue()));
        }
        return res;
    }
}

