/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.springsource.hyperic.plugin.gemfire.detectors;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.jmx.MxUtil;
import org.hyperic.util.config.ConfigResponse;

public class JMXAgentDetector
extends ServerDetector
implements AutoServerDetector {
    Log log = this.getLog();

    public List getServerResources(ConfigResponse pc) throws PluginException {
        this.log.debug((Object)("[getServerResources] pc=" + pc));
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)pc.toProperties());
            ObjectName mbean = new ObjectName("GemFire:type=MemberInfoWithStatsMBean");
            String version = (String)mServer.getAttribute(mbean, "Version");
            String id = (String)mServer.getAttribute(mbean, "Id");
            boolean versionOK = version.startsWith(this.getTypeInfo().getVersion());
            this.log.debug((Object)("Agent version='" + version + " " + (versionOK ? "OK" : "") + " (" + this.getTypeInfo().getVersion() + ")"));
            if (versionOK) {
                ServerResource server = this.createServerResource("");
                server.setName(this.getTypeInfo().getName() + " " + id);
                server.setIdentifier(id);
                this.setProductConfig(server, new ConfigResponse());
                this.setMeasurementConfig(server, pc);
                servers.add(server);
            }
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        return servers;
    }
}

