/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.sybase;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.sybase.SybaseProductPlugin;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.jdbc.DBUtil;

public class SybaseServerDetector
extends ServerDetector
implements AutoServerDetector {
    static final String JDBC_DRIVER = "com.sybase.jdbcx.SybDriver";
    static final String DEFAULT_URL = "jdbc:sybase:Tds:localhost:4100/master";
    static final String PROP_ENGINE = "engine";
    static final String PROP_PAGESIZE = "pagesize";
    static final String PROP_DATABASE = "database";
    static final String PROP_SEGMENT = "segment";
    static final String PROP_CACHE_NAME = "cachename";
    static final String PROP_CONFIG_OPTION = "configoption";
    static final String TYPE_SP_MONITOR_CONFIG = "sp_monitorconfig";
    static final String TYPE_SP_SYSMON = "sp_sysmon";
    static final String TYPE_STORAGE = "storage";
    static final String PROP_TABLE = "table";
    static final String PROP_URL = "jdbcUrl";
    static final String PROP_USER = "jdbcUser";
    static final String PROP_PASSWORD = "jdbcPassword";
    public static String PTQL_QUERY = SybaseServerDetector.isWin32() ? "State.Name.re=sqlsrvr,State.Name.Pne=$1,Args.0.re=.*sqlsrvr.exe$" : "State.Name.re=dataserver,State.Name.Pne=$1,Args.0.re=.*dataserver$";
    private static final String SP_MONITOR_CONFIG = "sp_monitorconfig 'all'";
    private static final String CACHE_QUERY = "select name from sysconfigures where lower(comment) = lower('User Defined Cache')";
    private static final String ENGINE_QUERY = "select engine from sysengines";
    static final String SERVER_NAME = "Sybase";
    static final String TABLE = "Table";
    static final String INDEX = "Index";
    static final String VERSION_15 = "15.x";
    static final String VERSION_12_5 = "12.5.x";
    static final String VERSION_12_0 = "12.x";
    private Log log = LogFactory.getLog(SybaseServerDetector.class);

    public List getServerResources(ConfigResponse config) throws PluginException {
        this.log.debug((Object)("[getServerResources] config=" + config));
        ArrayList servers = new ArrayList();
        long[] pids = SybaseServerDetector.getPids((String)PTQL_QUERY);
        for (int i = 0; i < pids.length; ++i) {
            List found = this.getServerList(pids[i], config);
            if (found.isEmpty()) continue;
            servers.addAll(found);
        }
        return servers;
    }

    public List getServerList(long pid, ConfigResponse config) throws PluginException {
        int i;
        String[] args = SybaseServerDetector.getProcArgs((long)pid);
        String path = args[0];
        this.log.debug((Object)("[getServerList] (" + pid + ") args=" + Arrays.asList(args)));
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        String name = null;
        String installpath = null;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-s")) {
                name = args[i + 1];
                continue;
            }
            if (!args[i].startsWith("-s")) continue;
            name = args[i].substring(2);
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-d")) continue;
            installpath = args[i].substring(2);
        }
        if (path.indexOf("dataserver") == -1 && path.indexOf("sqlsrvr") == -1 || name == null) {
            return servers;
        }
        if (installpath == null) {
            installpath = path + " -s" + name;
        }
        String installdir = SybaseServerDetector.getParentDir((String)path, (int)3);
        String version = "";
        if (path.indexOf("12_0") != -1) {
            version = VERSION_12_0;
        } else if (path.indexOf("12_5") != -1) {
            version = VERSION_12_5;
        } else if (path.indexOf("15_0") != -1) {
            version = VERSION_15;
        } else {
            return servers;
        }
        if (!version.equals(this.getTypeInfo().getVersion())) {
            return servers;
        }
        ConfigResponse measurementConfig = new ConfigResponse();
        measurementConfig.setValue("serverName", name);
        ServerResource server = this.createServerResource(installpath);
        ConfigResponse cprop = new ConfigResponse();
        cprop.setValue("version", version);
        server.setCustomProperties(cprop);
        this.setProductConfig(server, new ConfigResponse());
        this.setMeasurementConfig(server, measurementConfig);
        server.setName(SybaseServerDetector.getPlatformName() + " " + SERVER_NAME + " " + version + " " + name);
        servers.add(server);
        this.log.debug((Object)("sysbase.aiid.orginal=" + SybaseProductPlugin.isOriginalAIID()));
        this.log.debug((Object)("installdir=" + installdir));
        this.log.debug((Object)("installpath=" + installpath));
        if (SybaseProductPlugin.isOriginalAIID()) {
            server.setIdentifier(installdir);
        } else {
            server.setIdentifier(installpath);
        }
        return servers;
    }

    protected List discoverServices(ConfigResponse config) throws PluginException {
        this.log.debug((Object)("[discoverServices] config=" + config));
        ArrayList rtn = new ArrayList();
        String url = config.getValue(PROP_URL);
        String user = config.getValue(PROP_USER);
        String pass = config.getValue(PROP_PASSWORD);
        String name = config.getValue("serverName");
        if (url != null) {
            pass = pass == null ? "" : pass;
            pass = pass.matches("^\\s*$") ? "" : pass;
            try {
                Class.forName(JDBC_DRIVER);
            }
            catch (ClassNotFoundException e) {
                String msg = "Unable to load JDBC Driver: " + e.getMessage();
                throw new PluginException(msg);
            }
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                Properties props = new Properties();
                props.put("CHARSET_CONVERTER_CLASS", "com.sybase.jdbc3.utils.TruncationConverter");
                props.put("user", user);
                props.put("password", pass);
                conn = DriverManager.getConnection(url, props);
                stmt = conn.createStatement();
                this.setCacheServices(rtn, stmt);
                this.setSPMonitorConfigServices(rtn, stmt);
                this.setEngineServices(rtn, stmt);
                this.setSpaceAvailServices(rtn, stmt);
            }
            catch (SQLException e) {
                try {
                    String msg = "Error querying for services: " + e.getMessage();
                    throw new PluginException(msg, (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtil.closeJDBCObjects((Object)this.log, conn, stmt, rs);
                    throw throwable;
                }
            }
            DBUtil.closeJDBCObjects((Object)this.log, (Connection)conn, (Statement)stmt, rs);
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSpaceAvailServices(List services, Statement stmt) throws SQLException {
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery("select pagesize=@@maxpagesize");
            int pagesize = -1;
            if (!rs.next()) {
                throw new SQLException();
            }
            pagesize = rs.getInt(PROP_PAGESIZE);
            rs.close();
            List databases = this.getDatabases(stmt);
            for (int i = 0; i < databases.size(); ++i) {
                String database = (String)databases.get(i);
                try {
                    stmt.execute("use " + database);
                    stmt.execute("sp_helpsegment");
                    rs = stmt.getResultSet();
                    while (rs.next()) {
                        String segment = rs.getString("name");
                        ServiceResource service = new ServiceResource();
                        service.setType((GenericPlugin)this, TYPE_STORAGE);
                        service.setServiceName(database + "." + segment);
                        ConfigResponse productConfig = new ConfigResponse();
                        productConfig.setValue(PROP_DATABASE, database);
                        productConfig.setValue(PROP_SEGMENT, segment);
                        productConfig.setValue(PROP_PAGESIZE, pagesize);
                        service.setProductConfig(productConfig);
                        service.setMeasurementConfig();
                        services.add(service);
                    }
                    continue;
                }
                catch (SQLException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.error((Object)("[setSpaceAvailServices] database '" + database + "' > " + e.getMessage()), (Throwable)e);
                }
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.execute("use master");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getDatabases(Statement stmt) throws SQLException {
        ArrayList<String> rtn = new ArrayList<String>();
        ResultSet rs = null;
        try {
            stmt.execute("use master");
            rs = stmt.executeQuery("select name from sysdatabases");
            int name_col = rs.findColumn("name");
            while (rs.next()) {
                String database = rs.getString(name_col);
                rtn.add(database);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEngineServices(List services, Statement stmt) throws SQLException {
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(ENGINE_QUERY);
            int engine_col = rs.findColumn(PROP_ENGINE);
            while (rs != null && rs.next()) {
                String engineNum = rs.getString(engine_col).trim().replaceAll("\\s+", "_");
                ServiceResource service = new ServiceResource();
                service.setType((GenericPlugin)this, "sp_sysmonEngine");
                service.setServiceName(PROP_ENGINE + engineNum);
                ConfigResponse productConfig = new ConfigResponse();
                productConfig.setValue(PROP_ENGINE, PROP_ENGINE + engineNum);
                productConfig.setValue("id", engineNum);
                service.setProductConfig(productConfig);
                service.setMeasurementConfig();
                services.add(service);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCacheServices(List services, Statement stmt) throws SQLException {
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(CACHE_QUERY);
            int name_col = rs.findColumn("name");
            while (rs != null && rs.next()) {
                String cacheName = rs.getString(name_col).trim().replaceAll("\\s+", "_");
                ServiceResource service = new ServiceResource();
                service.setType((GenericPlugin)this, "sp_sysmonCache");
                service.setServiceName("Cachename=" + cacheName);
                ConfigResponse productConfig = new ConfigResponse();
                productConfig.setValue(PROP_CACHE_NAME, cacheName);
                service.setProductConfig(productConfig);
                service.setMeasurementConfig();
                services.add(service);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSPMonitorConfigServices(List services, Statement stmt) throws SQLException {
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(SP_MONITOR_CONFIG);
            while (rs != null && rs.next()) {
                String configOption = rs.getString("Name").trim();
                ServiceResource service = new ServiceResource();
                service.setType((GenericPlugin)this, TYPE_SP_MONITOR_CONFIG);
                service.setServiceName("ConfigOption=" + configOption);
                ConfigResponse productConfig = new ConfigResponse();
                productConfig.setValue(PROP_CONFIG_OPTION, configOption);
                service.setProductConfig(productConfig);
                service.setMeasurementConfig();
                services.add(service);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }
}

