/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.db2;

import java.util.Properties;
import org.hyperic.db2monitor.DB2Monitor;
import org.hyperic.db2monitor.DB2MonitorException;
import org.hyperic.db2monitor.SqlmDB2;
import org.hyperic.db2monitor.SqlmDbase;
import org.hyperic.db2monitor.SqlmTable;
import org.hyperic.db2monitor.SqlmTablespace;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;

public class DB2MeasurementPlugin
extends MeasurementPlugin {
    private static final String AVAIL_ATTR = "availability";
    private static long CACHE_TIMEOUT = 30000L;
    private DB2Monitor db2Monitor = null;
    private SqlmDB2 sqlmDB2 = null;
    private SqlmDbase[] sqlmDbase = null;
    private long lastUpdate = 0L;
    private static boolean loadedLibraries = false;

    public DB2MeasurementPlugin() {
        this.setName("db2");
    }

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        if (loadedLibraries) {
            return;
        }
        loadedLibraries = true;
        if (DB2MeasurementPlugin.isWin32()) {
            try {
                System.loadLibrary("DB2APP");
            }
            catch (UnsatisfiedLinkError le) {
                this.getLog().debug((Object)"DB2 client libraries not installed.  Skipping DB2 initialization");
                return;
            }
        }
        try {
            DB2Monitor.load();
        }
        catch (UnsatisfiedLinkError le) {
            this.getLog().debug((Object)("Unable to load db2Monitor: " + le.getMessage()));
            return;
        }
        catch (DB2MonitorException dB2MonitorException) {
            // empty catch block
        }
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        String dbase;
        String attr = metric.getAttributeName();
        Properties objProps = metric.getObjectProperties();
        Properties props = metric.getProperties();
        if (this.db2Monitor == null) {
            String nodename = props.getProperty("nodename");
            String user = props.getProperty("user", "");
            String password = props.getProperty("password", "");
            try {
                if (nodename != null) {
                    this.getLog().debug((Object)("Attaching to instance: " + nodename));
                    this.db2Monitor = new DB2Monitor(nodename, user, password);
                } else {
                    this.getLog().debug((Object)"Attaching to default local instance");
                    this.db2Monitor = new DB2Monitor();
                }
            }
            catch (DB2MonitorException e) {
                this.getLog().error((Object)("Error attaching to DB2 instance: " + e.getMessage()));
            }
            if (this.db2Monitor == null) {
                throw new MetricNotFoundException("DB2 Monitor not loaded");
            }
        }
        if (this.sqlmDB2 == null || this.sqlmDbase == null || System.currentTimeMillis() > this.lastUpdate + CACHE_TIMEOUT) {
            try {
                this.sqlmDB2 = this.db2Monitor.getSqlmDB2();
                this.sqlmDbase = this.db2Monitor.getSqlmDbase();
                this.lastUpdate = System.currentTimeMillis();
            }
            catch (UnsatisfiedLinkError e) {
                throw new MetricNotFoundException(e.getMessage());
            }
            catch (DB2MonitorException e) {
                throw new MetricUnreachableException(e.getMessage());
            }
        }
        String type = objProps.getProperty("type");
        Double val = null;
        if (type.equals("Database")) {
            dbase = objProps.getProperty("database");
            if (dbase == null) {
                dbase = props.getProperty("database", "");
            }
            for (int i = 0; i < this.sqlmDbase.length; ++i) {
                if (!dbase.equalsIgnoreCase(this.sqlmDbase[i].getName())) continue;
                if (attr.equals(AVAIL_ATTR)) {
                    return new MetricValue(1.0, System.currentTimeMillis());
                }
                val = (Double)this.sqlmDbase[i].get((Object)attr);
            }
        } else if (type.equals("Table")) {
            SqlmTable[] sqlmTable;
            String table;
            dbase = objProps.getProperty("database");
            if (dbase == null) {
                dbase = props.getProperty("database", "");
            }
            if ((table = objProps.getProperty("table")) == null) {
                table = props.getProperty("table", "");
            }
            try {
                sqlmTable = this.db2Monitor.getSqlmTable(dbase);
            }
            catch (UnsatisfiedLinkError e) {
                throw new MetricNotFoundException(e.getMessage());
            }
            catch (DB2MonitorException e) {
                throw new MetricUnreachableException(e.getMessage());
            }
            for (int i = 0; i < sqlmTable.length; ++i) {
                if (!table.equalsIgnoreCase(sqlmTable[i].getName())) continue;
                if (attr.equals(AVAIL_ATTR)) {
                    return new MetricValue(1.0, System.currentTimeMillis());
                }
                val = (Double)sqlmTable[i].get((Object)attr);
            }
        } else if (type.equals("Tablespace")) {
            SqlmTablespace[] sqlmTablespace;
            String table;
            dbase = objProps.getProperty("database");
            if (dbase == null) {
                dbase = props.getProperty("database", "");
            }
            if ((table = objProps.getProperty("tablespace")) == null) {
                table = props.getProperty("tablespace", "");
            }
            try {
                sqlmTablespace = this.db2Monitor.getSqlmTablespace(dbase);
            }
            catch (UnsatisfiedLinkError e) {
                throw new MetricNotFoundException(e.getMessage());
            }
            catch (DB2MonitorException e) {
                throw new MetricUnreachableException(e.getMessage());
            }
            for (int i = 0; i < sqlmTablespace.length; ++i) {
                if (!table.equalsIgnoreCase(sqlmTablespace[i].getName())) continue;
                if (attr.equals(AVAIL_ATTR)) {
                    return new MetricValue(1.0, System.currentTimeMillis());
                }
                val = (Double)sqlmTablespace[i].get((Object)attr);
            }
        } else {
            if (attr.equals(AVAIL_ATTR)) {
                return new MetricValue(1.0, System.currentTimeMillis());
            }
            val = (Double)this.sqlmDB2.get((Object)attr);
        }
        if (val == null) {
            throw new MetricNotFoundException(attr);
        }
        return new MetricValue((Number)val, System.currentTimeMillis());
    }
}

