/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.appha;

import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.PerfMetricId;
import com.vmware.vim25.PerfProviderSummary;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.PerformanceManager;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.appha.ObjectCache;
import org.hyperic.hq.plugin.appha.VSphereConnection;
import org.hyperic.hq.plugin.appha.VSphereUtil;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.collection.IntHashMap;

public abstract class VSphereCollector
extends Collector {
    private static final long CACHE_TIMEOUT = 60000L;
    private static final Log _log = LogFactory.getLog((String)VSphereCollector.class.getName());
    private static ObjectCache<IntHashMap> cached;
    private static final Object CACHE_LOCK;
    public static final String PROP_URL = "url";
    public static final String PROP_UUID = "uuid";
    protected Properties _props;
    private static final Integer PERF_INTERVAL_ID;

    protected abstract void collect(VSphereUtil var1) throws Exception;

    protected abstract String getType();

    protected abstract String getName();

    protected abstract String getUuid();

    protected void init() throws PluginException {
        this._props = this.getProperties();
        this.setSource(VSphereUtil.getURL(this._props));
    }

    protected String getHostname() {
        return this._props.getProperty("hostname");
    }

    protected String getCounterKey(PerfCounterInfo info) {
        String group = info.getGroupInfo().getKey();
        String name = info.getNameInfo().getKey();
        String rollup = info.getRollupType().toString();
        return group + "." + name + "." + rollup;
    }

    protected Integer getRefreshRate(PerformanceManager perfManager, ManagedEntity entity) throws Exception {
        PerfProviderSummary summary = perfManager.queryPerfProviderSummary(entity);
        return summary.getRefreshRate();
    }

    protected PerfMetricId[] getPerfMetricIds(PerformanceManager perfManager, ManagedEntity entity, Integer interval) throws Exception {
        return perfManager.queryAvailablePerfMetric(entity, null, null, interval);
    }

    protected PerfMetricId[] getPerfMetricIds(PerformanceManager perfManager, ManagedEntity entity) throws Exception {
        PerfMetricId[] ids = perfManager.queryAvailablePerfMetric(entity, null, null, PERF_INTERVAL_ID);
        return ids;
    }

    protected ManagedEntity getManagedEntity(VSphereUtil mo) throws Exception {
        String uuid = this.getUuid();
        String name = this.getName();
        String type = this.getType();
        if (uuid != null && name != null) {
            ManagedEntity entity = mo.findByUuid(type, uuid);
            if (entity == null) {
                entity = mo.find(type, name);
                return entity == null || !VSphereUtil.getUuid(entity).equals(uuid) ? null : entity;
            }
            return entity;
        }
        if (uuid == null) {
            return mo.find(type, name);
        }
        return mo.findByUuid(type, uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntHashMap getCounterCached() {
        Object object = CACHE_LOCK;
        synchronized (object) {
            return cached == null || cached.isExpired() ? null : cached.getEntity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IntHashMap getCounterInfo(PerformanceManager perfManager) throws Exception {
        IntHashMap info = this.getCounterCached();
        if (info != null) {
            return info;
        }
        PerfCounterInfo[] counters = perfManager.getPerfCounter();
        info = new IntHashMap(counters.length);
        for (int i = 0; i < counters.length; ++i) {
            info.put(counters[i].getKey(), (Object)counters[i]);
        }
        Object object = CACHE_LOCK;
        synchronized (object) {
            cached = new ObjectCache<IntHashMap>(info, 60000L);
        }
        return info;
    }

    public boolean isPoolable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect() {
        VSphereConnection conn = null;
        try {
            this.setAvailability(false);
            conn = VSphereConnection.getPooledInstance(this.getProperties());
            Object object = conn.LOCK;
            synchronized (object) {
                this.collect(conn.vim);
            }
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage(), e);
            _log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.release();
            }
        }
    }

    static {
        CACHE_LOCK = new Object();
        PERF_INTERVAL_ID = new Integer(300);
    }
}

