/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.appha;

import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.VirtualMachine;
import org.hyperic.hq.plugin.appha.VSphereHostCollector;

public class VSphereVmCollector
extends VSphereHostCollector {
    static final String TYPE = "VirtualMachine";
    static final String PROP_VM = "vm";

    protected String getName() {
        return this.getProperties().getProperty(PROP_VM);
    }

    protected String getType() {
        return TYPE;
    }

    protected void setAvailability(ManagedEntity entity) {
        if (entity == null) {
            this.setValue("Availability", 2.0);
            return;
        }
        VirtualMachine vm = (VirtualMachine)entity;
        VirtualMachineRuntimeInfo runtime = vm.getRuntime();
        if (runtime == null) {
            this.setValue("Availability", 2.0);
            return;
        }
        VirtualMachinePowerState state = runtime.getPowerState();
        double avail = state == VirtualMachinePowerState.poweredOn ? 1.0 : (state == VirtualMachinePowerState.poweredOff ? -0.02 : (state == VirtualMachinePowerState.suspended ? -0.01 : 2.0));
        this.setValue("Availability", avail);
    }
}

