/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.rabbitmq.collect;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.rabbitmq.collect.RabbitMQDefaultCollector;
import org.hyperic.hq.plugin.rabbitmq.core.HypericRabbitAdmin;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitVirtualHost;
import org.hyperic.hq.product.PluginException;

public class VirtualHostCollector
extends RabbitMQDefaultCollector {
    private static final Log logger = LogFactory.getLog(VirtualHostCollector.class);

    public void collect(HypericRabbitAdmin rabbitAdmin) {
        Properties props = this.getProperties();
        String vhost = (String)props.get("vhost");
        String node = (String)props.get("node");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[collect] vhost=" + vhost + " node=" + node));
        }
        try {
            HypericRabbitAdmin admin = new HypericRabbitAdmin(props);
            admin.getVirtualHost(vhost);
            this.setAvailability(true);
        }
        catch (PluginException ex) {
            this.setAvailability(false);
            logger.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        try {
            RabbitVirtualHost virtualHost = rabbitAdmin.getVirtualHost(vhost);
            this.setAvailability(true);
            this.setValue("queueCount", rabbitAdmin.getQueues(virtualHost).size());
            this.setValue("exchangeCount", rabbitAdmin.getQueues(virtualHost).size());
        }
        catch (Exception ex) {
            this.setAvailability(false);
            logger.debug((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public Log getLog() {
        return logger;
    }
}

