/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.rabbitmq.core;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.LogFileTailPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.sigar.FileInfo;
import org.hyperic.util.config.ConfigResponse;

public class RabbitBrokerLog
extends LogFileTailPlugin {
    private static final Log log = LogFactory.getLog(RabbitBrokerLog.class);
    private static final List<String> levels = Arrays.asList("ERROR", "WARN", "INFO", "DEBUG");
    private static final Pattern levelPat = Pattern.compile("=+(\\w*)[^=]*=+");
    private static final int DEFAULT_LOG_LEVEL = 3;
    private static int level = 3;

    public void configure(ConfigResponse config) throws PluginException {
        log.debug((Object)("[configure] config=" + config));
        String[] files = this.getFiles(config);
        log.debug((Object)("[configure] Adding file watchers for files=" + Arrays.asList(files)));
        super.configure(config);
    }

    public TrackEvent processLine(FileInfo info, String line) {
        TrackEvent trackEvent = null;
        log.debug((Object)("[processLine] line=" + line));
        Matcher matcher = levelPat.matcher(line);
        if (matcher.find()) {
            level = levels.indexOf(matcher.group(1));
            if (log.isDebugEnabled()) {
                log.debug((Object)("[processLine] level=" + matcher.group(1) + " (" + level + ")"));
            }
        } else if (line.length() > 1) {
            trackEvent = this.newTrackEvent(System.currentTimeMillis(), 3 + level, info.getName(), line);
        }
        return trackEvent;
    }
}

