/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.rabbitmq.manage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.bizapp.agent.client.HQApiCommandsClient;
import org.hyperic.hq.bizapp.agent.client.HQApiFactory;
import org.hyperic.hq.hqapi1.HQApi;
import org.hyperic.hq.hqapi1.types.Resource;
import org.hyperic.hq.hqapi1.types.ResourceConfig;
import org.hyperic.hq.hqapi1.types.ResourcePrototype;
import org.hyperic.hq.plugin.rabbitmq.manage.TransientResourceManager;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServiceResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RabbitTransientResourceManager
implements TransientResourceManager {
    private static final Log logger = LogFactory.getLog(RabbitTransientResourceManager.class);
    private static final String RABBITMQ_TYPE = "RabbitMQ";
    private HQApiCommandsClient commandsClient;
    private Properties props;

    public RabbitTransientResourceManager(Properties props) throws PluginException {
        this.props = props;
        HQApi api = HQApiFactory.getHQApi((AgentDaemon)AgentDaemon.getMainInstance(), (Properties)props);
        this.commandsClient = new HQApiCommandsClient(api);
    }

    @Override
    public void syncServices(List<ServiceResource> rabbitResources) throws Exception {
        if (rabbitResources == null) {
            return;
        }
        int numResourcesDeleted = 0;
        try {
            Resource rabbitMQ = this.getRabbitMQServer();
            if (rabbitMQ == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Could not find a RabbitMQ server");
                }
                return;
            }
            ArrayList<String> resources = new ArrayList<String>();
            for (ServiceResource s : rabbitResources) {
                logger.info((Object)(s.getType() + s.getName()));
                resources.add(s.getType() + s.getName());
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("HQ RabbitMQ service={type=" + s.getName() + ", name=" + s.getName() + "}"));
            }
            Collections.sort(resources);
            for (Resource service : rabbitMQ.getResource()) {
                String sname = service.getResourcePrototype().getName() + service.getName();
                if (Collections.binarySearch(resources, sname) >= 0) continue;
                this.commandsClient.deleteResource(service);
                logger.debug((Object)("HQ RabbitMQ service deleted={type=" + service.getResourcePrototype().getName() + ", name=" + service.getName() + "}"));
                ++numResourcesDeleted;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (numResourcesDeleted > 0) {
                logger.info((Object)(numResourcesDeleted + " transient RabbitMQ services deleted"));
            }
        }
    }

    private Resource getRabbitMQServer() throws IOException, PluginException {
        Resource rabbit = null;
        ResourcePrototype rezProto = this.commandsClient.getResourcePrototype(RABBITMQ_TYPE);
        List resources = this.commandsClient.getResources(rezProto, true, true);
        for (Resource r : resources) {
            logger.debug((Object)r.getName());
            if (!this.isResourceConfigMatch(r.getResourceConfig(), this.props)) continue;
            rabbit = r;
            break;
        }
        return rabbit;
    }

    private boolean isResourceConfigMatch(List<ResourceConfig> configs, Properties props) {
        boolean portMatches = false;
        boolean addrMatches = false;
        for (ResourceConfig c : configs) {
            if ("port".equals(c.getKey())) {
                if (!c.getValue().equals(props.get("port"))) continue;
                portMatches = true;
                continue;
            }
            if (!"addr".equals(c.getKey()) || !c.getValue().equals(props.get("addr"))) continue;
            addrMatches = true;
        }
        return portMatches && addrMatches;
    }
}

