/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.DetachedHeadException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.api.errors.InvalidMergeHeadsException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.OperationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PullCommand
extends GitCommand<PullResult> {
    private int timeout = 0;
    private static final String DOT = ".";
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private CredentialsProvider credentialsProvider;

    protected PullCommand(Repository repo) {
        super(repo);
    }

    public PullCommand setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public PullCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public PullCommand setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.checkCallable();
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    @Override
    public PullResult call() throws WrongRepositoryStateException, InvalidConfigurationException, DetachedHeadException, InvalidRemoteException, CanceledException, RefNotFoundException {
        PullResult result;
        ObjectId commitToMerge;
        OperationResult fetchRes;
        String remoteUri;
        boolean isRemote;
        String branchName;
        this.checkCallable();
        this.monitor.beginTask(JGitText.get().pullTaskName, 2);
        try {
            String fullBranch = this.repo.getFullBranch();
            if (!fullBranch.startsWith("refs/heads/")) {
                throw new DetachedHeadException();
            }
            branchName = fullBranch.substring("refs/heads/".length());
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPullCommand, e);
        }
        if (!this.repo.getRepositoryState().equals((Object)RepositoryState.SAFE)) {
            throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().cannotPullOnARepoWithState, this.repo.getRepositoryState().name()));
        }
        StoredConfig repoConfig = this.repo.getConfig();
        String remote = repoConfig.getString("branch", branchName, "remote");
        if (remote == null) {
            remote = "origin";
        }
        String remoteBranchName = repoConfig.getString("branch", branchName, "merge");
        boolean doRebase = repoConfig.getBoolean("branch", branchName, "rebase", false);
        if (remoteBranchName == null) {
            String missingKey = "branch." + branchName + DOT + "merge";
            throw new InvalidConfigurationException(MessageFormat.format(JGitText.get().missingConfigurationForKey, missingKey));
        }
        boolean bl = isRemote = !remote.equals(DOT);
        if (isRemote) {
            remoteUri = repoConfig.getString("remote", remote, "url");
            if (remoteUri == null) {
                String missingKey = "remote." + remote + DOT + "url";
                throw new InvalidConfigurationException(MessageFormat.format(JGitText.get().missingConfigurationForKey, missingKey));
            }
            if (this.monitor.isCancelled()) {
                throw new CanceledException(MessageFormat.format(JGitText.get().operationCanceled, JGitText.get().pullTaskName));
            }
            FetchCommand fetch = new FetchCommand(this.repo);
            fetch.setRemote(remote);
            fetch.setProgressMonitor(this.monitor);
            fetch.setTimeout(this.timeout);
            fetch.setCredentialsProvider(this.credentialsProvider);
            fetchRes = fetch.call();
        } else {
            remoteUri = "local repository";
            fetchRes = null;
        }
        this.monitor.update(1);
        if (this.monitor.isCancelled()) {
            throw new CanceledException(MessageFormat.format(JGitText.get().operationCanceled, JGitText.get().pullTaskName));
        }
        if (isRemote) {
            Ref r = null;
            if (fetchRes != null && (r = fetchRes.getAdvertisedRef(remoteBranchName)) == null) {
                r = fetchRes.getAdvertisedRef("refs/heads/" + remoteBranchName);
            }
            if (r == null) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().couldNotGetAdvertisedRef, remoteBranchName));
            }
            commitToMerge = r.getObjectId();
        } else {
            try {
                commitToMerge = this.repo.resolve(remoteBranchName);
                if (commitToMerge == null) {
                    throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, remoteBranchName));
                }
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPullCommand, e);
            }
        }
        if (doRebase) {
            RebaseCommand rebase = new RebaseCommand(this.repo);
            try {
                RebaseResult rebaseRes = rebase.setUpstream(commitToMerge).setProgressMonitor(this.monitor).setOperation(RebaseCommand.Operation.BEGIN).call();
                result = new PullResult((FetchResult)fetchRes, remote, rebaseRes);
            }
            catch (NoHeadException e) {
                throw new JGitInternalException(e.getMessage(), e);
            }
            catch (RefNotFoundException e) {
                throw new JGitInternalException(e.getMessage(), e);
            }
            catch (JGitInternalException e) {
                throw new JGitInternalException(e.getMessage(), e);
            }
            catch (GitAPIException e) {
                throw new JGitInternalException(e.getMessage(), e);
            }
        }
        MergeCommand merge = new MergeCommand(this.repo);
        String name = "branch '" + Repository.shortenRefName(remoteBranchName) + "' of " + remoteUri;
        merge.include(name, commitToMerge);
        try {
            MergeResult mergeRes = merge.call();
            this.monitor.update(1);
            result = new PullResult((FetchResult)fetchRes, remote, mergeRes);
        }
        catch (NoHeadException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConcurrentRefUpdateException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (CheckoutConflictException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (InvalidMergeHeadsException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (WrongRepositoryStateException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (NoMessageException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        this.monitor.endTask();
        return result;
    }
}

