/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl2java;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.impl.s2j.SchemaCompilerImpl;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jvnet.ws.wadl.Application;
import org.jvnet.ws.wadl.Grammars;
import org.jvnet.ws.wadl.Include;
import org.jvnet.ws.wadl.Method;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl.Representation;
import org.jvnet.ws.wadl.Request;
import org.jvnet.ws.wadl.Resource;
import org.jvnet.ws.wadl.ResourceType;
import org.jvnet.ws.wadl.Resources;
import org.jvnet.ws.wadl.Response;
import org.jvnet.ws.wadl2java.ElementResolver;
import org.jvnet.ws.wadl2java.JavaDocUtil;
import org.jvnet.ws.wadl2java.ResourceClassGenerator;
import org.jvnet.ws.wadl2java.Wadl2JavaMessages;
import org.jvnet.ws.wadl2java.ast.FaultNode;
import org.jvnet.ws.wadl2java.ast.MethodNode;
import org.jvnet.ws.wadl2java.ast.RepresentationNode;
import org.jvnet.ws.wadl2java.ast.ResourceNode;
import org.jvnet.ws.wadl2java.ast.ResourceTypeNode;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wadl2Java {
    private File outputDir;
    private List<File> customizations;
    private String pkg;
    private JPackage jPkg;
    private S2JJAXBModel s2jModel;
    private JCodeModel codeModel;
    private ElementResolver idMap;
    private Map<String, ResourceTypeNode> ifaceMap;
    private List<String> processedDocs;
    private JavaDocUtil javaDoc;
    private Unmarshaller u;
    private SchemaCompiler s2j;
    private ErrorListener errorListener;
    private String generatedPackages = "";
    private boolean autoPackage;

    public Wadl2Java(File outputDir, String pkg, boolean autoPackage) {
        this.outputDir = outputDir;
        this.pkg = pkg;
        this.javaDoc = new JavaDocUtil();
        this.processedDocs = new ArrayList<String>();
        this.customizations = new ArrayList<File>();
        this.autoPackage = autoPackage;
    }

    public Wadl2Java(File outputDir, String pkg, boolean autoPackage, List<File> customizations) {
        this.outputDir = outputDir;
        this.pkg = pkg;
        this.javaDoc = new JavaDocUtil();
        this.processedDocs = new ArrayList<String>();
        this.customizations = customizations;
        this.autoPackage = autoPackage;
    }

    public void process(URI rootDesc) throws JAXBException, IOException, JClassAlreadyExistsException {
        JAXBContext jbc = JAXBContext.newInstance((String)"org.jvnet.ws.wadl", (ClassLoader)this.getClass().getClassLoader());
        this.u = jbc.createUnmarshaller();
        this.s2j = new SchemaCompilerImpl();
        this.errorListener = new SchemaCompilerErrorListener();
        if (!this.autoPackage) {
            this.s2j.setDefaultPackageName(this.pkg);
        }
        this.s2j.setErrorListener(this.errorListener);
        this.idMap = new ElementResolver();
        this.ifaceMap = new HashMap<String, ResourceTypeNode>();
        Application a = this.processDescription(rootDesc);
        List<ResourceNode> rs = this.buildAst(a, rootDesc);
        this.s2jModel = this.s2j.bind();
        if (this.s2jModel != null) {
            this.codeModel = this.s2jModel.generateCode(null, this.errorListener);
            Iterator packages = this.codeModel.packages();
            StringBuilder buf = new StringBuilder();
            while (packages.hasNext()) {
                JPackage genPkg = (JPackage)packages.next();
                if (!genPkg.isDefined("ObjectFactory")) continue;
                if (buf.length() > 0) {
                    buf.append(':');
                }
                buf.append(genPkg.name());
            }
            this.generatedPackages = buf.toString();
            this.jPkg = this.codeModel._package(this.pkg);
            this.generateResourceTypeInterfaces();
            for (ResourceNode r : rs) {
                this.generateEndpointClass(r);
            }
            this.codeModel.build(this.outputDir);
        }
    }

    public Application processDescription(URI desc) throws JAXBException, IOException {
        InputSource input;
        URI incl;
        if (this.processedDocs.contains(desc.toString())) {
            return null;
        }
        this.processedDocs.add(desc.toString());
        System.out.println(Wadl2JavaMessages.PROCESSING(desc.toString()));
        Application a = (Application)this.u.unmarshal(desc.toURL());
        Grammars g = a.getGrammars();
        if (g != null) {
            for (Include i : g.getInclude()) {
                incl = desc.resolve(i.getHref());
                if (this.processedDocs.contains(incl.toString())) continue;
                this.processedDocs.add(incl.toString());
                System.out.println(Wadl2JavaMessages.PROCESSING(incl.toString()));
                input = new InputSource(incl.toURL().openStream());
                input.setSystemId(incl.toString());
                this.s2j.parseSchema(input);
            }
            int embeddedSchemaNo = 0;
            for (Object any : g.getAny()) {
                if (!(any instanceof Element)) continue;
                Element element = (Element)any;
                this.s2j.parseSchema(desc.toString() + "#schema" + Integer.toString(embeddedSchemaNo), element);
                ++embeddedSchemaNo;
            }
        }
        for (File customization : this.customizations) {
            incl = desc.resolve(customization.toURI());
            System.out.println(Wadl2JavaMessages.PROCESSING(incl.toString()));
            input = new InputSource(incl.toURL().openStream());
            input.setSystemId(incl.toString());
            this.s2j.parseSchema(input);
        }
        this.buildIDMap(a, desc);
        return a;
    }

    protected void buildIDMap(Application a, URI desc) throws JAXBException, IOException {
        for (Object child : a.getResourceTypeOrMethodOrRepresentation()) {
            if (child instanceof Method) {
                this.extractMethodIds((Method)child, desc);
                continue;
            }
            if (child instanceof ResourceType) {
                this.extractResourceTypeIds((ResourceType)child, desc);
                continue;
            }
            if (child instanceof Representation) {
                this.extractRepresentationId((Representation)child, desc);
                continue;
            }
            this.extractParamId((Param)child, desc);
        }
        if (a.getResources() != null) {
            for (Resources rs : a.getResources()) {
                for (Resource r : rs.getResource()) {
                    this.extractResourceIds(r, desc);
                }
            }
        }
    }

    protected String processIDHref(URI desc, String id, String href, Object o) throws JAXBException, IOException {
        String uniqueId = this.idMap.addReference(desc, id, o);
        if (href != null && !href.startsWith("#")) {
            this.processDescription(Wadl2Java.getReferencedFile(desc, href));
        }
        return uniqueId;
    }

    protected void extractRepresentationId(Representation r, URI file) throws JAXBException, IOException {
        this.processIDHref(file, r.getId(), r.getHref(), r);
        for (Param p : r.getParam()) {
            this.extractParamId(p, file);
        }
    }

    protected void extractParamId(Param p, URI file) throws JAXBException, IOException {
        this.processIDHref(file, p.getId(), p.getHref(), p);
    }

    protected void extractMethodIds(Method m, URI file) throws JAXBException, IOException {
        this.processIDHref(file, m.getId(), m.getHref(), m);
        if (m.getRequest() != null) {
            for (Param p : m.getRequest().getParam()) {
                this.extractParamId(p, file);
            }
            for (Representation r : m.getRequest().getRepresentation()) {
                this.extractRepresentationId(r, file);
            }
        }
        for (Response resp : m.getResponse()) {
            for (Param p : resp.getParam()) {
                this.extractParamId(p, file);
            }
            for (Representation r : resp.getRepresentation()) {
                this.extractRepresentationId(r, file);
            }
        }
    }

    protected void extractResourceIds(Resource r, URI file) throws JAXBException, IOException {
        this.processIDHref(file, r.getId(), null, r);
        for (String type : r.getType()) {
            this.processIDHref(file, null, type, r);
        }
        for (Param p : r.getParam()) {
            this.extractParamId(p, file);
        }
        for (Object child : r.getMethodOrResource()) {
            if (child instanceof Method) {
                this.extractMethodIds((Method)child, file);
                continue;
            }
            if (!(child instanceof Resource)) continue;
            this.extractResourceIds((Resource)child, file);
        }
    }

    protected void extractResourceTypeIds(ResourceType r, URI file) throws JAXBException, IOException {
        String id = this.processIDHref(file, r.getId(), null, r);
        if (id != null) {
            this.ifaceMap.put(id, null);
        }
        for (Param p : r.getParam()) {
            this.extractParamId(p, file);
        }
        for (Object child : r.getMethodOrResource()) {
            if (child instanceof Method) {
                this.extractMethodIds((Method)child, file);
                continue;
            }
            if (!(child instanceof Resource)) continue;
            this.extractResourceIds((Resource)child, file);
        }
    }

    protected void generateResourceTypeInterfaces() throws JClassAlreadyExistsException {
        for (String id : this.ifaceMap.keySet()) {
            ResourceTypeNode n = this.ifaceMap.get(id);
            JDefinedClass iface = this.jPkg._class(1, n.getClassName(), ClassType.INTERFACE);
            n.setGeneratedInterface(iface);
            this.javaDoc.generateClassDoc(n, iface);
            ResourceClassGenerator rcGen = new ResourceClassGenerator(this.s2jModel, this.codeModel, this.jPkg, this.generatedPackages, this.javaDoc, iface);
            for (MethodNode m : n.getMethods()) {
                rcGen.generateMethodDecls(m, true);
            }
            for (Param p : n.getMatrixParams()) {
                rcGen.generateBeanProperty(iface, p, true);
            }
        }
    }

    protected void generateEndpointClass(ResourceNode root) throws JClassAlreadyExistsException {
        JDefinedClass impl = this.jPkg._class(1, root.getClassName());
        this.javaDoc.generateClassDoc(root, impl);
        for (ResourceNode r : root.getChildResources()) {
            this.generateSubClass(impl, r);
        }
    }

    protected void generateSubClass(JDefinedClass parent, ResourceNode resource) throws JClassAlreadyExistsException {
        ResourceClassGenerator rcGen = new ResourceClassGenerator(this.s2jModel, this.codeModel, this.jPkg, this.generatedPackages, this.javaDoc, resource);
        JDefinedClass impl = rcGen.generateClass(parent);
        for (MethodNode m : resource.getMethods()) {
            rcGen.generateMethodDecls(m, false);
        }
        for (ResourceNode r : resource.getChildResources()) {
            this.generateSubClass(impl, r);
        }
    }

    protected List<ResourceNode> buildAst(Application a, URI rootFile) {
        for (String ifaceId : this.ifaceMap.keySet()) {
            this.buildResourceType(ifaceId, a);
        }
        for (String ifaceId : this.ifaceMap.keySet()) {
            this.buildResourceTypeTree(ifaceId, a);
        }
        List<Resources> rs = a.getResources();
        ArrayList<ResourceNode> ns = new ArrayList<ResourceNode>();
        for (Resources r : rs) {
            ResourceNode rootResourcesNode = new ResourceNode(a, r);
            for (Resource child : r.getResource()) {
                this.buildResourceTree(rootResourcesNode, child, rootFile);
            }
            ns.add(rootResourcesNode);
        }
        return ns;
    }

    protected void buildResourceType(String ifaceId, Application a) {
        try {
            URI file = new URI(ifaceId.substring(0, ifaceId.indexOf(35)));
            ResourceType type = (ResourceType)this.idMap.get(ifaceId);
            ResourceTypeNode node = new ResourceTypeNode(type, file, this.idMap);
            for (Object child : type.getMethodOrResource()) {
                if (!(child instanceof Method)) continue;
                this.addMethodToResourceType(node, (Method)child, file);
            }
            this.ifaceMap.put(ifaceId, node);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
    }

    protected void buildResourceTypeTree(String ifaceId, Application a) {
        try {
            URI file = new URI(ifaceId.substring(0, ifaceId.indexOf(35)));
            ResourceType type = (ResourceType)this.idMap.get(ifaceId);
            ResourceTypeNode node = this.ifaceMap.get(ifaceId);
            for (Object child : type.getMethodOrResource()) {
                if (!(child instanceof Resource)) continue;
                this.addResourceToResourceType(node, (Resource)child, file);
            }
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
    }

    protected void buildResourceTree(ResourceNode parent, Resource resource, URI file) {
        if (resource != null) {
            ResourceNode n = parent.addChild(resource, file, this.idMap);
            for (String type : resource.getType()) {
                this.addTypeToResource(n, type, file);
            }
            for (Object child : resource.getMethodOrResource()) {
                if (child instanceof Resource) {
                    Resource childResource = (Resource)child;
                    this.buildResourceTree(n, childResource, file);
                    continue;
                }
                if (!(child instanceof Method)) continue;
                Method m = (Method)child;
                this.addMethodToResource(n, m, file);
            }
        }
    }

    protected void addTypeToResource(ResourceNode resource, String href, URI file) {
        ResourceTypeNode n = this.ifaceMap.get((file = Wadl2Java.getReferencedFile(file, href)).toString() + href.substring(href.indexOf(35)));
        if (n != null) {
            resource.addResourceType(n);
        } else {
            System.err.println(Wadl2JavaMessages.SKIPPING_REFERENCE(href, file.toString()));
        }
    }

    protected void addMethodToResourceType(ResourceTypeNode resource, Method method, URI file) {
        String href = method.getHref();
        if (href != null && href.length() > 0) {
            file = Wadl2Java.getReferencedFile(file, href);
            method = this.idMap.resolve(file, href, Method.class);
        }
        if (method != null) {
            MethodNode n = new MethodNode(method, resource);
            Request request = method.getRequest();
            if (request != null) {
                for (Param p : request.getParam()) {
                    href = p.getHref();
                    if (href != null && href.length() > 0) {
                        file = Wadl2Java.getReferencedFile(file, href);
                        p = this.idMap.resolve(file, href, Param.class);
                    }
                    if (p == null) continue;
                    n.getQueryParameters().add(p);
                }
                for (Representation r : request.getRepresentation()) {
                    this.addRepresentation(n.getSupportedInputs(), r, file);
                }
            }
            for (Response response : method.getResponse()) {
                boolean isFault = this.isFaultResponse(response);
                for (Representation o : response.getRepresentation()) {
                    if (isFault) {
                        FaultNode fn = new FaultNode(o);
                        n.getFaults().add(fn);
                        continue;
                    }
                    this.addRepresentation(n.getSupportedOutputs(), o, file);
                }
            }
        }
    }

    protected void addResourceToResourceType(ResourceTypeNode type, Resource resource, URI file) {
        if (resource != null) {
            ResourceNode n = type.addChild(resource, file, this.idMap);
            for (String resourceType : resource.getType()) {
                this.addTypeToResource(n, resourceType, file);
            }
            for (Object child : resource.getMethodOrResource()) {
                if (child instanceof Resource) {
                    Resource childResource = (Resource)child;
                    this.buildResourceTree(n, childResource, file);
                    continue;
                }
                if (!(child instanceof Method)) continue;
                Method m = (Method)child;
                this.addMethodToResource(n, m, file);
            }
        }
    }

    boolean isFaultResponse(Response response) {
        boolean isFault = false;
        for (long status : response.getStatus()) {
            if (status < 400L) continue;
            isFault = true;
            break;
        }
        return isFault;
    }

    protected void addMethodToResource(ResourceNode resource, Method method, URI file) {
        String href = method.getHref();
        if (href != null && href.length() > 0) {
            file = Wadl2Java.getReferencedFile(file, href);
            method = this.idMap.resolve(file, href, Method.class);
        }
        if (method != null) {
            MethodNode n = new MethodNode(method, resource);
            Request request = method.getRequest();
            if (request != null) {
                for (Param p : request.getParam()) {
                    href = p.getHref();
                    if (href != null && href.length() > 0) {
                        file = Wadl2Java.getReferencedFile(file, href);
                        p = this.idMap.resolve(file, href, Param.class);
                    }
                    if (p == null) continue;
                    n.getQueryParameters().add(p);
                }
                for (Representation r : request.getRepresentation()) {
                    this.addRepresentation(n.getSupportedInputs(), r, file);
                }
            }
            for (Response response : method.getResponse()) {
                boolean isFault = this.isFaultResponse(response);
                for (Representation o : response.getRepresentation()) {
                    if (isFault) {
                        FaultNode fn = new FaultNode(o);
                        n.getFaults().add(fn);
                        continue;
                    }
                    this.addRepresentation(n.getSupportedOutputs(), o, file);
                }
            }
        }
    }

    protected void addRepresentation(List<RepresentationNode> list, Representation representation, URI file) {
        String href = representation.getHref();
        if (href != null && href.length() > 0) {
            file = Wadl2Java.getReferencedFile(file, href);
            representation = this.idMap.resolve(file, href, Representation.class);
        }
        if (representation != null) {
            RepresentationNode n = new RepresentationNode(representation);
            list.add(n);
        }
    }

    protected static URI getReferencedFile(URI currentFile, String href) {
        if (href.startsWith("#")) {
            return currentFile;
        }
        URI ref = currentFile.resolve(href.substring(0, href.indexOf(35)));
        return ref;
    }

    protected class SchemaCompilerErrorListener
    implements ErrorListener {
        protected SchemaCompilerErrorListener() {
        }

        public void warning(SAXParseException sAXParseException) {
            System.err.println(Wadl2JavaMessages.WARNING(sAXParseException.getMessage()));
        }

        public void info(SAXParseException sAXParseException) {
            System.err.println(Wadl2JavaMessages.INFO(sAXParseException.getMessage()));
        }

        public void fatalError(SAXParseException sAXParseException) {
            System.err.println(Wadl2JavaMessages.ERROR_FATAL(sAXParseException.getMessage()));
        }

        public void error(SAXParseException sAXParseException) {
            System.err.println(Wadl2JavaMessages.ERROR(sAXParseException.getMessage()));
        }
    }
}

