/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.xen;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Host;
import java.util.Properties;
import java.util.StringTokenizer;
import org.hyperic.hq.product.PluginException;

public class XenUtil {
    static final String PROP_URL = "url";
    static final String PROP_USERNAME = "user";
    static final String PROP_PASSWORD = "pass";
    static final String[] CONNECT_PROPS = new String[]{"url", "user", "pass"};
    static final String PROP_PLATFORM_UUID = "platform.uuid";
    static final String PROP_SERVER_UUID = "server.uuid";
    static final String PROP_SERVICE_UUID = "service.uuid";
    static final String PROP_LOCATION = "location";
    static final String PROP_DEVICE = "device";
    static final String PROP_TYPE = "type";
    static final String PROP_MAC = "mac";
    static final String PROP_MTU = "mtu";
    static final String PROP_IP = "address";
    static final String PROP_NETMASK = "netmask";
    static final String PROP_GATEWAY = "gateway";
    static final String PROP_DNS = "dns";
    static final String TYPE_STORAGE = "Storage";
    static final String TYPE_NIC = "NIC";
    static final String TYPE_CPU = "CPU";

    static String getProperty(Properties props, String key) throws PluginException {
        String val = props.getProperty(key);
        if (val == null) {
            throw new PluginException("Missing property '" + key + "'");
        }
        return val;
    }

    static Connection connect(Properties props) throws PluginException {
        String url = XenUtil.getProperty(props, PROP_URL);
        String username = XenUtil.getProperty(props, PROP_USERNAME);
        String password = XenUtil.getProperty(props, PROP_PASSWORD);
        try {
            return new Connection(url, username, password);
        }
        catch (Exception e) {
            throw new PluginException("Connection error: " + e, (Throwable)e);
        }
    }

    static Host getHost(Connection conn, Properties props) throws PluginException {
        return XenUtil.getHost(conn, XenUtil.getProperty(props, PROP_PLATFORM_UUID));
    }

    static boolean isUUID(String uuid) {
        return uuid.length() == 36 && new StringTokenizer(uuid, "-").countTokens() == 5;
    }

    static Host getHost(Connection conn, String uuid) throws PluginException {
        if (XenUtil.isUUID(uuid)) {
            try {
                return Host.getByUuid(conn, uuid);
            }
            catch (Exception e) {
                throw new PluginException("Host.getByUuid(" + uuid + "): " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            return Host.getByNameLabel(conn, uuid).iterator().next();
        }
        catch (Exception e) {
            throw new PluginException("Host.getByNameLabel(" + uuid + "): " + e.getMessage(), (Throwable)e);
        }
    }
}

