/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.xen;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.VM;
import java.util.Properties;
import org.hyperic.hq.plugin.xen.XenUtil;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

public class XenVmControlPlugin
extends ControlPlugin {
    private String _uuid;
    private Properties _props;

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        this._props = config.toProperties();
        this._uuid = this._props.getProperty("server.uuid");
    }

    private VM getVM(Connection conn) throws Exception {
        return VM.getByUuid(conn, this._uuid);
    }

    private Connection connect() throws PluginException {
        return XenUtil.connect(this._props);
    }

    public void doAction(String action, String[] args) throws PluginException {
        if (action.equals("shutdown")) {
            action = "stop";
        }
        super.doAction(action, args);
    }

    public void start() throws PluginException {
        Connection conn = this.connect();
        try {
            VM vm = this.getVM(conn);
            vm.start(conn, false, false);
        }
        catch (Exception e) {
            throw new PluginException(e.toString(), (Throwable)e);
        }
    }

    public void stop() throws PluginException {
        Connection conn = this.connect();
        try {
            VM vm = this.getVM(conn);
            vm.cleanShutdown(conn);
        }
        catch (Exception e) {
            throw new PluginException(e.toString(), (Throwable)e);
        }
    }

    public void forceShutdown() throws PluginException {
        Connection conn = this.connect();
        try {
            VM vm = this.getVM(conn);
            vm.hardShutdown(conn);
        }
        catch (Exception e) {
            throw new PluginException(e.toString(), (Throwable)e);
        }
    }

    public void reboot() throws PluginException {
        Connection conn = this.connect();
        try {
            VM vm = this.getVM(conn);
            vm.cleanReboot(conn);
        }
        catch (Exception e) {
            throw new PluginException(e.toString(), (Throwable)e);
        }
    }

    public void forceReboot() throws PluginException {
        Connection conn = this.connect();
        try {
            VM vm = this.getVM(conn);
            vm.hardReboot(conn);
        }
        catch (Exception e) {
            throw new PluginException(e.toString(), (Throwable)e);
        }
    }

    public void resume() throws PluginException {
        Connection conn = this.connect();
        try {
            VM vm = this.getVM(conn);
            vm.resume(conn, false, false);
        }
        catch (Exception e) {
            throw new PluginException(e.toString(), (Throwable)e);
        }
    }

    public void suspend() throws PluginException {
        Connection conn = this.connect();
        try {
            VM vm = this.getVM(conn);
            vm.suspend(conn);
        }
        catch (Exception e) {
            throw new PluginException(e.toString(), (Throwable)e);
        }
    }
}

