/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GFVersionInfo {
    private int[] versions;

    public GFVersionInfo(int major, int minor, int mini, int patch) {
        this.versions = new int[]{major, minor, mini, patch};
    }

    public GFVersionInfo(int major, int minor, int mini) {
        this(major, minor, mini, -1);
    }

    public GFVersionInfo(int major, int minor) {
        this(major, minor, -1, -1);
    }

    public GFVersionInfo(String version) {
        this.versions = new int[]{-1, -1, -1, -1};
        String[] vArray = version.split("\\.");
        int size = vArray.length;
        if (size < 2 || size > 4) {
            throw new IllegalArgumentException("Too many or less fields in given version string:" + version);
        }
        for (int i = 0; i < size; ++i) {
            String string = vArray[i];
            try {
                this.versions[i] = Integer.parseInt(string);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unable to parse version from string:" + version);
            }
        }
    }

    public int getMajor() {
        return this.versions[0];
    }

    public int getMinor() {
        return this.versions[1];
    }

    public int getMini() {
        return this.versions[2];
    }

    public int getPatch() {
        return this.versions[3];
    }

    public boolean isGFVersion(String str) {
        String current = this.toString();
        return current.startsWith(str);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.versions.length && this.versions[i] > -1; ++i) {
            buf.append(this.versions[i]);
            buf.append('.');
        }
        String s = buf.toString();
        return s.substring(0, Math.max(s.length() - 1, 0));
    }

    public static GFVersionInfo parse(String str) {
        Pattern p = Pattern.compile("(\\d+\\.)(\\d+\\.)?(\\d+\\.)?(\\d+)");
        Matcher m = p.matcher(str);
        m.find();
        return new GFVersionInfo(str.substring(m.start(), m.end()));
    }

    public static void main(String[] args) {
        String[] vStrings;
        for (String string : vStrings = new String[]{"Java version:   6.6.1 build 33336 10/21/2011 10:29:38 PDT javac 1.5.0_17", "Java version:   6.5.1.4 build 30577 02/26/2011 11:57:13 PST javac 1.5.0_17", "Java version:   6.5.0 build 30577 02/26/2011 11:57:13 PST javac 1.5.0_17", "Java version:   6.0 build 30577 02/26/2011 11:57:13 PST javac 1.5.0_17"}) {
            GFVersionInfo info = GFVersionInfo.parse(string);
            System.out.print("Compare / " + string);
            System.out.print("\n");
            System.out.print("Version is " + info);
            System.out.print("\n");
            System.out.print("Is this 6.0: " + info.isGFVersion("6.0"));
            System.out.print("\n");
            System.out.print("Is this 6.5: " + info.isGFVersion("6.5"));
            System.out.print("\n");
            System.out.print("Is this 6.6: " + info.isGFVersion("6.6"));
            System.out.print("\n");
        }
    }
}

