/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.detector;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.PlatformResource;
import org.hyperic.hq.product.PluginException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.sigar.ptql.ProcessFinder;
import org.hyperic.util.config.ConfigResponse;

public class GemFirePlatformDetector
extends PlatformDetector {
    private static final Log log = LogFactory.getLog(GemFirePlatformDetector.class);
    private static Sigar sigarImpl = null;
    private static SigarProxy sigar = null;

    public PlatformResource getPlatformResource(ConfigResponse config) throws PluginException {
        long[] pids;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Detecting Gemfire Distributed System");
            log.debug((Object)("Config used for platform detection: " + config));
        }
        if ((pids = GemFirePlatformDetector.getAgentPids()).length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No Gemfire JMX Agent processes detected");
            }
            return super.getPlatformResource(config);
        }
        if (pids.length > 1) {
            log.info((Object)("Detected " + pids.length + " GF JMX Agent processes. Can continue only with 1 process."));
            return super.getPlatformResource(config);
        }
        ConfigResponse productConfig = null;
        String file = this.findAgentProperties(pids[0]);
        if (file != null) {
            Properties p = new Properties();
            try {
                p.load(new FileInputStream(file));
                String pIP = config.getValue("platform.ip");
                String rmiPort = p.getProperty("rmi-port");
                String rmiBindAddress = p.getProperty("rmi-bind-address");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("platform ip:" + pIP));
                    log.debug((Object)("rmi port:" + rmiPort));
                    log.debug((Object)("rmi address:" + rmiBindAddress));
                }
                if (pIP.equals(rmiBindAddress)) {
                    productConfig = new ConfigResponse();
                    productConfig.setValue("jmx.url", "service:jmx:rmi:///jndi/rmi://" + rmiBindAddress + ":" + rmiPort + "/jmxconnector");
                }
            }
            catch (Exception e) {
                log.info((Object)"Can't read Gemfire agent configuration.", (Throwable)e);
            }
        }
        PlatformResource platform = super.getPlatformResource(config);
        if (productConfig != null) {
            platform.setProductConfig(productConfig);
            platform.setMeasurementConfig(ConfigResponse.EMPTY_CONFIG);
        }
        return platform;
    }

    private String findAgentProperties(long pid) {
        String path = null;
        path = this.findFromProcessArguments(pid);
        if (path != null) {
            return path;
        }
        return null;
    }

    private String findFromProcessArguments(long pid) {
        String[] args = GemFirePlatformDetector.getProcArgs(pid);
        for (int i = 0; i < args.length; ++i) {
            String file;
            if (!args[i].startsWith("-dir=") || (file = this.checkPath(args[i].substring(5))) == null) continue;
            return file;
        }
        return null;
    }

    private String checkPath(String dir) {
        File f = new File(dir, "agent.properties");
        if (f.isFile()) {
            return f.getAbsolutePath();
        }
        return null;
    }

    private static SigarProxy getSigar() {
        if (sigar == null) {
            int timeout = 600000;
            sigarImpl = new Sigar();
            sigar = SigarProxyCache.newInstance((Sigar)sigarImpl, (int)timeout);
        }
        return sigar;
    }

    private static long[] getAgentPids() {
        try {
            long[] pids = ProcessFinder.find((SigarProxy)GemFirePlatformDetector.getSigar(), (String)"Args.*.eq=com.gemstone.gemfire.admin.jmx.internal.AgentLauncher");
            return pids;
        }
        catch (SigarException e) {
            return new long[0];
        }
    }

    private static String[] getProcArgs(long pid) {
        try {
            return GemFirePlatformDetector.getSigar().getProcArgs(pid);
        }
        catch (SigarException e) {
            return new String[0];
        }
    }
}

