/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.metric;

import com.vmware.vfabric.hyperic.plugin.vfgf.GFProductPlugin;
import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MemberCache;
import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MetricCache;
import com.vmware.vfabric.hyperic.plugin.vfgf.metric.CustomMetric;
import com.vmware.vfabric.hyperic.plugin.vfgf.metric.GFMeasurementPlugin;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.StringUtil;

public class GFStatsMeasurementPlugin
extends GFMeasurementPlugin {
    private static final Log log = LogFactory.getLog(GFStatsMeasurementPlugin.class);

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        Double value;
        String alias;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Plugin hash id:" + ((Object)((Object)this)).hashCode()));
            log.debug((Object)("Metric:" + metric.toDebugString()));
        }
        Properties mProps = metric.getObjectProperties();
        MemberCache memberCache = ((GFProductPlugin)this.getProductPlugin()).getMemberCache(mProps.getProperty("jmx.url"));
        String workingDirectory = mProps.getProperty("workingDirectory");
        String host = mProps.getProperty("host");
        String name = mProps.getProperty("name");
        String gfid = memberCache.getGfid(workingDirectory, host, name);
        String statname = mProps.getProperty("statname");
        if (gfid == null) {
            memberCache.refresh(mProps);
            if (metric.isAvail()) {
                log.debug((Object)"Don't know gfid, returning down for avail.");
                return new MetricValue(0.0);
            }
            log.debug((Object)"Don't know gfid, returning none.");
            return new MetricValue(Double.NaN);
        }
        MetricCache metricCache = this.getMetricCache(gfid + statname);
        if (metricCache.getMetricCacheLastUpdate() < System.currentTimeMillis() - 55000L) {
            Map<String, Double> stats;
            Object[] keys = metricCache.getTrackKeySet();
            if (log.isDebugEnabled()) {
                if (keys.length > 0) {
                    log.debug((Object)("Time to update metric cache using keys:" + StringUtil.arrayToString((Object[])keys)));
                } else {
                    log.debug((Object)"Time to update metric cache, asking all mbean attributes.");
                }
            }
            metricCache.setMemberOnline((stats = this.collectStats(mProps, (String[])keys)) != null && stats.size() > 0);
            if (!metricCache.isMemberOnline()) {
                memberCache.refresh(mProps);
            }
            if (stats != null) {
                metricCache.getMetricCache().putAll(stats);
            }
            metricCache.setMetricCacheLastUpdate(System.currentTimeMillis());
            metricCache.getMetricCache().put("Availability", stats != null ? 1.0 : 0.0);
        }
        if ((alias = metric.getAttributeName()).startsWith("custom_")) {
            CustomMetric cm = CustomMetric.buildByAlias(alias);
            String[] metrics = cm.getMetrics();
            value = cm.calculate(new Double[]{(Double)metricCache.getMetricCache().get(metrics[0]), (Double)metricCache.getMetricCache().get(metrics[1])});
            metricCache.putToTrackCache(metrics[0], new Double(1.0));
            metricCache.putToTrackCache(metrics[1], new Double(1.0));
        } else {
            value = (Double)metricCache.getMetricCache().get(alias);
            metricCache.putToTrackCache(alias, new Double(1.0));
        }
        if (metricCache.isMemberOnline()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource online, returning metric:" + value));
                if (metric.isAvail()) {
                    log.debug((Object)("Availability is " + value));
                }
            }
            return new MetricValue(value != null ? value : Double.NaN);
        }
        if (metric.isAvail()) {
            log.debug((Object)"Resource not online, returning down for avail.");
            return new MetricValue(0.0);
        }
        log.debug((Object)"Resource not online, returning none.");
        return new MetricValue(Double.NaN);
    }
}

