/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.metric;

import com.vmware.vfabric.hyperic.plugin.vfgf.GFProductPlugin;
import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MemberCache;
import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MemberInfo;
import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MetricCache;
import com.vmware.vfabric.hyperic.plugin.vfgf.metric.CustomMetric;
import com.vmware.vfabric.hyperic.plugin.vfgf.metric.GFMeasurementPlugin;
import com.vmware.vfabric.hyperic.plugin.vfgf.mx.GFJmxConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFVMStatsMeasurementPlugin
extends GFMeasurementPlugin {
    private static final String[] vmstatsMetrics = new String[]{"vmstats-daemonThreads", "vmstats-loadedClasses", "vmstats-cpus", "vmstats-fdLimit", "vmstats-fdsOpen", "vmstats-freeMemory", "vmstats-maxMemory", "vmstats-peakThreads", "vmstats-pendingFinalization", "vmstats-processCpuTime", "vmstats-threadStarts", "vmstats-threads", "vmstats-totalMemory", "vmstats-unloadedClasses"};
    private static final String[] vmheapmemorystatsMetrics = new String[]{"vmheapmemorystats-committedMemory"};
    private static final String[] vmnonheapmemorystatsMetrics = new String[]{"vmnonheapmemorystats-committedMemory"};
    private static final String[] codecacheMetrics = new String[]{"codecache-currentUsedMemory"};
    private static final String[] youngedenMetrics = new String[]{"youngeden-currentUsedMemory"};
    private static final String[] youngsurvivorMetrics = new String[]{"youngsurvivor-currentUsedMemory"};
    private static final String[] oldtenuredMetrics = new String[]{"oldtenured-currentUsedMemory"};
    private static final String[] oldpermanentMetrics = new String[]{"oldpermanent-currentUsedMemory"};
    private static final String[] gccheapMetrics = new String[]{"gccheap-collectionTime", "gccheap-collections"};
    private static final String[] gcexpensiveMetrics = new String[]{"gcexpensive-collectionTime", "gcexpensive-collections"};
    private static final Log log = LogFactory.getLog(GFVMStatsMeasurementPlugin.class);

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        Double value;
        String alias;
        String name;
        String host;
        String workingDirectory;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Plugin hash id:" + ((Object)((Object)this)).hashCode()));
            log.debug((Object)("Metric:" + metric.toDebugString()));
        }
        Properties mProps = metric.getObjectProperties();
        MemberCache memberCache = ((GFProductPlugin)this.getProductPlugin()).getMemberCache(mProps.getProperty("jmx.url"));
        String gfid = memberCache.getGfid(workingDirectory = mProps.getProperty("workingDirectory"), host = mProps.getProperty("host"), name = mProps.getProperty("name"));
        if (gfid == null) {
            memberCache.refresh(mProps);
            if (metric.isAvail()) {
                log.debug((Object)"Don't know gfid, returning down for avail.");
                return new MetricValue(0.0);
            }
            log.debug((Object)"Don't know gfid, returning none.");
            return new MetricValue(Double.NaN);
        }
        MetricCache metricCache = this.getMetricCache(gfid);
        if (metricCache.getMetricCacheLastUpdate() < System.currentTimeMillis() - 55000L) {
            Map<String, Double> stats;
            Object[] keys = metricCache.getTrackKeySet();
            if (log.isDebugEnabled()) {
                if (keys.length > 0) {
                    log.debug((Object)("Time to update metric cache using keys:" + StringUtil.arrayToString((Object[])keys)));
                } else {
                    log.debug((Object)"Time to update metric cache, asking all mbean attributes.");
                }
            }
            metricCache.setMemberOnline((stats = this.collectVMStats(mProps, (String[])keys)) != null && stats.size() > 0);
            if (!metricCache.isMemberOnline()) {
                memberCache.refresh(mProps);
            }
            if (stats != null) {
                metricCache.getMetricCache().putAll(stats);
            }
            metricCache.setMetricCacheLastUpdate(System.currentTimeMillis());
            metricCache.getMetricCache().put("Availability", stats != null ? 1.0 : 0.0);
        }
        if ((alias = metric.getAttributeName()).startsWith("custom_")) {
            CustomMetric cm = CustomMetric.buildByAlias(alias);
            String[] metrics = cm.getMetrics();
            value = cm.calculate(new Double[]{(Double)metricCache.getMetricCache().get(metrics[0]), (Double)metricCache.getMetricCache().get(metrics[1])});
            metricCache.putToTrackCache(metrics[0], new Double(1.0));
            metricCache.putToTrackCache(metrics[1], new Double(1.0));
        } else {
            value = (Double)metricCache.getMetricCache().get(alias);
            metricCache.putToTrackCache(alias, new Double(1.0));
        }
        if (metricCache.isMemberOnline()) {
            log.debug((Object)("Resource online, returning metric:" + value));
            return new MetricValue(value != null ? value : Double.NaN);
        }
        if (metric.isAvail()) {
            log.debug((Object)"Resource not online, returning down for avail.");
            return new MetricValue(0.0);
        }
        log.debug((Object)"Resource not online, returning none.");
        return new MetricValue(Double.NaN);
    }

    protected Map<String, Double> collectVMStats(Properties props, String[] keys) {
        MemberCache memberCache = ((GFProductPlugin)this.getProductPlugin()).getMemberCache(props.getProperty("jmx.url"));
        String workingDirectory = props.getProperty("workingDirectory");
        String host = props.getProperty("host");
        String name = props.getProperty("name");
        MemberInfo member = memberCache.getMember(workingDirectory, host, name);
        GFJmxConnection gf = new GFJmxConnection(props);
        HashMap<String, Double> map = new HashMap<String, Double>();
        Map<String, String[]> requestMap = this.getMetricRequestMap(keys, props);
        if (requestMap.size() == 0) {
            requestMap = this.createDefaultMetricRequestMap(props);
        }
        for (String key : requestMap.keySet()) {
            String[] metrics = requestMap.get(key);
            String prefix = metrics[0].substring(0, metrics[0].indexOf(45));
            Map<String, Double> values = gf.getStatValues(member, key, this.removePrefixes(metrics));
            if (values == null) continue;
            Set<Map.Entry<String, Double>> set = values.entrySet();
            for (Map.Entry<String, Double> entry : set) {
                map.put(prefix + "-" + entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    private Map<String, String[]> createDefaultMetricRequestMap(Properties props) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put(props.getProperty("vmstats"), vmstatsMetrics);
        map.put(props.getProperty("vmheapmemorystats"), vmheapmemorystatsMetrics);
        map.put(props.getProperty("vmnonheapmemorystats"), vmnonheapmemorystatsMetrics);
        map.put(props.getProperty("codecache"), codecacheMetrics);
        map.put(props.getProperty("youngeden"), youngedenMetrics);
        map.put(props.getProperty("youngsurvivor"), youngsurvivorMetrics);
        map.put(props.getProperty("oldtenured"), oldtenuredMetrics);
        map.put(props.getProperty("oldpermanent"), oldpermanentMetrics);
        map.put(props.getProperty("gccheap"), gccheapMetrics);
        map.put(props.getProperty("gcexpensive"), gcexpensiveMetrics);
        return map;
    }

    private Map<String, String[]> getMetricRequestMap(String[] keys, Properties props) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (String key : keys) {
            int dashIndex = key.indexOf(45);
            if (dashIndex < 0) continue;
            String prefix = key.substring(0, dashIndex);
            if (!map.containsKey(props.getProperty(prefix))) {
                map.put(props.getProperty(prefix), new String[0]);
            }
            String[] array = (String[])map.get(props.getProperty(prefix));
            String[] extended = new String[array.length + 1];
            System.arraycopy(array, 0, extended, 0, array.length);
            extended[extended.length - 1] = key;
            map.put(props.getProperty(prefix), extended);
        }
        return map;
    }

    private String[] removePrefixes(String[] array) {
        String[] fixedArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            fixedArray[i] = array[i].substring(array[i].indexOf(45) + 1);
        }
        return fixedArray;
    }
}

