/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.HashSet;
import org.hyperic.hq.appdef.shared.AIServiceValue;
import org.hyperic.hq.plugin.system.OperatingSystemReflection;
import org.hyperic.hq.plugin.system.SystemServerDetector;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.win32.Pdh;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.EncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HypervDetector
extends SystemServerDetector {
    @Override
    protected String getServerType() {
        return "HyperVServer";
    }

    protected ArrayList<AIServiceValue> getHyperVServices(String propertySet, String type, String namePrefix, String token, boolean toLower) {
        ArrayList<AIServiceValue> services = new ArrayList<AIServiceValue>();
        try {
            String[] instances = Pdh.getInstances((String)propertySet);
            log.debug((Object)("num of instances found=" + instances.length));
            HashSet<String> names = new HashSet<String>();
            for (int i = 0; i < instances.length; ++i) {
                String instance = instances[i];
                log.debug((Object)("instance=<" + instance + ">"));
                if ("_Total".equals(instance) || "<All instances>".equals(instance)) continue;
                StringTokenizer st = new StringTokenizer(instance, token);
                String name = (String)st.nextElement();
                names.add(name);
            }
            for (String name : names) {
                String info = namePrefix + name;
                AIServiceValue svc = this.createSystemService(type, this.getFullServiceName(info));
                try {
                    ConfigResponse cprops = new ConfigResponse();
                    svc.setCustomProperties(cprops.encode());
                    ConfigResponse conf = new ConfigResponse();
                    conf.setValue("instance.name", name);
                    conf.setValue(propertySet, name);
                    svc.setProductConfig(conf.encode());
                    svc.setMeasurementConfig(ConfigResponse.EMPTY_CONFIG);
                }
                catch (EncodingException e) {
                    // empty catch block
                }
                services.add(svc);
            }
            if (services.isEmpty()) {
                log.debug((Object)"no servers found");
                return null;
            }
            return services;
        }
        catch (Win32Exception e) {
            log.debug((Object)("Error getting pdh data for " + propertySet + ": " + (Object)((Object)e)), (Throwable)e);
            return null;
        }
    }

    @Override
    protected ArrayList<AIServiceValue> getSystemServiceValues(Sigar sigar, ConfigResponse config) throws SigarException {
        AIServiceValue memoryServices;
        ArrayList<AIServiceValue> logicalProcessorServices;
        ArrayList<AIServiceValue> diskServices;
        if (!OperatingSystemReflection.IS_HYPER_V()) {
            return null;
        }
        ArrayList<AIServiceValue> services = new ArrayList<AIServiceValue>();
        ArrayList<AIServiceValue> netServices = this.getHyperVServices("Network Interface", "HyperV Network Interface", "Network Interface - ", "", false);
        if (netServices != null && !netServices.isEmpty()) {
            services.addAll(netServices);
        }
        if ((diskServices = this.getHyperVServices("PhysicalDisk", "HyperV Physical Disk", "PhysicalDisk - ", "", true)) != null && !diskServices.isEmpty()) {
            services.addAll(diskServices);
        }
        if ((logicalProcessorServices = this.getHyperVServices("Hyper-V Hypervisor Logical Processor", "Hyper-V Logical Processor", "Logical Processor - ", "", false)) != null && !logicalProcessorServices.isEmpty()) {
            services.addAll(logicalProcessorServices);
        }
        if ((memoryServices = this.getHyperVMemoryService()) != null) {
            services.add(memoryServices);
        }
        return services;
    }

    private AIServiceValue getHyperVMemoryService() {
        String info = "Hyper-V Memory";
        AIServiceValue svc = this.createSystemService("Hyper-V Memory", this.getFullServiceName(info));
        svc.setMeasurementConfig(ConfigResponse.EMPTY_CONFIG);
        svc.setProductConfig(ConfigResponse.EMPTY_CONFIG);
        return svc;
    }
}

