/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.hyperic.hq.plugin.system.OperatingSystemReflection;
import org.hyperic.hq.plugin.system.UnixLogTrackPlugin;
import org.hyperic.hq.plugin.system.VMwareGuestInfo;
import org.hyperic.hq.plugin.system.WindowsLogTrackPlugin;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.PlatformResource;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.PluginNotFoundException;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.NetInfo;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.win32.Service;
import org.hyperic.util.HostIP;
import org.hyperic.util.config.ConfigResponse;

public class SigarPlatformDetector
extends PlatformDetector {
    private static final String PROP_PLATFORM_IP_IGNORE = "platform.ip.ignore";
    private static final String PROP_PLATFORM_IP_DISCOVER = "platform.ip.discover";
    private String fqdn;
    private String ip;
    private boolean ipDiscover;
    private PluginManager manager;
    private final Map ipIgnore = new HashMap();
    private boolean hasControlActions;
    private String macAddress = null;

    public SigarPlatformDetector() {
    }

    public SigarPlatformDetector(boolean hasPlatformControlActions) {
        this.hasControlActions = hasPlatformControlActions;
    }

    public void init(PluginManager manager) throws PluginException {
        String filter;
        super.init(manager);
        Properties props = manager.getProperties();
        this.manager = manager;
        this.fqdn = props.getProperty("platform.fqdn");
        this.ip = props.getProperty("platform.ip");
        this.macAddress = props.getProperty("platform.macaddr");
        this.ipDiscover = !"false".equals(props.getProperty(PROP_PLATFORM_IP_DISCOVER));
        String prop = "platform.networkConnected";
        String networkConnected = props.getProperty("platform.networkConnected");
        if ("false".equals(networkConnected)) {
            this.ipDiscover = false;
            this.getLog().warn((Object)"platform.networkConnected is deprecated, use platform.ip.discover=false instead");
        }
        if ((filter = props.getProperty(PROP_PLATFORM_IP_IGNORE)) != null) {
            StringTokenizer tok = new StringTokenizer(filter, ",");
            while (tok.hasMoreTokens()) {
                this.ipIgnore.put(tok.nextToken(), Boolean.TRUE);
            }
        }
    }

    private void setValue(ConfigResponse cprops, String key, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        cprops.setValue(key, value);
    }

    private void getPlatformVz(PlatformResource platform, Sigar sigar) {
        try {
            this.manager.getParent().getPlugin("vmware");
        }
        catch (PluginNotFoundException e) {
            return;
        }
        Map info = VMwareGuestInfo.getGuestInfo(sigar);
        if (info == null) {
            return;
        }
        String id = (String)info.get("platform.id");
        String name = (String)info.get("platform.name");
        if (id == null || name == null) {
            return;
        }
        String href = "<a href=\"/Resource.do?eid=1:" + id + "\">" + name + "</a>";
        String description = platform.getDescription() + " (VM Guest of " + href + ")";
        platform.setDescription(description);
    }

    private ConfigResponse getProductConfig(PlatformResource platform) {
        ConfigResponse productConfig = null;
        try {
            byte[] encodedConfig = platform.getProductConfig();
            productConfig = encodedConfig == null ? new ConfigResponse() : ConfigResponse.decode((byte[])encodedConfig);
            return productConfig;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setHyperVPlatformProperties(PlatformResource platform) {
        if (!OperatingSystemReflection.IS_HYPER_V()) {
            return;
        }
        ConfigResponse productConfig = this.getProductConfig(platform);
        if (productConfig == null) {
            return;
        }
        try {
            Service hypervService = null;
            hypervService = new Service("vmms");
            int status = hypervService.getStatus();
            if (status == 4) {
                productConfig.setValue("allow_remove", "true");
                this.getLog().debug((Object)"vmms is  running setting allow_remove to true");
            } else {
                productConfig.setValue("allow_remove", "false");
                this.getLog().info((Object)"vmms not running setting allow_remove to false");
            }
            platform.setProductConfig(productConfig);
        }
        catch (Exception e) {
            productConfig.setValue("allow_remove", "false");
            platform.setProductConfig(productConfig);
            this.getLog().info((Object)("setHyperVPlatformProperties: exception  setting allow to remove to false " + e.getMessage()));
        }
    }

    public PlatformResource getPlatformResource(ConfigResponse config) throws PluginException {
        PlatformResource platform = new PlatformResource();
        if (this.hasControlActions) {
            platform.setControlConfig();
        }
        ConfigResponse cprops = new ConfigResponse();
        platform.setPlatformTypeName(OperatingSystemReflection.getName());
        Sigar sigar = new Sigar();
        HashMap<String, Boolean> ips = new HashMap<String, Boolean>();
        platform.setDescription(OperatingSystemReflection.getDescription());
        String fqdn = this.fqdn;
        String ip = null;
        ips.putAll(this.ipIgnore);
        try {
            String msg;
            if (fqdn == null) {
                fqdn = sigar.getFQDN();
            }
            platform.setFqdn(fqdn);
            if (HostIP.isValidIP((String)platform.getFqdn())) {
                platform.setName(SigarPlatformDetector.getPlatformName());
            }
            String[] interfaces = sigar.getNetInterfaceList();
            if (this.ip != null) {
                this.getLog().info((Object)("Adding dummy ip address=" + this.ip));
                platform.addInterface(this.ip, "255.255.255.0", "00:00:00:00:00:00");
            }
            for (String name : interfaces) {
                String mac;
                String address;
                NetInterfaceConfig ifconfig;
                try {
                    ifconfig = sigar.getNetInterfaceConfig(name);
                }
                catch (SigarException e) {
                    this.getLog().debug((Object)("getNetInterfaceConfig(" + name + "): " + e.getMessage()), (Throwable)e);
                    continue;
                }
                long flags = ifconfig.getFlags();
                if ((flags & 1L) <= 0L || (flags & 0x10L) > 0L || (address = ifconfig.getAddress()).equals("0.0.0.0")) continue;
                String string = mac = this.macAddress == null ? ifconfig.getHwaddr() : this.macAddress;
                if ((flags & 8L) > 0L) {
                    if (!address.equals("127.0.0.1")) continue;
                    mac = "00:00:00:00:00:00";
                } else if (ip == null) {
                    ip = address;
                }
                if (SigarPlatformDetector.isWin32()) {
                    String MS_LOOPBACK = "Microsoft Loopback Adapter";
                    if ("Microsoft Loopback Adapter".equals(ifconfig.getDescription())) continue;
                }
                if (!this.ipDiscover && (flags & 8L) <= 0L) {
                    this.getLog().info((Object)("platform.ip.discover=false, skipping interface=" + name + ", ip=" + address));
                    continue;
                }
                if (ips.get(address) != null) continue;
                ips.put(address, Boolean.TRUE);
                this.getLog().info((Object)("adding interface name=" + ifconfig.getName() + ", address=" + address + ", netmask=" + ifconfig.getNetmask() + ", mac=" + mac));
                platform.addInterface(address, ifconfig.getNetmask(), mac);
            }
            try {
                Mem mem = sigar.getMem();
                cprops.setValue("ram", mem.getRam() + " MB");
            }
            catch (SigarException e) {
                String msg2 = "Error getting memory info: " + e.getMessage();
                this.getLog().warn((Object)msg2);
                this.getLog().debug((Object)msg2, (Throwable)e);
            }
            try {
                CpuInfo[] infos = sigar.getCpuInfoList();
                CpuInfo info = infos[0];
                int numSockets = info.getTotalSockets();
                int numCores = info.getCoresPerSocket();
                int numTotal = info.getTotalCores();
                platform.setCpuCount(new Integer(numSockets));
                String cpuSpeed = info.getMhz() + " MHz";
                if (numTotal > 1) {
                    cpuSpeed = numTotal + " @ " + cpuSpeed;
                    if (numCores != 1) {
                        cpuSpeed = cpuSpeed + " (" + numSockets + "x" + numCores + ")";
                    }
                }
                cprops.setValue("cpuSpeed", cpuSpeed);
            }
            catch (SigarException e) {
                msg = "Error getting cpu info: " + e.getMessage();
                this.getLog().warn((Object)msg);
                this.getLog().debug((Object)msg, (Throwable)e);
                platform.setCpuCount(new Integer(1));
            }
            this.setValue(cprops, "ip", ip);
            try {
                NetInfo info = sigar.getNetInfo();
                this.setValue(cprops, "primaryDNS", info.getPrimaryDns());
                this.setValue(cprops, "secondaryDNS", info.getSecondaryDns());
                this.setValue(cprops, "defaultGateway", info.getDefaultGateway());
            }
            catch (SigarException e) {
                msg = "Error getting net info: " + e.getMessage();
                this.getLog().warn((Object)msg);
                this.getLog().debug((Object)msg, (Throwable)e);
            }
            this.getPlatformVz(platform, sigar);
        }
        catch (SigarException se) {
            String msg = "Error retrieving system information: " + se.getMessage();
            throw new PluginException(msg, (Throwable)se);
        }
        finally {
            sigar.close();
        }
        cprops.setValue("arch", OperatingSystemReflection.getArch());
        cprops.setValue("version", OperatingSystemReflection.getVersion());
        cprops.setValue("vendor", OperatingSystemReflection.getVendor());
        cprops.setValue("vendorVersion", OperatingSystemReflection.getVendorVersion());
        platform.setCustomProperties(cprops);
        ConfigResponse mconfig = new ConfigResponse();
        if (SigarPlatformDetector.isWin32()) {
            WindowsLogTrackPlugin.setDefaultConfig(mconfig);
        } else {
            UnixLogTrackPlugin.setDefaultConfig(mconfig);
        }
        platform.setMeasurementConfig(mconfig, 4, true);
        this.setHyperVPlatformProperties(platform);
        return platform;
    }
}

